/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.core.utils;

import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;

public class EventLog<L, E> {
    private final L listener;
    private final AtomicBoolean open = new AtomicBoolean();
    private final Queue<E> events = new ConcurrentLinkedQueue();
    private final Queue<CompletableFuture<E>> futures = new ConcurrentLinkedQueue<CompletableFuture<E>>();

    public EventLog(Function<EventLog<L, E>, L> listenerFactory) {
        this.listener = listenerFactory.apply(this);
    }

    public boolean open() {
        return this.open.compareAndSet(false, true);
    }

    public L listener() {
        return this.listener;
    }

    public CompletableFuture<E> nextEvent() {
        E event = this.events.poll();
        if (event != null) {
            return CompletableFuture.completedFuture(event);
        }
        CompletableFuture future = new CompletableFuture();
        this.futures.add(future);
        return future;
    }

    public void addEvent(E event) {
        CompletableFuture<E> future = this.futures.poll();
        if (future != null) {
            future.complete(event);
        } else {
            this.events.add(event);
            if (this.events.size() > 100) {
                this.events.remove();
            }
        }
    }

    public boolean close() {
        if (this.open.compareAndSet(true, false)) {
            this.futures.forEach(future -> future.completeExceptionally(new IllegalStateException("Closed session")));
            return true;
        }
        return false;
    }
}

