/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.core.utils.config;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.typesafe.config.Config;
import io.atomix.core.AtomixRegistry;
import io.atomix.core.utils.config.PolymorphicTypeMapper;
import io.atomix.utils.config.ConfigMapper;
import io.atomix.utils.config.ConfigurationException;
import io.atomix.utils.config.TypedConfig;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;

public class PolymorphicConfigMapper
extends ConfigMapper {
    private final AtomixRegistry registry;
    private final Map<Class, PolymorphicTypeMapper> polymorphicTypes = Maps.newHashMap();

    public PolymorphicConfigMapper(ClassLoader classLoader, AtomixRegistry registry) {
        this(classLoader, registry, Collections.emptyList());
    }

    public PolymorphicConfigMapper(ClassLoader classLoader, AtomixRegistry registry, PolymorphicTypeMapper ... mappers) {
        this(classLoader, registry, Arrays.asList(mappers));
    }

    public PolymorphicConfigMapper(ClassLoader classLoader, AtomixRegistry registry, Collection<PolymorphicTypeMapper> mappers) {
        super(classLoader);
        this.registry = (AtomixRegistry)Preconditions.checkNotNull((Object)registry);
        mappers.forEach(mapper -> this.polymorphicTypes.put(mapper.getConfigClass(), (PolymorphicTypeMapper)mapper));
    }

    protected <T> T newInstance(Config config, Class<T> clazz) {
        Object instance;
        if (this.isPolymorphicType(clazz)) {
            PolymorphicTypeMapper typeMapper = this.polymorphicTypes.get(clazz);
            if (typeMapper == null) {
                throw new ConfigurationException("Cannot instantiate abstract type " + clazz.getName());
            }
            String typeName = config.getString(typeMapper.getTypePath());
            Class<TypedConfig<?>> concreteClass = typeMapper.getConcreteClass(this.registry, typeName);
            try {
                instance = concreteClass.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new ConfigurationException(concreteClass.getName() + " needs a public no-args constructor to be used as a bean", (Throwable)e);
            }
        }
        try {
            instance = clazz.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new ConfigurationException(clazz.getName() + " needs a public no-args constructor to be used as a bean", (Throwable)e);
        }
        return instance;
    }

    protected void checkRemainingProperties(Set<String> propertyNames, String path, Class<?> clazz) {
        Properties properties = System.getProperties();
        Set cleanNames = propertyNames.stream().filter(propertyName -> !this.isPolymorphicType(clazz) || !propertyName.equals(this.polymorphicTypes.get(clazz).getTypePath())).map(propertyName -> this.toPath(path, (String)propertyName)).filter(propertyName -> !properties.containsKey(propertyName)).filter(propertyName -> properties.entrySet().stream().noneMatch(entry -> entry.getKey().toString().startsWith(propertyName + "."))).collect(Collectors.toSet());
        if (!cleanNames.isEmpty()) {
            throw new ConfigurationException("Unknown properties present in configuration: " + Joiner.on((String)", ").join(cleanNames));
        }
    }

    private boolean isPolymorphicType(Class<?> clazz) {
        return this.polymorphicTypes.containsKey(clazz);
    }
}

