/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.core.value.impl;

import com.google.common.base.MoreObjects;
import com.google.common.collect.Maps;
import io.atomix.core.value.AsyncAtomicValue;
import io.atomix.core.value.AtomicValue;
import io.atomix.core.value.AtomicValueEvent;
import io.atomix.core.value.AtomicValueEventListener;
import io.atomix.core.value.impl.BlockingAtomicValue;
import io.atomix.primitive.impl.DelegatingAsyncPrimitive;
import io.atomix.utils.event.Event;
import java.time.Duration;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;

public class TranscodingAsyncAtomicValue<V1, V2>
extends DelegatingAsyncPrimitive
implements AsyncAtomicValue<V1> {
    private final AsyncAtomicValue<V2> backingValue;
    private final Function<V1, V2> valueEncoder;
    private final Function<V2, V1> valueDecoder;
    private final Map<AtomicValueEventListener<V1>, InternalAtomicValueEventListener> listeners = Maps.newIdentityHashMap();

    public TranscodingAsyncAtomicValue(AsyncAtomicValue<V2> backingValue, Function<V1, V2> valueEncoder, Function<V2, V1> valueDecoder) {
        super(backingValue);
        this.backingValue = backingValue;
        this.valueEncoder = v -> v != null ? valueEncoder.apply(v) : null;
        this.valueDecoder = v -> v != null ? valueDecoder.apply(v) : null;
    }

    @Override
    public CompletableFuture<Boolean> compareAndSet(V1 expect, V1 update) {
        return this.backingValue.compareAndSet(this.valueEncoder.apply(expect), this.valueEncoder.apply(update));
    }

    @Override
    public CompletableFuture<V1> get() {
        return this.backingValue.get().thenApply(this.valueDecoder);
    }

    @Override
    public CompletableFuture<V1> getAndSet(V1 value) {
        return this.backingValue.getAndSet(this.valueEncoder.apply(value)).thenApply(this.valueDecoder);
    }

    @Override
    public CompletableFuture<Void> set(V1 value) {
        return this.backingValue.set(this.valueEncoder.apply(value));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<Void> addListener(AtomicValueEventListener<V1> listener) {
        Map<AtomicValueEventListener<V1>, InternalAtomicValueEventListener> map = this.listeners;
        synchronized (map) {
            InternalAtomicValueEventListener internalListener = this.listeners.computeIfAbsent(listener, k -> new InternalAtomicValueEventListener(listener));
            return this.backingValue.addListener(internalListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<Void> removeListener(AtomicValueEventListener<V1> listener) {
        Map<AtomicValueEventListener<V1>, InternalAtomicValueEventListener> map = this.listeners;
        synchronized (map) {
            InternalAtomicValueEventListener internalListener = this.listeners.remove(listener);
            if (internalListener != null) {
                return this.backingValue.removeListener(internalListener);
            }
            return CompletableFuture.completedFuture(null);
        }
    }

    @Override
    public AtomicValue<V1> sync(Duration operationTimeout) {
        return new BlockingAtomicValue(this, operationTimeout.toMillis());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("backingValue", this.backingValue).toString();
    }

    private class InternalAtomicValueEventListener
    implements AtomicValueEventListener<V2> {
        private final AtomicValueEventListener<V1> listener;

        InternalAtomicValueEventListener(AtomicValueEventListener<V1> listener) {
            this.listener = listener;
        }

        public void event(AtomicValueEvent<V2> event) {
            this.listener.event((Event)new AtomicValueEvent(AtomicValueEvent.Type.UPDATE, TranscodingAsyncAtomicValue.this.valueDecoder.apply(event.newValue()), TranscodingAsyncAtomicValue.this.valueDecoder.apply(event.oldValue())));
        }
    }
}

