/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.metric;

import io.micrometer.prometheus.PrometheusMeterRegistry;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrometheusServlet
extends HttpServlet {
    private static final Logger LOGGER = LoggerFactory.getLogger(PrometheusServlet.class);
    private static final long serialVersionUID = 3954804532706721368L;
    private final PrometheusMeterRegistry promMetricRegistry;
    private static final String CACHE_CONTROL = "Cache-Control";
    private static final String NO_CACHE = "must-revalidate,no-cache,no-store";

    public PrometheusServlet(PrometheusMeterRegistry promMetricRegistry) {
        this.promMetricRegistry = promMetricRegistry;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        resp.setStatus(200);
        resp.setHeader(CACHE_CONTROL, NO_CACHE);
        resp.setContentType("text/plain; version=0.0.4; charset=utf-8");
        try (PrintWriter writer = resp.getWriter();){
            this.promMetricRegistry.scrape((Writer)writer);
        }
        catch (IOException e) {
            LOGGER.error("IOException in PrometheusServlet", (Throwable)e);
        }
    }
}

