/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.rest;

import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.apache.zeppelin.annotation.ZeppelinApi;
import org.apache.zeppelin.common.SessionInfo;
import org.apache.zeppelin.interpreter.InterpreterSettingManager;
import org.apache.zeppelin.notebook.Notebook;
import org.apache.zeppelin.rest.exception.SessionNoteFoundException;
import org.apache.zeppelin.server.JsonResponse;
import org.apache.zeppelin.service.SessionManagerService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/session")
@Produces(value={"application/json"})
@Singleton
public class SessionRestApi {
    private static final Logger LOGGER = LoggerFactory.getLogger(SessionRestApi.class);
    private final SessionManagerService sessionManagerService;

    @Inject
    public SessionRestApi(Notebook notebook, InterpreterSettingManager interpreterSettingManager) {
        this.sessionManagerService = new SessionManagerService(notebook, interpreterSettingManager);
    }

    @GET
    public Response listSessions(@QueryParam(value="interpreter") String interpreter) throws Exception {
        if (StringUtils.isBlank((CharSequence)interpreter)) {
            LOGGER.info("List all sessions of all interpreters");
        } else {
            LOGGER.info("List all sessions for interpreter: {}", (Object)interpreter);
        }
        List<SessionInfo> sessionList = null;
        sessionList = StringUtils.isBlank((CharSequence)interpreter) ? this.sessionManagerService.listSessions() : this.sessionManagerService.listSessions(interpreter);
        return new JsonResponse<List<SessionInfo>>(Response.Status.OK, sessionList).build();
    }

    @POST
    public Response createSession(@QueryParam(value="interpreter") String interpreter) throws Exception {
        LOGGER.info("Create new session for interpreter: {}", (Object)interpreter);
        SessionInfo sessionInfo = this.sessionManagerService.createSession(interpreter);
        return new JsonResponse<SessionInfo>(Response.Status.OK, sessionInfo).build();
    }

    @DELETE
    @Path(value="{sessionId}")
    public Response stopSession(@PathParam(value="sessionId") String sessionId) {
        LOGGER.info("Stop session: {}", (Object)sessionId);
        try {
            this.sessionManagerService.stopSession(sessionId);
            return new JsonResponse<String>(Response.Status.OK, sessionId).build();
        }
        catch (Exception e) {
            return new JsonResponse<String>(Response.Status.INTERNAL_SERVER_ERROR, e.getMessage()).build();
        }
    }

    @GET
    @Path(value="{sessionId}")
    @ZeppelinApi
    public Response getSession(@PathParam(value="sessionId") String sessionId) throws Exception {
        SessionInfo sessionInfo = this.sessionManagerService.getSessionInfo(sessionId);
        if (sessionInfo == null) {
            throw new SessionNoteFoundException(sessionId);
        }
        return new JsonResponse<SessionInfo>(Response.Status.OK, "", sessionInfo).build();
    }
}

