/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.okhttp;

import io.fabric8.kubernetes.client.http.HttpClient;
import io.fabric8.kubernetes.client.http.TlsVersion;
import io.fabric8.kubernetes.client.okhttp.OkHttpClientImpl;
import io.fabric8.kubernetes.client.okhttp.OkHttpRequestImpl;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import okhttp3.Authenticator;
import okhttp3.ConnectionSpec;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.logging.HttpLoggingInterceptor;

class OkHttpClientBuilderImpl
implements HttpClient.Builder {
    private boolean streaming;
    private OkHttpClient.Builder builder;

    public OkHttpClientBuilderImpl(OkHttpClient.Builder newBuilder) {
        this.builder = newBuilder;
    }

    @Override
    public OkHttpClientImpl build() {
        OkHttpClient client = this.builder.build();
        if (this.streaming) {
            for (Interceptor i : client.networkInterceptors()) {
                if (!(i instanceof HttpLoggingInterceptor)) continue;
                HttpLoggingInterceptor interceptor = (HttpLoggingInterceptor)i;
                interceptor.setLevel(HttpLoggingInterceptor.Level.BASIC);
            }
        }
        return new OkHttpClientImpl(client);
    }

    @Override
    public HttpClient.Builder readTimeout(long readTimeout, TimeUnit unit) {
        this.builder.readTimeout(readTimeout, unit);
        return this;
    }

    @Override
    public HttpClient.Builder connectTimeout(long connectTimeout, TimeUnit unit) {
        this.builder.connectTimeout(connectTimeout, unit);
        return this;
    }

    @Override
    public HttpClient.Builder writeTimeout(long timeout, TimeUnit timeoutUnit) {
        this.builder.writeTimeout(timeout, timeoutUnit);
        return this;
    }

    @Override
    public HttpClient.Builder forStreaming() {
        this.builder.cache(null);
        this.streaming = true;
        return this;
    }

    @Override
    public HttpClient.Builder addOrReplaceInterceptor(String name, io.fabric8.kubernetes.client.http.Interceptor interceptor) {
        List<Interceptor> interceptors = this.builder.interceptors();
        for (int i = 0; i < interceptors.size(); ++i) {
            InteceptorAdapter adapter;
            Interceptor exiting = interceptors.get(i);
            if (!(exiting instanceof InteceptorAdapter) || !(adapter = (InteceptorAdapter)exiting).getName().equals(name)) continue;
            if (interceptor == null) {
                interceptors.remove(i);
            } else {
                interceptors.set(i, new InteceptorAdapter(interceptor, name));
            }
            return this;
        }
        if (interceptor != null) {
            this.builder.addInterceptor(new InteceptorAdapter(interceptor, name));
        }
        return this;
    }

    @Override
    public HttpClient.Builder authenticatorNone() {
        this.builder.authenticator(Authenticator.NONE);
        return this;
    }

    @Override
    public HttpClient.Builder sslContext(SSLContext context, TrustManager[] trustManagers) {
        X509TrustManager trustManager = null;
        if (trustManagers != null && trustManagers.length == 1) {
            trustManager = (X509TrustManager)trustManagers[0];
        }
        this.builder.sslSocketFactory(context.getSocketFactory(), trustManager);
        return this;
    }

    @Override
    public HttpClient.Builder followAllRedirects() {
        this.builder.followRedirects(true).followSslRedirects(true);
        return this;
    }

    @Override
    public HttpClient.Builder proxyAddress(InetSocketAddress proxyAddress) {
        if (proxyAddress == null) {
            this.builder.proxy(Proxy.NO_PROXY);
        } else {
            this.builder.proxy(new Proxy(Proxy.Type.HTTP, proxyAddress));
        }
        return this;
    }

    @Override
    public HttpClient.Builder proxyAuthorization(String credentials) {
        this.builder.proxyAuthenticator((route, response) -> response.request().newBuilder().header("Proxy-Authorization", credentials).build());
        return this;
    }

    @Override
    public HttpClient.Builder tlsVersions(TlsVersion[] tlsVersions) {
        ConnectionSpec spec = new ConnectionSpec.Builder(ConnectionSpec.MODERN_TLS).tlsVersions((okhttp3.TlsVersion[])Arrays.asList(tlsVersions).stream().map(tls -> okhttp3.TlsVersion.valueOf(tls.name())).toArray(okhttp3.TlsVersion[]::new)).build();
        this.builder.connectionSpecs(Arrays.asList(spec, ConnectionSpec.CLEARTEXT));
        return this;
    }

    @Override
    public HttpClient.Builder preferHttp11() {
        this.builder.protocols(Collections.singletonList(Protocol.HTTP_1_1));
        return this;
    }

    static final class InteceptorAdapter
    implements Interceptor {
        private final io.fabric8.kubernetes.client.http.Interceptor interceptor;
        private final String name;

        InteceptorAdapter(io.fabric8.kubernetes.client.http.Interceptor interceptor, String name) {
            this.interceptor = interceptor;
            this.name = name;
        }

        @Override
        public Response intercept(Interceptor.Chain chain) throws IOException {
            boolean call;
            Request.Builder requestBuilder = chain.request().newBuilder();
            OkHttpRequestImpl.BuilderImpl builderImpl = new OkHttpRequestImpl.BuilderImpl(requestBuilder);
            this.interceptor.before(new OkHttpRequestImpl.BuilderImpl(requestBuilder), new OkHttpRequestImpl(chain.request()));
            Response response = chain.proceed(requestBuilder.build());
            if (!response.isSuccessful() && (call = this.interceptor.afterFailure(builderImpl, new OkHttpClientImpl.OkHttpResponseImpl<InputStream>(response, InputStream.class)))) {
                response.close();
                return chain.proceed(requestBuilder.build());
            }
            return response;
        }

        public String getName() {
            return this.name;
        }
    }
}

