/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.api.core.metadata;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.metadata.Node;
import com.datastax.oss.driver.api.core.metadata.token.Token;
import com.datastax.oss.driver.api.core.metadata.token.TokenRange;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableSet;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.nio.ByteBuffer;
import java.util.Set;

public interface TokenMap {
    @NonNull
    public Token parse(@NonNull String var1);

    @NonNull
    public String format(@NonNull Token var1);

    @NonNull
    public Token newToken(ByteBuffer ... var1);

    @NonNull
    public TokenRange newTokenRange(@NonNull Token var1, @NonNull Token var2);

    @NonNull
    public Set<TokenRange> getTokenRanges();

    @NonNull
    public Set<TokenRange> getTokenRanges(Node var1);

    @NonNull
    default public Set<Token> getTokens(@NonNull Node node) {
        ImmutableSet.Builder result2 = ImmutableSet.builder();
        for (TokenRange range : this.getTokenRanges(node)) {
            result2.add(range.getEnd());
        }
        return result2.build();
    }

    @NonNull
    public Set<TokenRange> getTokenRanges(@NonNull CqlIdentifier var1, @NonNull Node var2);

    @NonNull
    default public Set<TokenRange> getTokenRanges(@NonNull String keyspaceName, @NonNull Node replica) {
        return this.getTokenRanges(CqlIdentifier.fromCql(keyspaceName), replica);
    }

    @NonNull
    public Set<Node> getReplicas(@NonNull CqlIdentifier var1, @NonNull ByteBuffer var2);

    @NonNull
    default public Set<Node> getReplicas(@NonNull String keyspaceName, @NonNull ByteBuffer partitionKey) {
        return this.getReplicas(CqlIdentifier.fromCql(keyspaceName), partitionKey);
    }

    @NonNull
    public Set<Node> getReplicas(@NonNull CqlIdentifier var1, @NonNull Token var2);

    @NonNull
    default public Set<Node> getReplicas(@NonNull String keyspaceName, @NonNull Token token) {
        return this.getReplicas(CqlIdentifier.fromCql(keyspaceName), token);
    }

    @NonNull
    default public Set<Node> getReplicas(@NonNull CqlIdentifier keyspace, @NonNull TokenRange range) {
        return this.getReplicas(keyspace, range.getEnd());
    }

    @NonNull
    default public Set<Node> getReplicas(@NonNull String keyspaceName, @NonNull TokenRange range) {
        return this.getReplicas(CqlIdentifier.fromCql(keyspaceName), range);
    }

    @NonNull
    public String getPartitionerName();
}

