/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.cql;

import com.datastax.oss.driver.api.core.ConsistencyLevel;
import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.ProtocolVersion;
import com.datastax.oss.driver.api.core.config.DefaultDriverOption;
import com.datastax.oss.driver.api.core.config.DriverConfig;
import com.datastax.oss.driver.api.core.config.DriverExecutionProfile;
import com.datastax.oss.driver.api.core.context.DriverContext;
import com.datastax.oss.driver.api.core.cql.AsyncResultSet;
import com.datastax.oss.driver.api.core.cql.BatchStatement;
import com.datastax.oss.driver.api.core.cql.BatchableStatement;
import com.datastax.oss.driver.api.core.cql.BoundStatement;
import com.datastax.oss.driver.api.core.cql.ColumnDefinition;
import com.datastax.oss.driver.api.core.cql.ColumnDefinitions;
import com.datastax.oss.driver.api.core.cql.ExecutionInfo;
import com.datastax.oss.driver.api.core.cql.PrepareRequest;
import com.datastax.oss.driver.api.core.cql.PreparedStatement;
import com.datastax.oss.driver.api.core.cql.SimpleStatement;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.api.core.metadata.Node;
import com.datastax.oss.driver.api.core.metadata.schema.ColumnMetadata;
import com.datastax.oss.driver.api.core.metadata.schema.RelationMetadata;
import com.datastax.oss.driver.api.core.retry.RetryPolicy;
import com.datastax.oss.driver.api.core.servererrors.AlreadyExistsException;
import com.datastax.oss.driver.api.core.servererrors.BootstrappingException;
import com.datastax.oss.driver.api.core.servererrors.CASWriteUnknownException;
import com.datastax.oss.driver.api.core.servererrors.CDCWriteFailureException;
import com.datastax.oss.driver.api.core.servererrors.CoordinatorException;
import com.datastax.oss.driver.api.core.servererrors.FunctionFailureException;
import com.datastax.oss.driver.api.core.servererrors.InvalidConfigurationInQueryException;
import com.datastax.oss.driver.api.core.servererrors.InvalidQueryException;
import com.datastax.oss.driver.api.core.servererrors.OverloadedException;
import com.datastax.oss.driver.api.core.servererrors.ProtocolError;
import com.datastax.oss.driver.api.core.servererrors.ReadFailureException;
import com.datastax.oss.driver.api.core.servererrors.ReadTimeoutException;
import com.datastax.oss.driver.api.core.servererrors.ServerError;
import com.datastax.oss.driver.api.core.servererrors.SyntaxError;
import com.datastax.oss.driver.api.core.servererrors.TruncateException;
import com.datastax.oss.driver.api.core.servererrors.UnauthorizedException;
import com.datastax.oss.driver.api.core.servererrors.UnavailableException;
import com.datastax.oss.driver.api.core.servererrors.WriteFailureException;
import com.datastax.oss.driver.api.core.servererrors.WriteTimeoutException;
import com.datastax.oss.driver.api.core.session.Request;
import com.datastax.oss.driver.api.core.specex.SpeculativeExecutionPolicy;
import com.datastax.oss.driver.api.core.type.codec.registry.CodecRegistry;
import com.datastax.oss.driver.internal.core.ConsistencyLevelRegistry;
import com.datastax.oss.driver.internal.core.DefaultProtocolFeature;
import com.datastax.oss.driver.internal.core.ProtocolVersionRegistry;
import com.datastax.oss.driver.internal.core.context.InternalDriverContext;
import com.datastax.oss.driver.internal.core.cql.DefaultAsyncResultSet;
import com.datastax.oss.driver.internal.core.cql.DefaultColumnDefinition;
import com.datastax.oss.driver.internal.core.cql.DefaultColumnDefinitions;
import com.datastax.oss.driver.internal.core.cql.DefaultPreparedStatement;
import com.datastax.oss.driver.internal.core.data.ValuesHelper;
import com.datastax.oss.driver.shaded.guava.common.annotations.VisibleForTesting;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableList;
import com.datastax.oss.driver.shaded.guava.common.primitives.Ints;
import com.datastax.oss.protocol.internal.Message;
import com.datastax.oss.protocol.internal.request.Batch;
import com.datastax.oss.protocol.internal.request.Execute;
import com.datastax.oss.protocol.internal.request.Query;
import com.datastax.oss.protocol.internal.request.query.QueryOptions;
import com.datastax.oss.protocol.internal.response.Error;
import com.datastax.oss.protocol.internal.response.Result;
import com.datastax.oss.protocol.internal.response.error.AlreadyExists;
import com.datastax.oss.protocol.internal.response.error.CASWriteUnknown;
import com.datastax.oss.protocol.internal.response.error.ReadFailure;
import com.datastax.oss.protocol.internal.response.error.ReadTimeout;
import com.datastax.oss.protocol.internal.response.error.Unavailable;
import com.datastax.oss.protocol.internal.response.error.WriteFailure;
import com.datastax.oss.protocol.internal.response.error.WriteTimeout;
import com.datastax.oss.protocol.internal.response.result.ColumnSpec;
import com.datastax.oss.protocol.internal.response.result.Prepared;
import com.datastax.oss.protocol.internal.response.result.Rows;
import com.datastax.oss.protocol.internal.response.result.RowsMetadata;
import com.datastax.oss.protocol.internal.util.Bytes;
import com.datastax.oss.protocol.internal.util.collection.NullAllowingImmutableList;
import com.datastax.oss.protocol.internal.util.collection.NullAllowingImmutableMap;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class Conversions {
    public static DriverExecutionProfile resolveExecutionProfile(Request request, DriverContext context) {
        if (request.getExecutionProfile() != null) {
            return request.getExecutionProfile();
        }
        DriverConfig config = context.getConfig();
        String profileName = request.getExecutionProfileName();
        return profileName == null || profileName.isEmpty() ? config.getDefaultProfile() : config.getProfile(profileName);
    }

    public static Message toMessage(Statement<?> statement, DriverExecutionProfile config, InternalDriverContext context) {
        ConsistencyLevel serialConsistency;
        ConsistencyLevelRegistry consistencyLevelRegistry = context.getConsistencyLevelRegistry();
        ConsistencyLevel consistency = statement.getConsistencyLevel();
        int consistencyCode = consistency == null ? consistencyLevelRegistry.nameToCode(config.getString(DefaultDriverOption.REQUEST_CONSISTENCY)) : consistency.getProtocolCode();
        int pageSize = statement.getPageSize();
        if (pageSize <= 0) {
            pageSize = config.getInt(DefaultDriverOption.REQUEST_PAGE_SIZE);
        }
        int serialConsistencyCode = (serialConsistency = statement.getSerialConsistencyLevel()) == null ? consistencyLevelRegistry.nameToCode(config.getString(DefaultDriverOption.REQUEST_SERIAL_CONSISTENCY)) : serialConsistency.getProtocolCode();
        long timestamp = statement.getQueryTimestamp();
        if (timestamp == Long.MIN_VALUE) {
            timestamp = context.getTimestampGenerator().next();
        }
        CodecRegistry codecRegistry = context.getCodecRegistry();
        ProtocolVersion protocolVersion = context.getProtocolVersion();
        ProtocolVersionRegistry protocolVersionRegistry = context.getProtocolVersionRegistry();
        CqlIdentifier keyspace = statement.getKeyspace();
        int nowInSeconds = statement.getNowInSeconds();
        if (nowInSeconds != Integer.MIN_VALUE && !protocolVersionRegistry.supports(protocolVersion, DefaultProtocolFeature.NOW_IN_SECONDS)) {
            throw new IllegalArgumentException("Can't use nowInSeconds with protocol " + protocolVersion);
        }
        if (statement instanceof SimpleStatement) {
            SimpleStatement simpleStatement = (SimpleStatement)statement;
            List<Object> positionalValues = simpleStatement.getPositionalValues();
            Map<CqlIdentifier, Object> namedValues = simpleStatement.getNamedValues();
            if (!positionalValues.isEmpty() && !namedValues.isEmpty()) {
                throw new IllegalArgumentException("Can't have both positional and named values in a statement.");
            }
            if (keyspace != null && !protocolVersionRegistry.supports(protocolVersion, DefaultProtocolFeature.PER_REQUEST_KEYSPACE)) {
                throw new IllegalArgumentException("Can't use per-request keyspace with protocol " + protocolVersion);
            }
            QueryOptions queryOptions = new QueryOptions(consistencyCode, Conversions.encode(positionalValues, codecRegistry, protocolVersion), Conversions.encode(namedValues, codecRegistry, protocolVersion), false, pageSize, statement.getPagingState(), serialConsistencyCode, timestamp, keyspace == null ? null : keyspace.asInternal(), nowInSeconds);
            return new Query(simpleStatement.getQuery(), queryOptions);
        }
        if (statement instanceof BoundStatement) {
            BoundStatement boundStatement = (BoundStatement)statement;
            if (!protocolVersionRegistry.supports(protocolVersion, DefaultProtocolFeature.UNSET_BOUND_VALUES)) {
                Conversions.ensureAllSet(boundStatement);
            }
            boolean skipMetadata = boundStatement.getPreparedStatement().getResultSetDefinitions().size() > 0;
            QueryOptions queryOptions = new QueryOptions(consistencyCode, boundStatement.getValues(), Collections.emptyMap(), skipMetadata, pageSize, statement.getPagingState(), serialConsistencyCode, timestamp, null, nowInSeconds);
            PreparedStatement preparedStatement = boundStatement.getPreparedStatement();
            ByteBuffer id = preparedStatement.getId();
            ByteBuffer resultMetadataId = preparedStatement.getResultMetadataId();
            return new Execute(Bytes.getArray(id), resultMetadataId == null ? null : Bytes.getArray(resultMetadataId), queryOptions);
        }
        if (statement instanceof BatchStatement) {
            BatchStatement batchStatement = (BatchStatement)statement;
            if (!protocolVersionRegistry.supports(protocolVersion, DefaultProtocolFeature.UNSET_BOUND_VALUES)) {
                Conversions.ensureAllSet(batchStatement);
            }
            if (keyspace != null && !protocolVersionRegistry.supports(protocolVersion, DefaultProtocolFeature.PER_REQUEST_KEYSPACE)) {
                throw new IllegalArgumentException("Can't use per-request keyspace with protocol " + protocolVersion);
            }
            ArrayList<Object> queriesOrIds = new ArrayList<Object>(batchStatement.size());
            ArrayList<List<ByteBuffer>> values2 = new ArrayList<List<ByteBuffer>>(batchStatement.size());
            for (BatchableStatement child : batchStatement) {
                if (child instanceof SimpleStatement) {
                    SimpleStatement simpleStatement = (SimpleStatement)child;
                    if (simpleStatement.getNamedValues().size() > 0) {
                        throw new IllegalArgumentException(String.format("Batch statements cannot contain simple statements with named values (offending statement: %s)", simpleStatement.getQuery()));
                    }
                    queriesOrIds.add(simpleStatement.getQuery());
                    values2.add(Conversions.encode(simpleStatement.getPositionalValues(), codecRegistry, protocolVersion));
                    continue;
                }
                if (child instanceof BoundStatement) {
                    BoundStatement boundStatement = (BoundStatement)child;
                    queriesOrIds.add(Bytes.getArray(boundStatement.getPreparedStatement().getId()));
                    values2.add(boundStatement.getValues());
                    continue;
                }
                throw new IllegalArgumentException("Unsupported child statement: " + child.getClass().getName());
            }
            return new Batch(batchStatement.getBatchType().getProtocolCode(), queriesOrIds, values2, consistencyCode, serialConsistencyCode, timestamp, keyspace == null ? null : keyspace.asInternal(), nowInSeconds);
        }
        throw new IllegalArgumentException("Unsupported statement type: " + statement.getClass().getName());
    }

    public static List<ByteBuffer> encode(List<Object> values2, CodecRegistry codecRegistry, ProtocolVersion protocolVersion) {
        if (values2.isEmpty()) {
            return Collections.emptyList();
        }
        ByteBuffer[] encodedValues = new ByteBuffer[values2.size()];
        int i = 0;
        for (Object value : values2) {
            encodedValues[i++] = value == null ? null : ValuesHelper.encodeToDefaultCqlMapping(value, codecRegistry, protocolVersion);
        }
        return NullAllowingImmutableList.of(encodedValues);
    }

    public static Map<String, ByteBuffer> encode(Map<CqlIdentifier, Object> values2, CodecRegistry codecRegistry, ProtocolVersion protocolVersion) {
        if (values2.isEmpty()) {
            return Collections.emptyMap();
        }
        NullAllowingImmutableMap.Builder<String, ByteBuffer> encodedValues = NullAllowingImmutableMap.builder(values2.size());
        for (Map.Entry<CqlIdentifier, Object> entry : values2.entrySet()) {
            if (entry.getValue() == null) {
                encodedValues.put(entry.getKey().asInternal(), null);
                continue;
            }
            encodedValues.put(entry.getKey().asInternal(), ValuesHelper.encodeToDefaultCqlMapping(entry.getValue(), codecRegistry, protocolVersion));
        }
        return encodedValues.build();
    }

    public static void ensureAllSet(BoundStatement boundStatement) {
        for (int i = 0; i < boundStatement.size(); ++i) {
            if (boundStatement.isSet(i)) continue;
            throw new IllegalStateException("Unset value at index " + i + ". If you want this value to be null, please set it to null explicitly.");
        }
    }

    public static void ensureAllSet(BatchStatement batchStatement) {
        for (BatchableStatement batchableStatement : batchStatement) {
            if (!(batchableStatement instanceof BoundStatement)) continue;
            Conversions.ensureAllSet((BoundStatement)batchableStatement);
        }
    }

    public static AsyncResultSet toResultSet(Result result2, ExecutionInfo executionInfo, CqlSession session, InternalDriverContext context) {
        if (result2 instanceof Rows) {
            Rows rows = (Rows)result2;
            Statement statement = (Statement)executionInfo.getRequest();
            ColumnDefinitions columnDefinitions = Conversions.getResultDefinitions(rows, statement, context);
            return new DefaultAsyncResultSet(columnDefinitions, executionInfo, rows.getData(), session, context);
        }
        if (result2 instanceof Prepared) {
            throw new IllegalArgumentException("Unexpected PREPARED response to a CQL query");
        }
        return DefaultAsyncResultSet.empty(executionInfo);
    }

    public static ColumnDefinitions getResultDefinitions(Rows rows, Statement<?> statement, InternalDriverContext context) {
        RowsMetadata rowsMetadata = rows.getMetadata();
        if (rowsMetadata.columnSpecs.isEmpty()) {
            BoundStatement boundStatement = (BoundStatement)statement;
            return boundStatement.getPreparedStatement().getResultSetDefinitions();
        }
        ColumnDefinitions definitions = Conversions.toColumnDefinitions(rowsMetadata, context);
        if (rowsMetadata.newResultMetadataId != null) {
            BoundStatement boundStatement = (BoundStatement)statement;
            PreparedStatement preparedStatement = boundStatement.getPreparedStatement();
            preparedStatement.setResultMetadata(ByteBuffer.wrap(rowsMetadata.newResultMetadataId).asReadOnlyBuffer(), definitions);
        }
        return definitions;
    }

    public static DefaultPreparedStatement toPreparedStatement(Prepared response, PrepareRequest request, InternalDriverContext context) {
        ColumnDefinitions variableDefinitions = Conversions.toColumnDefinitions(response.variablesMetadata, context);
        int[] pkIndicesInResponse = response.variablesMetadata.pkIndices;
        List<Integer> pkIndices = pkIndicesInResponse == null ? Conversions.computePkIndices(variableDefinitions, context) : Ints.asList(pkIndicesInResponse);
        return new DefaultPreparedStatement(ByteBuffer.wrap(response.preparedQueryId).asReadOnlyBuffer(), request.getQuery(), variableDefinitions, pkIndices, response.resultMetadataId == null ? null : ByteBuffer.wrap(response.resultMetadataId).asReadOnlyBuffer(), Conversions.toColumnDefinitions(response.resultMetadata, context), request.getKeyspace(), NullAllowingImmutableMap.copyOf(request.getCustomPayload()), request.getExecutionProfileNameForBoundStatements(), request.getExecutionProfileForBoundStatements(), request.getRoutingKeyspaceForBoundStatements(), request.getRoutingKeyForBoundStatements(), request.getRoutingTokenForBoundStatements(), NullAllowingImmutableMap.copyOf(request.getCustomPayloadForBoundStatements()), request.areBoundStatementsIdempotent(), request.getTimeoutForBoundStatements(), request.getPagingStateForBoundStatements(), request.getPageSizeForBoundStatements(), request.getConsistencyLevelForBoundStatements(), request.getSerialConsistencyLevelForBoundStatements(), request.areBoundStatementsTracing(), context.getCodecRegistry(), context.getProtocolVersion());
    }

    public static ColumnDefinitions toColumnDefinitions(RowsMetadata metadata, InternalDriverContext context) {
        ColumnDefinition[] values2 = new ColumnDefinition[metadata.columnSpecs.size()];
        int i = 0;
        for (ColumnSpec columnSpec : metadata.columnSpecs) {
            values2[i++] = new DefaultColumnDefinition(columnSpec, context);
        }
        return DefaultColumnDefinitions.valueOf(ImmutableList.copyOf(values2));
    }

    public static List<Integer> computePkIndices(ColumnDefinitions variables, InternalDriverContext context) {
        if (variables.size() == 0) {
            return Collections.emptyList();
        }
        ColumnDefinition firstVariable = variables.get(0);
        return context.getMetadataManager().getMetadata().getKeyspace(firstVariable.getKeyspace()).flatMap(ks -> ks.getTable(firstVariable.getTable())).map(RelationMetadata::getPartitionKey).map(pk -> Conversions.findIndices(pk, variables)).orElse(Collections.emptyList());
    }

    @VisibleForTesting
    static List<Integer> findIndices(List<ColumnMetadata> partitionKey, ColumnDefinitions variables) {
        ImmutableList.Builder result2 = ImmutableList.builderWithExpectedSize(partitionKey.size());
        for (ColumnMetadata pkColumn : partitionKey) {
            int firstIndex = variables.firstIndexOf(pkColumn.getName());
            if (firstIndex < 0) {
                return Collections.emptyList();
            }
            result2.add((Object)firstIndex);
        }
        return result2.build();
    }

    public static CoordinatorException toThrowable(Node node, Error errorMessage, InternalDriverContext context) {
        switch (errorMessage.code) {
            case 9472: {
                throw new AssertionError((Object)"UNPREPARED should be handled as a special case, not turned into an exception");
            }
            case 0: {
                return new ServerError(node, errorMessage.message);
            }
            case 10: {
                return new ProtocolError(node, errorMessage.message);
            }
            case 256: {
                return new ProtocolError(node, "Unexpected authentication error (" + errorMessage.message + ")");
            }
            case 4096: {
                Unavailable unavailable = (Unavailable)errorMessage;
                return new UnavailableException(node, context.getConsistencyLevelRegistry().codeToLevel(unavailable.consistencyLevel), unavailable.required, unavailable.alive);
            }
            case 4097: {
                return new OverloadedException(node, errorMessage.message);
            }
            case 4098: {
                return new BootstrappingException(node);
            }
            case 4099: {
                return new TruncateException(node, errorMessage.message);
            }
            case 4352: {
                WriteTimeout writeTimeout = (WriteTimeout)errorMessage;
                return new WriteTimeoutException(node, context.getConsistencyLevelRegistry().codeToLevel(writeTimeout.consistencyLevel), writeTimeout.received, writeTimeout.blockFor, context.getWriteTypeRegistry().fromName(writeTimeout.writeType));
            }
            case 4608: {
                ReadTimeout readTimeout = (ReadTimeout)errorMessage;
                return new ReadTimeoutException(node, context.getConsistencyLevelRegistry().codeToLevel(readTimeout.consistencyLevel), readTimeout.received, readTimeout.blockFor, readTimeout.dataPresent);
            }
            case 4864: {
                ReadFailure readFailure = (ReadFailure)errorMessage;
                return new ReadFailureException(node, context.getConsistencyLevelRegistry().codeToLevel(readFailure.consistencyLevel), readFailure.received, readFailure.blockFor, readFailure.numFailures, readFailure.dataPresent, readFailure.reasonMap);
            }
            case 5120: {
                return new FunctionFailureException(node, errorMessage.message);
            }
            case 5376: {
                WriteFailure writeFailure = (WriteFailure)errorMessage;
                return new WriteFailureException(node, context.getConsistencyLevelRegistry().codeToLevel(writeFailure.consistencyLevel), writeFailure.received, writeFailure.blockFor, context.getWriteTypeRegistry().fromName(writeFailure.writeType), writeFailure.numFailures, writeFailure.reasonMap);
            }
            case 5632: {
                return new CDCWriteFailureException(node, errorMessage.message);
            }
            case 5888: {
                CASWriteUnknown casFailure = (CASWriteUnknown)errorMessage;
                return new CASWriteUnknownException(node, context.getConsistencyLevelRegistry().codeToLevel(casFailure.consistencyLevel), casFailure.received, casFailure.blockFor);
            }
            case 8192: {
                return new SyntaxError(node, errorMessage.message);
            }
            case 8448: {
                return new UnauthorizedException(node, errorMessage.message);
            }
            case 8704: {
                return new InvalidQueryException(node, errorMessage.message);
            }
            case 8960: {
                return new InvalidConfigurationInQueryException(node, errorMessage.message);
            }
            case 9216: {
                AlreadyExists alreadyExists = (AlreadyExists)errorMessage;
                return new AlreadyExistsException(node, alreadyExists.keyspace, alreadyExists.table);
            }
        }
        return new ProtocolError(node, "Unknown error code: " + errorMessage.code);
    }

    public static boolean resolveIdempotence(Request request, InternalDriverContext context) {
        Boolean requestIsIdempotent = request.isIdempotent();
        DriverExecutionProfile executionProfile = Conversions.resolveExecutionProfile(request, context);
        return requestIsIdempotent == null ? executionProfile.getBoolean(DefaultDriverOption.REQUEST_DEFAULT_IDEMPOTENCE) : requestIsIdempotent.booleanValue();
    }

    public static Duration resolveRequestTimeout(Request request, InternalDriverContext context) {
        DriverExecutionProfile executionProfile = Conversions.resolveExecutionProfile(request, context);
        return request.getTimeout() != null ? request.getTimeout() : executionProfile.getDuration(DefaultDriverOption.REQUEST_TIMEOUT);
    }

    public static RetryPolicy resolveRetryPolicy(Request request, InternalDriverContext context) {
        DriverExecutionProfile executionProfile = Conversions.resolveExecutionProfile(request, context);
        return context.getRetryPolicy(executionProfile.getName());
    }

    public static SpeculativeExecutionPolicy resolveSpeculativeExecutionPolicy(Request request, InternalDriverContext context) {
        DriverExecutionProfile executionProfile = Conversions.resolveExecutionProfile(request, context);
        return context.getSpeculativeExecutionPolicy(executionProfile.getName());
    }
}

