/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.metadata.schema.queries;

import com.datastax.oss.driver.api.core.config.DefaultDriverOption;
import com.datastax.oss.driver.internal.core.metadata.schema.queries.KeyspaceFilter;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RuleBasedKeyspaceFilter
implements KeyspaceFilter {
    private static final Logger LOG = LoggerFactory.getLogger(RuleBasedKeyspaceFilter.class);
    private static final Pattern EXACT_INCLUDE = Pattern.compile("\\w+");
    private static final Pattern EXACT_EXCLUDE = Pattern.compile("!\\s*(\\w+)");
    private static final Pattern REGEX_INCLUDE = Pattern.compile("/(.+)/");
    private static final Pattern REGEX_EXCLUDE = Pattern.compile("!\\s*/(.+)/");
    private final String logPrefix;
    private final String whereClause;
    private final Set<String> exactIncludes = new HashSet<String>();
    private final Set<String> exactExcludes = new HashSet<String>();
    private final List<Predicate<String>> regexIncludes = new ArrayList<Predicate<String>>();
    private final List<Predicate<String>> regexExcludes = new ArrayList<Predicate<String>>();
    private final boolean isDebugEnabled;
    private final Set<String> loggedKeyspaces;

    RuleBasedKeyspaceFilter(@NonNull String logPrefix, @NonNull List<String> specs) {
        assert (!specs.isEmpty());
        this.logPrefix = logPrefix;
        for (String spec : specs) {
            if (EXACT_INCLUDE.matcher(spec = spec.trim()).matches()) {
                this.exactIncludes.add(spec);
                if (!this.exactExcludes.remove(spec)) continue;
                LOG.warn("[{}] '{}' is both included and excluded, ignoring the exclusion", (Object)logPrefix, (Object)spec);
                continue;
            }
            Matcher matcher = EXACT_EXCLUDE.matcher(spec);
            if (matcher.matches()) {
                String name = matcher.group(1);
                if (this.exactIncludes.contains(name)) {
                    LOG.warn("[{}] '{}' is both included and excluded, ignoring the exclusion", (Object)logPrefix, (Object)name);
                    continue;
                }
                this.exactExcludes.add(name);
                continue;
            }
            matcher = REGEX_INCLUDE.matcher(spec);
            if (matcher.matches()) {
                this.compile(matcher.group(1)).map(this.regexIncludes::add);
                continue;
            }
            matcher = REGEX_EXCLUDE.matcher(spec);
            if (matcher.matches()) {
                this.compile(matcher.group(1)).map(this.regexExcludes::add);
                continue;
            }
            LOG.warn("[{}] Error while parsing {}: invalid element '{}', skipping", logPrefix, DefaultDriverOption.METADATA_SCHEMA_REFRESHED_KEYSPACES.getPath(), spec);
        }
        if (!this.exactIncludes.isEmpty() && this.regexIncludes.isEmpty() && this.regexExcludes.isEmpty()) {
            this.whereClause = RuleBasedKeyspaceFilter.buildWhereClause(this.exactIncludes);
            if (!this.exactExcludes.isEmpty()) {
                LOG.warn("[{}] {} only has exact includes and excludes, the excludes are redundant", (Object)logPrefix, (Object)DefaultDriverOption.METADATA_SCHEMA_REFRESHED_KEYSPACES.getPath());
            }
            LOG.debug("[{}] Filtering server-side with '{}'", (Object)logPrefix, (Object)this.whereClause);
        } else {
            this.whereClause = "";
            LOG.debug("[{}] No server-side filtering", (Object)logPrefix);
        }
        this.isDebugEnabled = LOG.isDebugEnabled();
        this.loggedKeyspaces = this.isDebugEnabled ? new HashSet() : null;
    }

    @Override
    @NonNull
    public String getWhereClause() {
        return this.whereClause;
    }

    @Override
    public boolean includes(@NonNull String keyspace) {
        if (this.exactIncludes.contains(keyspace)) {
            this.log(keyspace, true, "it is included by name");
            return true;
        }
        if (this.exactExcludes.contains(keyspace)) {
            this.log(keyspace, false, "it is excluded by name");
            return false;
        }
        if (this.regexIncludes.isEmpty()) {
            if (this.regexExcludes.isEmpty()) {
                this.log(keyspace, false, "it is not included by name");
                return false;
            }
            if (this.matchesAny(keyspace, this.regexExcludes)) {
                this.log(keyspace, false, "it matches at least one regex exclude");
                return false;
            }
            this.log(keyspace, true, "it does not match any regex exclude");
            return true;
        }
        if (this.regexExcludes.isEmpty()) {
            if (this.matchesAny(keyspace, this.regexIncludes)) {
                this.log(keyspace, true, "it matches at least one regex include");
                return true;
            }
            this.log(keyspace, false, "it does not match any regex include");
            return false;
        }
        if (this.matchesAny(keyspace, this.regexIncludes) && !this.matchesAny(keyspace, this.regexExcludes)) {
            this.log(keyspace, true, "it matches at least one regex include, and no regex exclude");
            return true;
        }
        this.log(keyspace, false, "it matches either no regex include, or at least one regex exclude");
        return false;
    }

    private void log(@NonNull String keyspace, boolean include, @NonNull String reason) {
        if (this.isDebugEnabled && this.loggedKeyspaces.add(keyspace)) {
            LOG.debug("[{}] Filtering {} '{}' because {}", this.logPrefix, include ? "in" : "out", keyspace, reason);
        }
    }

    private boolean matchesAny(String keyspace, List<Predicate<String>> rules) {
        for (Predicate<String> rule : rules) {
            if (!rule.test(keyspace)) continue;
            return true;
        }
        return false;
    }

    private Optional<Predicate<String>> compile(String regex) {
        try {
            return Optional.of(Pattern.compile(regex).asPredicate());
        }
        catch (PatternSyntaxException e) {
            LOG.warn("[{}] Error while parsing {}: syntax error in regex /{}/ ({}), skipping", this.logPrefix, DefaultDriverOption.METADATA_SCHEMA_REFRESHED_KEYSPACES.getPath(), regex, e.getMessage());
            return Optional.empty();
        }
    }

    private static String buildWhereClause(Set<String> keyspaces) {
        StringBuilder builder = new StringBuilder(" WHERE keyspace_name IN (");
        boolean first = true;
        for (String keyspace : keyspaces) {
            if (first) {
                first = false;
            } else {
                builder.append(",");
            }
            builder.append('\'').append(keyspace).append('\'');
        }
        return builder.append(')').toString();
    }
}

