/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.interpreter.remote;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.hadoop.yarn.client.api.AMRMClient;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YarnUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(YarnUtils.class);
    private static AMRMClient<AMRMClient.ContainerRequest> amClient = AMRMClient.createAMRMClient();
    private static Configuration conf = new YarnConfiguration();

    public static void register(String host, int port) throws Exception {
        LOGGER.info("Registering yarn app at {}:{}", (Object)host, (Object)port);
        try {
            amClient.registerApplicationMaster(host, port, null);
        }
        catch (YarnException e) {
            throw new Exception("Fail to register yarn app", e);
        }
    }

    public static void heartbeat() {
        LOGGER.info("Heartbeating to RM");
        try {
            amClient.allocate(1.0f);
        }
        catch (Exception e) {
            LOGGER.warn(e.getMessage(), (Throwable)e);
        }
    }

    public static void unregister(boolean succcess, String diagnostic) throws Exception {
        LOGGER.info("Unregistering yarn app");
        try {
            if (succcess) {
                amClient.unregisterApplicationMaster(FinalApplicationStatus.SUCCEEDED, "", null);
            } else {
                amClient.unregisterApplicationMaster(FinalApplicationStatus.FAILED, diagnostic, null);
            }
        }
        catch (YarnException e) {
            throw new Exception("Fail to unregister yarn app", e);
        }
    }

    static {
        amClient.init(conf);
        amClient.start();
    }
}

