/*
 * Decompiled with CFR 0.152.
 */
package com.influxdb.client.domain;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.influxdb.client.domain.BucketLinks;
import com.influxdb.client.domain.BucketRetentionRules;
import com.influxdb.client.domain.Label;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class Bucket {
    public static final String SERIALIZED_NAME_LINKS = "links";
    @SerializedName(value="links")
    private BucketLinks links = null;
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private String id;
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    private TypeEnum type = TypeEnum.USER;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_DESCRIPTION = "description";
    @SerializedName(value="description")
    private String description;
    public static final String SERIALIZED_NAME_ORG_I_D = "orgID";
    @SerializedName(value="orgID")
    private String orgID;
    public static final String SERIALIZED_NAME_RP = "rp";
    @SerializedName(value="rp")
    private String rp;
    public static final String SERIALIZED_NAME_CREATED_AT = "createdAt";
    @SerializedName(value="createdAt")
    private OffsetDateTime createdAt;
    public static final String SERIALIZED_NAME_UPDATED_AT = "updatedAt";
    @SerializedName(value="updatedAt")
    private OffsetDateTime updatedAt;
    public static final String SERIALIZED_NAME_RETENTION_RULES = "retentionRules";
    @SerializedName(value="retentionRules")
    private List<BucketRetentionRules> retentionRules = new ArrayList<BucketRetentionRules>();
    public static final String SERIALIZED_NAME_LABELS = "labels";
    @SerializedName(value="labels")
    private List<Label> labels = new ArrayList<Label>();

    public Bucket links(BucketLinks links) {
        this.links = links;
        return this;
    }

    @ApiModelProperty(value="")
    public BucketLinks getLinks() {
        return this.links;
    }

    public void setLinks(BucketLinks links) {
        this.links = links;
    }

    @ApiModelProperty(value="")
    public String getId() {
        return this.id;
    }

    @ApiModelProperty(value="")
    public TypeEnum getType() {
        return this.type;
    }

    public Bucket name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Bucket description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(value="")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Bucket orgID(String orgID) {
        this.orgID = orgID;
        return this;
    }

    @ApiModelProperty(value="")
    public String getOrgID() {
        return this.orgID;
    }

    public void setOrgID(String orgID) {
        this.orgID = orgID;
    }

    public Bucket rp(String rp) {
        this.rp = rp;
        return this;
    }

    @ApiModelProperty(value="")
    public String getRp() {
        return this.rp;
    }

    public void setRp(String rp) {
        this.rp = rp;
    }

    @ApiModelProperty(value="")
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    @ApiModelProperty(value="")
    public OffsetDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    public Bucket retentionRules(List<BucketRetentionRules> retentionRules) {
        this.retentionRules = retentionRules;
        return this;
    }

    public Bucket addRetentionRulesItem(BucketRetentionRules retentionRulesItem) {
        this.retentionRules.add(retentionRulesItem);
        return this;
    }

    @ApiModelProperty(required=true, value="Rules to expire or retain data.  No rules means data never expires.")
    public List<BucketRetentionRules> getRetentionRules() {
        return this.retentionRules;
    }

    public void setRetentionRules(List<BucketRetentionRules> retentionRules) {
        this.retentionRules = retentionRules;
    }

    public Bucket labels(List<Label> labels) {
        this.labels = labels;
        return this;
    }

    public Bucket addLabelsItem(Label labelsItem) {
        if (this.labels == null) {
            this.labels = new ArrayList<Label>();
        }
        this.labels.add(labelsItem);
        return this;
    }

    @ApiModelProperty(value="")
    public List<Label> getLabels() {
        return this.labels;
    }

    public void setLabels(List<Label> labels) {
        this.labels = labels;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Bucket bucket = (Bucket)o;
        return Objects.equals(this.links, bucket.links) && Objects.equals(this.id, bucket.id) && Objects.equals((Object)this.type, (Object)bucket.type) && Objects.equals(this.name, bucket.name) && Objects.equals(this.description, bucket.description) && Objects.equals(this.orgID, bucket.orgID) && Objects.equals(this.rp, bucket.rp) && Objects.equals(this.createdAt, bucket.createdAt) && Objects.equals(this.updatedAt, bucket.updatedAt) && Objects.equals(this.retentionRules, bucket.retentionRules) && Objects.equals(this.labels, bucket.labels);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.links, this.id, this.type, this.name, this.description, this.orgID, this.rp, this.createdAt, this.updatedAt, this.retentionRules, this.labels});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Bucket {\n");
        sb.append("    links: ").append(this.toIndentedString(this.links)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    orgID: ").append(this.toIndentedString(this.orgID)).append("\n");
        sb.append("    rp: ").append(this.toIndentedString(this.rp)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    updatedAt: ").append(this.toIndentedString(this.updatedAt)).append("\n");
        sb.append("    retentionRules: ").append(this.toIndentedString(this.retentionRules)).append("\n");
        sb.append("    labels: ").append(this.toIndentedString(this.labels)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum TypeEnum {
        USER("user"),
        SYSTEM("system");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static TypeEnum fromValue(String text) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<TypeEnum> {
            @Override
            public void write(JsonWriter jsonWriter, TypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            @Override
            public TypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return TypeEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

