/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.jose.crypto;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.crypto.AlgorithmSupportMessage;
import com.nimbusds.jose.crypto.ECDSAProvider;
import com.nimbusds.jose.jwk.ECKey;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Signature;
import java.security.interfaces.ECKey;
import java.security.spec.ECParameterSpec;

class ECDSA {
    public static JWSAlgorithm resolveAlgorithm(ECKey ecKey) throws JOSEException {
        ECParameterSpec ecParameterSpec = ecKey.getParams();
        return ECDSA.resolveAlgorithm(ECKey.Curve.forECParameterSpec(ecParameterSpec));
    }

    public static JWSAlgorithm resolveAlgorithm(ECKey.Curve curve) throws JOSEException {
        if (curve == null) {
            throw new JOSEException("The EC key curve is not supported, must be P256, P384 or P521");
        }
        if (ECKey.Curve.P_256.equals(curve)) {
            return JWSAlgorithm.ES256;
        }
        if (ECKey.Curve.P_384.equals(curve)) {
            return JWSAlgorithm.ES384;
        }
        if (ECKey.Curve.P_521.equals(curve)) {
            return JWSAlgorithm.ES512;
        }
        throw new JOSEException("Unexpected curve: " + curve);
    }

    public static Signature getSignerAndVerifier(JWSAlgorithm alg, Provider jcaProvider) throws JOSEException {
        String jcaAlg;
        if (alg.equals(JWSAlgorithm.ES256)) {
            jcaAlg = "SHA256withECDSA";
        } else if (alg.equals(JWSAlgorithm.ES384)) {
            jcaAlg = "SHA384withECDSA";
        } else if (alg.equals(JWSAlgorithm.ES512)) {
            jcaAlg = "SHA512withECDSA";
        } else {
            throw new JOSEException(AlgorithmSupportMessage.unsupportedJWSAlgorithm(alg, ECDSAProvider.SUPPORTED_ALGORITHMS));
        }
        try {
            if (jcaProvider != null) {
                return Signature.getInstance(jcaAlg, jcaProvider);
            }
            return Signature.getInstance(jcaAlg);
        }
        catch (NoSuchAlgorithmException e) {
            throw new JOSEException("Unsupported ECDSA algorithm: " + e.getMessage(), e);
        }
    }

    public static int getSignatureByteArrayLength(JWSAlgorithm alg) throws JOSEException {
        if (alg.equals(JWSAlgorithm.ES256)) {
            return 64;
        }
        if (alg.equals(JWSAlgorithm.ES384)) {
            return 96;
        }
        if (alg.equals(JWSAlgorithm.ES512)) {
            return 132;
        }
        throw new JOSEException(AlgorithmSupportMessage.unsupportedJWSAlgorithm(alg, ECDSAProvider.SUPPORTED_ALGORITHMS));
    }

    public static byte[] transcodeSignatureToConcat(byte[] derSignature, int outputLength) throws JOSEException {
        int sLength;
        int rLength;
        int offset2;
        if (derSignature.length < 8 || derSignature[0] != 48) {
            throw new JOSEException("Invalid ECDSA signature format");
        }
        if (derSignature[1] > 0) {
            offset2 = 2;
        } else if (derSignature[1] == -127) {
            offset2 = 3;
        } else {
            throw new JOSEException("Invalid ECDSA signature format");
        }
        int i2 = rLength = derSignature[offset2 + 1];
        while (i2 > 0 && derSignature[offset2 + 2 + rLength - i2] == 0) {
            --i2;
        }
        int j = sLength = derSignature[offset2 + 2 + rLength + 1];
        while (j > 0 && derSignature[offset2 + 2 + rLength + 2 + sLength - j] == 0) {
            --j;
        }
        int rawLen = Math.max(i2, j);
        rawLen = Math.max(rawLen, outputLength / 2);
        if ((derSignature[offset2 - 1] & 0xFF) != derSignature.length - offset2 || (derSignature[offset2 - 1] & 0xFF) != 2 + rLength + 2 + sLength || derSignature[offset2] != 2 || derSignature[offset2 + 2 + rLength] != 2) {
            throw new JOSEException("Invalid ECDSA signature format");
        }
        byte[] concatSignature = new byte[2 * rawLen];
        System.arraycopy(derSignature, offset2 + 2 + rLength - i2, concatSignature, rawLen - i2, i2);
        System.arraycopy(derSignature, offset2 + 2 + rLength + 2 + sLength - j, concatSignature, 2 * rawLen - j, j);
        return concatSignature;
    }

    public static byte[] transcodeSignatureToDER(byte[] jwsSignature) throws JOSEException {
        int offset2;
        byte[] derSignature;
        int len;
        int rawLen;
        int i2 = rawLen = jwsSignature.length / 2;
        while (i2 > 0 && jwsSignature[rawLen - i2] == 0) {
            --i2;
        }
        int j = i2;
        if (jwsSignature[rawLen - i2] < 0) {
            ++j;
        }
        int k = rawLen;
        while (k > 0 && jwsSignature[2 * rawLen - k] == 0) {
            --k;
        }
        int l = k;
        if (jwsSignature[2 * rawLen - k] < 0) {
            ++l;
        }
        if ((len = 2 + j + 2 + l) > 255) {
            throw new JOSEException("Invalid ECDSA signature format");
        }
        if (len < 128) {
            derSignature = new byte[4 + j + 2 + l];
            offset2 = 1;
        } else {
            derSignature = new byte[5 + j + 2 + l];
            derSignature[1] = -127;
            offset2 = 2;
        }
        derSignature[0] = 48;
        derSignature[offset2++] = (byte)len;
        derSignature[offset2++] = 2;
        derSignature[offset2++] = (byte)j;
        System.arraycopy(jwsSignature, rawLen - i2, derSignature, offset2 + j - i2, i2);
        offset2 += j;
        derSignature[offset2++] = 2;
        derSignature[offset2++] = (byte)l;
        System.arraycopy(jwsSignature, 2 * rawLen - k, derSignature, offset2 + l - k, k);
        return derSignature;
    }

    private ECDSA() {
    }
}

