/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

final class HeapByteBufUtil {
    static byte getByte(byte[] memory, int index2) {
        return memory[index2];
    }

    static short getShort(byte[] memory, int index2) {
        return (short)(memory[index2] << 8 | memory[index2 + 1] & 0xFF);
    }

    static short getShortLE(byte[] memory, int index2) {
        return (short)(memory[index2] & 0xFF | memory[index2 + 1] << 8);
    }

    static int getUnsignedMedium(byte[] memory, int index2) {
        return (memory[index2] & 0xFF) << 16 | (memory[index2 + 1] & 0xFF) << 8 | memory[index2 + 2] & 0xFF;
    }

    static int getUnsignedMediumLE(byte[] memory, int index2) {
        return memory[index2] & 0xFF | (memory[index2 + 1] & 0xFF) << 8 | (memory[index2 + 2] & 0xFF) << 16;
    }

    static int getInt(byte[] memory, int index2) {
        return (memory[index2] & 0xFF) << 24 | (memory[index2 + 1] & 0xFF) << 16 | (memory[index2 + 2] & 0xFF) << 8 | memory[index2 + 3] & 0xFF;
    }

    static int getIntLE(byte[] memory, int index2) {
        return memory[index2] & 0xFF | (memory[index2 + 1] & 0xFF) << 8 | (memory[index2 + 2] & 0xFF) << 16 | (memory[index2 + 3] & 0xFF) << 24;
    }

    static long getLong(byte[] memory, int index2) {
        return ((long)memory[index2] & 0xFFL) << 56 | ((long)memory[index2 + 1] & 0xFFL) << 48 | ((long)memory[index2 + 2] & 0xFFL) << 40 | ((long)memory[index2 + 3] & 0xFFL) << 32 | ((long)memory[index2 + 4] & 0xFFL) << 24 | ((long)memory[index2 + 5] & 0xFFL) << 16 | ((long)memory[index2 + 6] & 0xFFL) << 8 | (long)memory[index2 + 7] & 0xFFL;
    }

    static long getLongLE(byte[] memory, int index2) {
        return (long)memory[index2] & 0xFFL | ((long)memory[index2 + 1] & 0xFFL) << 8 | ((long)memory[index2 + 2] & 0xFFL) << 16 | ((long)memory[index2 + 3] & 0xFFL) << 24 | ((long)memory[index2 + 4] & 0xFFL) << 32 | ((long)memory[index2 + 5] & 0xFFL) << 40 | ((long)memory[index2 + 6] & 0xFFL) << 48 | ((long)memory[index2 + 7] & 0xFFL) << 56;
    }

    static void setByte(byte[] memory, int index2, int value2) {
        memory[index2] = (byte)value2;
    }

    static void setShort(byte[] memory, int index2, int value2) {
        memory[index2] = (byte)(value2 >>> 8);
        memory[index2 + 1] = (byte)value2;
    }

    static void setShortLE(byte[] memory, int index2, int value2) {
        memory[index2] = (byte)value2;
        memory[index2 + 1] = (byte)(value2 >>> 8);
    }

    static void setMedium(byte[] memory, int index2, int value2) {
        memory[index2] = (byte)(value2 >>> 16);
        memory[index2 + 1] = (byte)(value2 >>> 8);
        memory[index2 + 2] = (byte)value2;
    }

    static void setMediumLE(byte[] memory, int index2, int value2) {
        memory[index2] = (byte)value2;
        memory[index2 + 1] = (byte)(value2 >>> 8);
        memory[index2 + 2] = (byte)(value2 >>> 16);
    }

    static void setInt(byte[] memory, int index2, int value2) {
        memory[index2] = (byte)(value2 >>> 24);
        memory[index2 + 1] = (byte)(value2 >>> 16);
        memory[index2 + 2] = (byte)(value2 >>> 8);
        memory[index2 + 3] = (byte)value2;
    }

    static void setIntLE(byte[] memory, int index2, int value2) {
        memory[index2] = (byte)value2;
        memory[index2 + 1] = (byte)(value2 >>> 8);
        memory[index2 + 2] = (byte)(value2 >>> 16);
        memory[index2 + 3] = (byte)(value2 >>> 24);
    }

    static void setLong(byte[] memory, int index2, long value2) {
        memory[index2] = (byte)(value2 >>> 56);
        memory[index2 + 1] = (byte)(value2 >>> 48);
        memory[index2 + 2] = (byte)(value2 >>> 40);
        memory[index2 + 3] = (byte)(value2 >>> 32);
        memory[index2 + 4] = (byte)(value2 >>> 24);
        memory[index2 + 5] = (byte)(value2 >>> 16);
        memory[index2 + 6] = (byte)(value2 >>> 8);
        memory[index2 + 7] = (byte)value2;
    }

    static void setLongLE(byte[] memory, int index2, long value2) {
        memory[index2] = (byte)value2;
        memory[index2 + 1] = (byte)(value2 >>> 8);
        memory[index2 + 2] = (byte)(value2 >>> 16);
        memory[index2 + 3] = (byte)(value2 >>> 24);
        memory[index2 + 4] = (byte)(value2 >>> 32);
        memory[index2 + 5] = (byte)(value2 >>> 40);
        memory[index2 + 6] = (byte)(value2 >>> 48);
        memory[index2 + 7] = (byte)(value2 >>> 56);
    }

    private HeapByteBufUtil() {
    }
}

