/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.compression;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToByteEncoder;
import io.netty.handler.codec.compression.FastLz;
import java.util.zip.Adler32;
import java.util.zip.Checksum;

public class FastLzFrameEncoder
extends MessageToByteEncoder<ByteBuf> {
    private final int level;
    private final Checksum checksum;

    public FastLzFrameEncoder() {
        this(0, null);
    }

    public FastLzFrameEncoder(int level2) {
        this(level2, null);
    }

    public FastLzFrameEncoder(boolean validateChecksums) {
        this(0, validateChecksums ? new Adler32() : null);
    }

    public FastLzFrameEncoder(int level2, Checksum checksum) {
        super(false);
        if (level2 != 0 && level2 != 1 && level2 != 2) {
            throw new IllegalArgumentException(String.format("level: %d (expected: %d or %d or %d)", level2, 0, 1, 2));
        }
        this.level = level2;
        this.checksum = checksum;
    }

    @Override
    protected void encode(ChannelHandlerContext ctx, ByteBuf in, ByteBuf out) throws Exception {
        Checksum checksum = this.checksum;
        while (in.isReadable()) {
            int chunkLength;
            int blockType;
            int idx = in.readerIndex();
            int length2 = Math.min(in.readableBytes(), 65535);
            int outputIdx = out.writerIndex();
            out.setMedium(outputIdx, 4607066);
            int outputOffset = outputIdx + 4 + (checksum != null ? 4 : 0);
            if (length2 < 32) {
                blockType = 0;
                out.ensureWritable(outputOffset + 2 + length2);
                byte[] output = out.array();
                int outputPtr = out.arrayOffset() + outputOffset + 2;
                if (checksum != null) {
                    int inputPtr;
                    byte[] input;
                    if (in.hasArray()) {
                        input = in.array();
                        inputPtr = in.arrayOffset() + idx;
                    } else {
                        input = new byte[length2];
                        in.getBytes(idx, input);
                        inputPtr = 0;
                    }
                    checksum.reset();
                    checksum.update(input, inputPtr, length2);
                    out.setInt(outputIdx + 4, (int)checksum.getValue());
                    System.arraycopy(input, inputPtr, output, outputPtr, length2);
                } else {
                    in.getBytes(idx, output, outputPtr, length2);
                }
                chunkLength = length2;
            } else {
                int inputPtr;
                byte[] input;
                if (in.hasArray()) {
                    input = in.array();
                    inputPtr = in.arrayOffset() + idx;
                } else {
                    input = new byte[length2];
                    in.getBytes(idx, input);
                    inputPtr = 0;
                }
                if (checksum != null) {
                    checksum.reset();
                    checksum.update(input, inputPtr, length2);
                    out.setInt(outputIdx + 4, (int)checksum.getValue());
                }
                int maxOutputLength = FastLz.calculateOutputBufferLength(length2);
                out.ensureWritable(outputOffset + 4 + maxOutputLength);
                byte[] output = out.array();
                int outputPtr = out.arrayOffset() + outputOffset + 4;
                int compressedLength = FastLz.compress(input, inputPtr, length2, output, outputPtr, this.level);
                if (compressedLength < length2) {
                    blockType = 1;
                    chunkLength = compressedLength;
                    out.setShort(outputOffset, chunkLength);
                    outputOffset += 2;
                } else {
                    blockType = 0;
                    System.arraycopy(input, inputPtr, output, outputPtr - 2, length2);
                    chunkLength = length2;
                }
            }
            out.setShort(outputOffset, length2);
            out.setByte(outputIdx + 3, blockType | (checksum != null ? 16 : 0));
            out.writerIndex(outputOffset + 2 + chunkLength);
            in.skipBytes(length2);
        }
        return;
    }
}

