/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.filefilter;

import java.io.File;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.io.IOCase;
import org.apache.commons.io.filefilter.AbstractFileFilter;

public class NameFileFilter
extends AbstractFileFilter
implements Serializable {
    private static final long serialVersionUID = 176844364689077340L;
    private final String[] names;
    private final IOCase caseSensitivity;

    public NameFileFilter(String name2) {
        this(name2, (IOCase)null);
    }

    public NameFileFilter(String name2, IOCase caseSensitivity) {
        if (name2 == null) {
            throw new IllegalArgumentException("The wildcard must not be null");
        }
        this.names = new String[]{name2};
        this.caseSensitivity = caseSensitivity == null ? IOCase.SENSITIVE : caseSensitivity;
    }

    public NameFileFilter(String ... names2) {
        this(names2, (IOCase)null);
    }

    public NameFileFilter(String[] names2, IOCase caseSensitivity) {
        if (names2 == null) {
            throw new IllegalArgumentException("The array of names must not be null");
        }
        this.names = new String[names2.length];
        System.arraycopy(names2, 0, this.names, 0, names2.length);
        this.caseSensitivity = caseSensitivity == null ? IOCase.SENSITIVE : caseSensitivity;
    }

    public NameFileFilter(List<String> names2) {
        this(names2, null);
    }

    public NameFileFilter(List<String> names2, IOCase caseSensitivity) {
        if (names2 == null) {
            throw new IllegalArgumentException("The list of names must not be null");
        }
        this.names = names2.toArray(EMPTY_STRING_ARRAY);
        this.caseSensitivity = caseSensitivity == null ? IOCase.SENSITIVE : caseSensitivity;
    }

    @Override
    public boolean accept(File file2) {
        String name2 = file2.getName();
        for (String name22 : this.names) {
            if (!this.caseSensitivity.checkEquals(name2, name22)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean accept(File dir, String name2) {
        for (String name22 : this.names) {
            if (!this.caseSensitivity.checkEquals(name2, name22)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(super.toString());
        buffer.append("(");
        if (this.names != null) {
            for (int i2 = 0; i2 < this.names.length; ++i2) {
                if (i2 > 0) {
                    buffer.append(",");
                }
                buffer.append(this.names[i2]);
            }
        }
        buffer.append(")");
        return buffer.toString();
    }
}

