/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.text;

import java.text.Format;
import java.text.MessageFormat;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.LocaleUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.text.FormatFactory;
import org.apache.commons.lang3.text.StrMatcher;

@Deprecated
public class ExtendedMessageFormat
extends MessageFormat {
    private static final long serialVersionUID = -2362048321261811743L;
    private static final int HASH_SEED = 31;
    private static final String DUMMY_PATTERN = "";
    private static final char START_FMT = ',';
    private static final char END_FE = '}';
    private static final char START_FE = '{';
    private static final char QUOTE = '\'';
    private String toPattern;
    private final Map<String, ? extends FormatFactory> registry;

    public ExtendedMessageFormat(String pattern) {
        this(pattern, Locale.getDefault());
    }

    public ExtendedMessageFormat(String pattern, Locale locale) {
        this(pattern, locale, null);
    }

    public ExtendedMessageFormat(String pattern, Map<String, ? extends FormatFactory> registry) {
        this(pattern, Locale.getDefault(), registry);
    }

    public ExtendedMessageFormat(String pattern, Locale locale, Map<String, ? extends FormatFactory> registry) {
        super(DUMMY_PATTERN);
        this.setLocale(LocaleUtils.toLocale(locale));
        this.registry = registry;
        this.applyPattern(pattern);
    }

    @Override
    public String toPattern() {
        return this.toPattern;
    }

    @Override
    public final void applyPattern(String pattern) {
        if (this.registry == null) {
            super.applyPattern(pattern);
            this.toPattern = super.toPattern();
            return;
        }
        ArrayList<Format> foundFormats = new ArrayList<Format>();
        ArrayList<String> foundDescriptions = new ArrayList<String>();
        StringBuilder stripCustom = new StringBuilder(pattern.length());
        ParsePosition pos2 = new ParsePosition(0);
        char[] c = pattern.toCharArray();
        int fmtCount = 0;
        block4: while (pos2.getIndex() < pattern.length()) {
            switch (c[pos2.getIndex()]) {
                case '\'': {
                    this.appendQuotedString(pattern, pos2, stripCustom);
                    continue block4;
                }
                case '{': {
                    ++fmtCount;
                    this.seekNonWs(pattern, pos2);
                    int start2 = pos2.getIndex();
                    int index2 = this.readArgumentIndex(pattern, this.next(pos2));
                    stripCustom.append('{').append(index2);
                    this.seekNonWs(pattern, pos2);
                    Format format = null;
                    String formatDescription = null;
                    if (c[pos2.getIndex()] == ',' && (format = this.getFormat(formatDescription = this.parseFormatDescription(pattern, this.next(pos2)))) == null) {
                        stripCustom.append(',').append(formatDescription);
                    }
                    foundFormats.add(format);
                    foundDescriptions.add(format == null ? null : formatDescription);
                    Validate.isTrue(foundFormats.size() == fmtCount);
                    Validate.isTrue(foundDescriptions.size() == fmtCount);
                    if (c[pos2.getIndex()] == '}') break;
                    throw new IllegalArgumentException("Unreadable format element at position " + start2);
                }
            }
            stripCustom.append(c[pos2.getIndex()]);
            this.next(pos2);
        }
        super.applyPattern(stripCustom.toString());
        this.toPattern = this.insertFormats(super.toPattern(), foundDescriptions);
        if (this.containsElements(foundFormats)) {
            Format[] origFormats = this.getFormats();
            int i2 = 0;
            for (Format f : foundFormats) {
                if (f != null) {
                    origFormats[i2] = f;
                }
                ++i2;
            }
            super.setFormats(origFormats);
        }
    }

    @Override
    public void setFormat(int formatElementIndex, Format newFormat) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setFormatByArgumentIndex(int argumentIndex, Format newFormat) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setFormats(Format[] newFormats) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setFormatsByArgumentIndex(Format[] newFormats) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (ObjectUtils.notEqual(this.getClass(), obj.getClass())) {
            return false;
        }
        ExtendedMessageFormat rhs = (ExtendedMessageFormat)obj;
        if (ObjectUtils.notEqual(this.toPattern, rhs.toPattern)) {
            return false;
        }
        return !ObjectUtils.notEqual(this.registry, rhs.registry);
    }

    @Override
    public int hashCode() {
        int result2 = super.hashCode();
        result2 = 31 * result2 + Objects.hashCode(this.registry);
        result2 = 31 * result2 + Objects.hashCode(this.toPattern);
        return result2;
    }

    private Format getFormat(String desc) {
        if (this.registry != null) {
            FormatFactory factory;
            String name2 = desc;
            String args2 = null;
            int i2 = desc.indexOf(44);
            if (i2 > 0) {
                name2 = desc.substring(0, i2).trim();
                args2 = desc.substring(i2 + 1).trim();
            }
            if ((factory = this.registry.get(name2)) != null) {
                return factory.getFormat(name2, args2, this.getLocale());
            }
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    private int readArgumentIndex(String pattern, ParsePosition pos) {
        start = pos.getIndex();
        this.seekNonWs(pattern, pos);
        result = new StringBuilder();
        error = false;
        while (!error && pos.getIndex() < pattern.length()) {
            c = pattern.charAt(pos.getIndex());
            if (!Character.isWhitespace(c)) ** GOTO lbl-1000
            this.seekNonWs(pattern, pos);
            c = pattern.charAt(pos.getIndex());
            if (c != ',' && c != '}') {
                error = true;
            } else lbl-1000:
            // 2 sources

            {
                if ((c == ',' || c == '}') && result.length() > 0) {
                    try {
                        return Integer.parseInt(result.toString());
                    }
                    catch (NumberFormatException var7_7) {
                        // empty catch block
                    }
                }
                error = Character.isDigit(c) == false;
                result.append(c);
            }
            this.next(pos);
        }
        if (error) {
            throw new IllegalArgumentException("Invalid format argument index at position " + start + ": " + pattern.substring(start, pos.getIndex()));
        }
        throw new IllegalArgumentException("Unterminated format element at position " + start);
    }

    private String parseFormatDescription(String pattern, ParsePosition pos2) {
        int start2 = pos2.getIndex();
        this.seekNonWs(pattern, pos2);
        int text = pos2.getIndex();
        int depth = 1;
        while (pos2.getIndex() < pattern.length()) {
            switch (pattern.charAt(pos2.getIndex())) {
                case '{': {
                    ++depth;
                    break;
                }
                case '}': {
                    if (--depth != 0) break;
                    return pattern.substring(text, pos2.getIndex());
                }
                case '\'': {
                    this.getQuotedString(pattern, pos2);
                    break;
                }
            }
            this.next(pos2);
        }
        throw new IllegalArgumentException("Unterminated format element at position " + start2);
    }

    private String insertFormats(String pattern, ArrayList<String> customPatterns) {
        if (!this.containsElements(customPatterns)) {
            return pattern;
        }
        StringBuilder sb = new StringBuilder(pattern.length() * 2);
        ParsePosition pos2 = new ParsePosition(0);
        int fe = -1;
        int depth = 0;
        block5: while (pos2.getIndex() < pattern.length()) {
            char c = pattern.charAt(pos2.getIndex());
            switch (c) {
                case '\'': {
                    this.appendQuotedString(pattern, pos2, sb);
                    break;
                }
                case '{': {
                    String customPattern;
                    sb.append('{').append(this.readArgumentIndex(pattern, this.next(pos2)));
                    if (++depth != 1 || (customPattern = customPatterns.get(++fe)) == null) continue block5;
                    sb.append(',').append(customPattern);
                    break;
                }
                case '}': {
                    --depth;
                }
                default: {
                    sb.append(c);
                    this.next(pos2);
                }
            }
        }
        return sb.toString();
    }

    private void seekNonWs(String pattern, ParsePosition pos2) {
        int len = 0;
        char[] buffer = pattern.toCharArray();
        do {
            len = StrMatcher.splitMatcher().isMatch(buffer, pos2.getIndex());
            pos2.setIndex(pos2.getIndex() + len);
        } while (len > 0 && pos2.getIndex() < pattern.length());
    }

    private ParsePosition next(ParsePosition pos2) {
        pos2.setIndex(pos2.getIndex() + 1);
        return pos2;
    }

    private StringBuilder appendQuotedString(String pattern, ParsePosition pos2, StringBuilder appendTo) {
        assert (pattern.toCharArray()[pos2.getIndex()] == '\'') : "Quoted string must start with quote character";
        if (appendTo != null) {
            appendTo.append('\'');
        }
        this.next(pos2);
        int start2 = pos2.getIndex();
        char[] c = pattern.toCharArray();
        int lastHold = start2;
        for (int i2 = pos2.getIndex(); i2 < pattern.length(); ++i2) {
            if (c[pos2.getIndex()] == '\'') {
                this.next(pos2);
                return appendTo == null ? null : appendTo.append(c, lastHold, pos2.getIndex() - lastHold);
            }
            this.next(pos2);
        }
        throw new IllegalArgumentException("Unterminated quoted string at position " + start2);
    }

    private void getQuotedString(String pattern, ParsePosition pos2) {
        this.appendQuotedString(pattern, pos2, null);
    }

    private boolean containsElements(Collection<?> coll) {
        if (coll == null || coll.isEmpty()) {
            return false;
        }
        for (Object name2 : coll) {
            if (name2 == null) continue;
            return true;
        }
        return false;
    }
}

