/*
 * Decompiled with CFR 0.152.
 */
package org.apache.curator.framework.imps;

import org.apache.curator.CuratorZookeeperClient;
import org.apache.curator.RetryLoop;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.CuratorEvent;
import org.apache.curator.framework.api.CuratorListener;
import org.apache.curator.framework.api.UnhandledErrorListener;
import org.apache.curator.framework.imps.CuratorFrameworkImpl;
import org.apache.curator.framework.imps.FailedDeleteManager;
import org.apache.curator.framework.imps.NamespaceImpl;
import org.apache.curator.framework.imps.OperationAndData;
import org.apache.curator.framework.listen.Listenable;
import org.apache.curator.framework.state.ConnectionStateListener;
import org.apache.curator.utils.EnsurePath;
import org.apache.zookeeper.ZooKeeper;

class NamespaceFacade
extends CuratorFrameworkImpl {
    private final CuratorFrameworkImpl client;
    private final NamespaceImpl namespace;
    private final FailedDeleteManager failedDeleteManager = new FailedDeleteManager(this);

    NamespaceFacade(CuratorFrameworkImpl client, String namespace) {
        super(client);
        this.client = client;
        this.namespace = new NamespaceImpl(client, namespace);
    }

    @Override
    public CuratorFramework nonNamespaceView() {
        return this.usingNamespace(null);
    }

    @Override
    public CuratorFramework usingNamespace(String newNamespace) {
        return this.client.getNamespaceFacadeCache().get(newNamespace);
    }

    @Override
    public String getNamespace() {
        return this.namespace.getNamespace();
    }

    @Override
    public void start() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Listenable<ConnectionStateListener> getConnectionStateListenable() {
        return this.client.getConnectionStateListenable();
    }

    @Override
    public Listenable<CuratorListener> getCuratorListenable() {
        throw new UnsupportedOperationException("getCuratorListenable() is only available from a non-namespaced CuratorFramework instance");
    }

    @Override
    public Listenable<UnhandledErrorListener> getUnhandledErrorListenable() {
        return this.client.getUnhandledErrorListenable();
    }

    @Override
    public void sync(String path2, Object context) {
        this.internalSync(this, path2, context);
    }

    @Override
    public CuratorZookeeperClient getZookeeperClient() {
        return this.client.getZookeeperClient();
    }

    @Override
    RetryLoop newRetryLoop() {
        return this.client.newRetryLoop();
    }

    @Override
    ZooKeeper getZooKeeper() throws Exception {
        return this.client.getZooKeeper();
    }

    @Override
    <DATA_TYPE> void processBackgroundOperation(OperationAndData<DATA_TYPE> operationAndData, CuratorEvent event) {
        this.client.processBackgroundOperation(operationAndData, event);
    }

    @Override
    void logError(String reason2, Throwable e) {
        this.client.logError(reason2, e);
    }

    @Override
    String unfixForNamespace(String path2) {
        return this.namespace.unfixForNamespace(path2);
    }

    @Override
    String fixForNamespace(String path2) {
        return this.namespace.fixForNamespace(path2, false);
    }

    @Override
    String fixForNamespace(String path2, boolean isSequential) {
        return this.namespace.fixForNamespace(path2, isSequential);
    }

    @Override
    public EnsurePath newNamespaceAwareEnsurePath(String path2) {
        return this.namespace.newNamespaceAwareEnsurePath(path2);
    }

    @Override
    FailedDeleteManager getFailedDeleteManager() {
        return this.failedDeleteManager;
    }
}

