/*
 * Decompiled with CFR 0.152.
 */
package org.apache.curator.utils;

import java.util.concurrent.TimeUnit;
import org.apache.curator.drivers.TracerDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultTracerDriver
implements TracerDriver {
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    @Override
    public void addTrace(String name2, long time, TimeUnit unit) {
        if (this.log.isTraceEnabled()) {
            this.log.trace("Trace: " + name2 + " - " + TimeUnit.MILLISECONDS.convert(time, unit) + " ms");
        }
    }

    @Override
    public void addCount(String name2, int increment) {
        if (this.log.isTraceEnabled()) {
            this.log.trace("Counter " + name2 + ": " + increment);
        }
    }
}

