/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.asn1.util;

import java.util.Arrays;
import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.util.Asn1StringUtils;
import org.apache.directory.api.i18n.I18n;

public class Oid {
    private long[] oidValues;
    private int hash;

    public Oid() {
        this.hash = 0;
    }

    public Oid(byte[] oid) throws DecoderException {
        this.setOid(oid);
        this.hash = this.computeHashCode();
    }

    public Oid(String oid) throws DecoderException {
        this.setOid(oid);
        this.hash = this.computeHashCode();
    }

    public void setOid(byte[] oid) throws DecoderException {
        int pos2;
        if (oid == null) {
            throw new DecoderException(I18n.err((I18n)I18n.ERR_00032_NULL_OID, (Object[])new Object[0]));
        }
        if (oid.length < 1) {
            throw new DecoderException(I18n.err((I18n)I18n.ERR_00033_INVALID_OID, (Object[])new Object[]{Asn1StringUtils.dumpBytes(oid)}));
        }
        int nbValues = 1;
        for (pos2 = 0; pos2 < oid.length; ++pos2) {
            if (oid[pos2] < 0) continue;
            ++nbValues;
        }
        this.oidValues = new long[nbValues];
        nbValues = 0;
        int accumulator = 0;
        if (oid[0] < 0 || oid[0] >= 80) {
            this.oidValues[nbValues++] = 2L;
            for (pos2 = 0; pos2 < oid.length; ++pos2) {
                if (oid[pos2] >= 0) {
                    this.oidValues[nbValues++] = (accumulator << 7) + oid[pos2] - 80;
                    accumulator = 0;
                    ++pos2;
                    break;
                }
                accumulator = (accumulator << 7) + (oid[pos2] & 0x7F);
            }
        } else if (oid[0] < 40) {
            this.oidValues[nbValues++] = 0L;
            this.oidValues[nbValues++] = oid[pos2++];
        } else {
            this.oidValues[nbValues++] = 1L;
            this.oidValues[nbValues++] = oid[pos2++] - 40;
        }
        while (pos2 < oid.length) {
            if (oid[pos2] >= 0) {
                this.oidValues[nbValues++] = (accumulator << 7) + oid[pos2];
                accumulator = 0;
            } else {
                accumulator = (accumulator << 7) + (oid[pos2] & 0x7F);
            }
            ++pos2;
        }
        this.hash = this.computeHashCode();
    }

    public void setOid(String oid) throws DecoderException {
        if (oid == null || oid.length() == 0) {
            throw new DecoderException(I18n.err((I18n)I18n.ERR_00032_NULL_OID, (Object[])new Object[0]));
        }
        int nbValues = 1;
        char[] chars2 = oid.toCharArray();
        boolean dotSeen = false;
        for (char c : chars2) {
            if (c == '.') {
                if (dotSeen) {
                    throw new DecoderException(I18n.err((I18n)I18n.ERR_00033_INVALID_OID, (Object[])new Object[]{oid}));
                }
                ++nbValues;
                dotSeen = true;
                continue;
            }
            dotSeen = false;
        }
        if (nbValues < 2) {
            throw new DecoderException(I18n.err((I18n)I18n.ERR_00033_INVALID_OID, (Object[])new Object[]{oid}));
        }
        this.oidValues = new long[nbValues];
        int pos2 = 0;
        int intPos = 0;
        boolean ituOrIso = false;
        switch (chars2[pos2]) {
            case '0': 
            case '1': 
            case '2': {
                ituOrIso = true;
                this.oidValues[intPos++] = chars2[pos2++] - 48;
                break;
            }
            default: {
                throw new DecoderException(I18n.err((I18n)I18n.ERR_00033_INVALID_OID, (Object[])new Object[]{oid}));
            }
        }
        if (chars2[pos2++] != '.') {
            throw new DecoderException(I18n.err((I18n)I18n.ERR_00033_INVALID_OID, (Object[])new Object[]{oid}));
        }
        dotSeen = true;
        int value2 = 0;
        for (int i2 = pos2; i2 < chars2.length; ++i2) {
            if (chars2[i2] == '.') {
                if (dotSeen) {
                    throw new DecoderException(I18n.err((I18n)I18n.ERR_00033_INVALID_OID, (Object[])new Object[]{oid}));
                }
                if (ituOrIso && value2 > 39) {
                    throw new DecoderException(I18n.err((I18n)I18n.ERR_00033_INVALID_OID, (Object[])new Object[]{oid}));
                }
                ituOrIso = false;
                ++nbValues;
                dotSeen = true;
                this.oidValues[intPos++] = value2;
                value2 = 0;
                continue;
            }
            if (chars2[i2] >= '0' && chars2[i2] <= '9') {
                dotSeen = false;
                value2 = value2 * 10 + chars2[i2] - 48;
                continue;
            }
            throw new DecoderException(I18n.err((I18n)I18n.ERR_00033_INVALID_OID, (Object[])new Object[]{oid}));
        }
        this.oidValues[intPos] = value2;
        this.hash = this.computeHashCode();
    }

    public long[] getOidValues() {
        long[] copy = new long[this.oidValues.length];
        System.arraycopy(this.oidValues, 0, copy, 0, this.oidValues.length);
        return copy;
    }

    public int getOidLength() {
        long value2 = this.oidValues[0] * 40L + this.oidValues[1];
        int nbBytes = 0;
        nbBytes = value2 < 128L ? 1 : (value2 < 16384L ? 2 : (value2 < 0x200000L ? 3 : (value2 < 0x10000000L ? 4 : 5)));
        for (int i2 = 2; i2 < this.oidValues.length; ++i2) {
            value2 = this.oidValues[i2];
            if (value2 < 128L) {
                ++nbBytes;
                continue;
            }
            if (value2 < 16384L) {
                nbBytes += 2;
                continue;
            }
            if (value2 < 0x200000L) {
                nbBytes += 3;
                continue;
            }
            if (value2 < 0x10000000L) {
                nbBytes += 4;
                continue;
            }
            nbBytes += 5;
        }
        return nbBytes;
    }

    public byte[] getOid() {
        long value2;
        long firstValues = value2 = this.oidValues[0] * 40L + this.oidValues[1];
        byte[] bytes2 = new byte[this.getOidLength()];
        int pos2 = 0;
        if (this.oidValues[0] < 2L) {
            bytes2[pos2++] = (byte)(this.oidValues[0] * 40L + this.oidValues[1]);
        } else if (firstValues < 128L) {
            bytes2[pos2++] = (byte)firstValues;
        } else if (firstValues < 16384L) {
            bytes2[pos2++] = (byte)(firstValues >> 7 | 0x80L);
            bytes2[pos2++] = (byte)(firstValues & 0x7FL);
        } else if (value2 < 0x200000L) {
            bytes2[pos2++] = (byte)(firstValues >> 14 | 0x80L);
            bytes2[pos2++] = (byte)(firstValues >> 7 & 0x7FL | 0x80L);
            bytes2[pos2++] = (byte)(firstValues & 0x7FL);
        } else if (value2 < 0x10000000L) {
            bytes2[pos2++] = (byte)(firstValues >> 21 | 0x80L);
            bytes2[pos2++] = (byte)(firstValues >> 14 & 0x7FL | 0x80L);
            bytes2[pos2++] = (byte)(firstValues >> 7 & 0x7FL | 0x80L);
            bytes2[pos2++] = (byte)(firstValues & 0x7FL);
        } else {
            bytes2[pos2++] = (byte)(firstValues >> 28 | 0x80L);
            bytes2[pos2++] = (byte)(firstValues >> 21 & 0x7FL | 0x80L);
            bytes2[pos2++] = (byte)(firstValues >> 14 & 0x7FL | 0x80L);
            bytes2[pos2++] = (byte)(firstValues >> 7 & 0x7FL | 0x80L);
            bytes2[pos2++] = (byte)(firstValues & 0x7FL);
        }
        for (int i2 = 2; i2 < this.oidValues.length; ++i2) {
            value2 = this.oidValues[i2];
            if (value2 < 128L) {
                bytes2[pos2++] = (byte)value2;
                continue;
            }
            if (value2 < 16384L) {
                bytes2[pos2++] = (byte)(value2 >> 7 | 0x80L);
                bytes2[pos2++] = (byte)(value2 & 0x7FL);
                continue;
            }
            if (value2 < 0x200000L) {
                bytes2[pos2++] = (byte)(value2 >> 14 | 0x80L);
                bytes2[pos2++] = (byte)(value2 >> 7 & 0x7FL | 0x80L);
                bytes2[pos2++] = (byte)(value2 & 0x7FL);
                continue;
            }
            if (value2 < 0x10000000L) {
                bytes2[pos2++] = (byte)(value2 >> 21 | 0x80L);
                bytes2[pos2++] = (byte)(value2 >> 14 & 0x7FL | 0x80L);
                bytes2[pos2++] = (byte)(value2 >> 7 & 0x7FL | 0x80L);
                bytes2[pos2++] = (byte)(value2 & 0x7FL);
                continue;
            }
            bytes2[pos2++] = (byte)(value2 >> 28 | 0x80L);
            bytes2[pos2++] = (byte)(value2 >> 21 & 0x7FL | 0x80L);
            bytes2[pos2++] = (byte)(value2 >> 14 & 0x7FL | 0x80L);
            bytes2[pos2++] = (byte)(value2 >> 7 & 0x7FL | 0x80L);
            bytes2[pos2++] = (byte)(value2 & 0x7FL);
        }
        return bytes2;
    }

    private int computeHashCode() {
        int h = 37;
        for (long val : this.oidValues) {
            int low = (int)(val & 0xFFFFL);
            int high = (int)(val >> 32);
            h = h * 17 + high;
            h = h * 17 + low;
        }
        return h;
    }

    public static boolean isOid(String oid) {
        if (oid == null || oid.length() == 0) {
            return false;
        }
        int nbValues = 1;
        byte[] bytes2 = oid.getBytes();
        boolean dotSeen = false;
        for (byte b : bytes2) {
            if (b == 46) {
                if (dotSeen) {
                    return false;
                }
                ++nbValues;
                dotSeen = true;
                continue;
            }
            dotSeen = false;
        }
        if (nbValues < 2) {
            return false;
        }
        int pos2 = 0;
        boolean ituOrIso = false;
        switch (bytes2[pos2++]) {
            case 48: 
            case 49: 
            case 50: {
                ituOrIso = true;
                break;
            }
            default: {
                return false;
            }
        }
        if (bytes2[pos2++] != 46) {
            return false;
        }
        dotSeen = true;
        long value2 = 0L;
        for (int i2 = pos2; i2 < bytes2.length; ++i2) {
            if (bytes2[i2] == 46) {
                if (dotSeen) {
                    return false;
                }
                if (ituOrIso && value2 > 39L) {
                    return false;
                }
                ituOrIso = false;
                ++nbValues;
                dotSeen = true;
                value2 = 0L;
                continue;
            }
            if (bytes2[i2] >= 48 && bytes2[i2] <= 57) {
                dotSeen = false;
                value2 = value2 * 10L + (long)bytes2[i2] - 48L;
                continue;
            }
            return false;
        }
        return !dotSeen;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.oidValues != null) {
            sb.append(this.oidValues[0]);
            for (int i2 = 1; i2 < this.oidValues.length; ++i2) {
                sb.append('.').append(this.oidValues[i2]);
            }
        }
        return sb.toString();
    }

    public int hashCode() {
        return this.hash;
    }

    public boolean equals(Object oid) {
        if (this == oid) {
            return true;
        }
        if (oid == null) {
            return false;
        }
        if (oid.getClass() != this.getClass()) {
            return false;
        }
        Oid instance = (Oid)oid;
        if (instance.hash != this.hash) {
            return false;
        }
        return Arrays.equals(instance.oidValues, this.oidValues);
    }
}

