/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos.shared.keytab;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.directory.server.kerberos.shared.keytab.KeytabEntry;
import org.apache.directory.shared.kerberos.KerberosTime;
import org.apache.directory.shared.kerberos.codec.types.EncryptionType;
import org.apache.directory.shared.kerberos.components.EncryptionKey;

class KeytabDecoder {
    KeytabDecoder() {
    }

    byte[] getKeytabVersion(ByteBuffer buffer) {
        byte[] version = new byte[2];
        buffer.get(version);
        return version;
    }

    List<KeytabEntry> getKeytabEntries(ByteBuffer buffer) {
        ArrayList<KeytabEntry> entries2 = new ArrayList<KeytabEntry>();
        while (buffer.remaining() > 0) {
            int size2 = buffer.getInt();
            byte[] entry = new byte[size2];
            buffer.get(entry);
            entries2.add(this.getKeytabEntry(ByteBuffer.wrap(entry)));
        }
        return entries2;
    }

    private KeytabEntry getKeytabEntry(ByteBuffer buffer) {
        String principalName = this.getPrincipalName(buffer);
        long principalType = buffer.getInt();
        long time = buffer.getInt();
        KerberosTime timeStamp = new KerberosTime(time * 1000L);
        byte keyVersion = buffer.get();
        EncryptionKey key2 = this.getKeyBlock(buffer);
        return new KeytabEntry(principalName, principalType, timeStamp, keyVersion, key2);
    }

    private String getPrincipalName(ByteBuffer buffer) {
        int count2 = buffer.getShort();
        String realm = this.getCountedString(buffer);
        StringBuffer principalNameBuffer = new StringBuffer();
        for (int ii = 0; ii < count2; ++ii) {
            String nameComponent = this.getCountedString(buffer);
            principalNameBuffer.append(nameComponent);
            if (ii >= count2 - 1) continue;
            principalNameBuffer.append("\\");
        }
        principalNameBuffer.append("@").append(realm);
        return principalNameBuffer.toString();
    }

    private EncryptionKey getKeyBlock(ByteBuffer buffer) {
        short type2 = buffer.getShort();
        byte[] keyblock = this.getCountedBytes(buffer);
        EncryptionType encryptionType = EncryptionType.getTypeByValue(type2);
        EncryptionKey key2 = new EncryptionKey(encryptionType, keyblock);
        return key2;
    }

    private String getCountedString(ByteBuffer buffer) {
        short length2 = buffer.getShort();
        byte[] data = new byte[length2];
        buffer.get(data);
        try {
            return new String(data, "ASCII");
        }
        catch (UnsupportedEncodingException uee) {
            return "";
        }
    }

    private byte[] getCountedBytes(ByteBuffer buffer) {
        short length2 = buffer.getShort();
        byte[] data = new byte[length2];
        buffer.get(data);
        return data;
    }
}

