/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.kerberos.codec.actions;

import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.ber.Asn1Container;
import org.apache.directory.api.asn1.ber.grammar.GrammarAction;
import org.apache.directory.api.asn1.ber.tlv.BerValue;
import org.apache.directory.api.asn1.ber.tlv.IntegerDecoder;
import org.apache.directory.api.asn1.ber.tlv.IntegerDecoderException;
import org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.util.Strings;
import org.apache.directory.shared.kerberos.KerberosMessageType;
import org.apache.directory.shared.kerberos.codec.kdcRep.KdcRepContainer;
import org.apache.directory.shared.kerberos.codec.kdcReq.KdcReqContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractReadMsgType<E extends Asn1Container>
extends GrammarAction<E> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractReadMsgType.class);
    private KerberosMessageType msgType = null;

    public AbstractReadMsgType(String name2) {
        super(name2);
    }

    public AbstractReadMsgType(String name2, KerberosMessageType msgType) {
        super(name2);
        this.msgType = msgType;
    }

    public final void action(E container) throws DecoderException {
        TLV tlv = container.getCurrentTLV();
        if (tlv.getLength() != 1) {
            LOG.error(I18n.err((I18n)I18n.ERR_04066, (Object[])new Object[0]));
            throw new DecoderException(I18n.err((I18n)I18n.ERR_04067, (Object[])new Object[0]));
        }
        BerValue value2 = tlv.getValue();
        try {
            int msgTypeValue = IntegerDecoder.parse((BerValue)value2);
            if (this.msgType != null) {
                if (this.msgType.getValue() == msgTypeValue) {
                    LOG.debug("msg-type : {}", (Object)this.msgType);
                    return;
                }
                String message2 = I18n.err((I18n)I18n.ERR_04070, (Object[])new Object[]{Strings.dumpBytes(value2.getData())});
                LOG.error(message2);
                throw new DecoderException(message2);
            }
            KerberosMessageType messageType = KerberosMessageType.getTypeByValue(msgTypeValue);
            if (container instanceof KdcReqContainer ? ((KdcReqContainer)((Object)container)).getKdcReq().getMessageType() == messageType : container instanceof KdcRepContainer && ((KdcRepContainer)((Object)container)).getKdcRep().getMessageType() == messageType) {
                return;
            }
            String message3 = I18n.err((I18n)I18n.ERR_04070, (Object[])new Object[]{Strings.dumpBytes(value2.getData())});
            LOG.error(message3);
            throw new DecoderException(message3);
        }
        catch (IntegerDecoderException ide) {
            LOG.error(I18n.err((I18n)I18n.ERR_04070, (Object[])new Object[]{Strings.dumpBytes(value2.getData()), ide.getLocalizedMessage()}));
            throw new DecoderException(ide.getMessage());
        }
    }
}

