/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.PrivateCellUtil;
import org.apache.hadoop.hbase.RawCell;
import org.apache.hadoop.hbase.io.HeapSize;
import org.apache.hadoop.hbase.util.ByteBufferUtils;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public interface ExtendedCell
extends RawCell,
HeapSize {
    public static final int CELL_NOT_BASED_ON_CHUNK = -1;

    default public int write(OutputStream out, boolean withTags) throws IOException {
        ByteBufferUtils.putInt(out, KeyValueUtil.keyLength(this));
        ByteBufferUtils.putInt(out, this.getValueLength());
        PrivateCellUtil.writeFlatKey((Cell)this, out);
        if (this.getValueLength() > 0) {
            out.write(this.getValueArray(), this.getValueOffset(), this.getValueLength());
        }
        if (withTags && this.getTagsLength() > 0) {
            out.write((byte)(0xFF & this.getTagsLength() >> 8));
            out.write((byte)(0xFF & this.getTagsLength()));
            out.write(this.getTagsArray(), this.getTagsOffset(), this.getTagsLength());
        }
        return this.getSerializedSize(withTags);
    }

    default public int getSerializedSize(boolean withTags) {
        return KeyValueUtil.length(this.getRowLength(), this.getFamilyLength(), this.getQualifierLength(), this.getValueLength(), this.getTagsLength(), withTags);
    }

    @Override
    default public int getSerializedSize() {
        return this.getSerializedSize(true);
    }

    default public void write(ByteBuffer buf, int offset2) {
        KeyValueUtil.appendTo(this, buf, offset2, true);
    }

    default public ExtendedCell deepClone() {
        return new KeyValue(this);
    }

    default public int getChunkId() {
        return -1;
    }

    public void setSequenceId(long var1) throws IOException;

    public void setTimestamp(long var1) throws IOException;

    public void setTimestamp(byte[] var1) throws IOException;

    @Override
    public long getSequenceId();

    @Override
    public byte[] getTagsArray();

    @Override
    public int getTagsOffset();

    @Override
    public int getTagsLength();

    @Override
    public byte getTypeByte();
}

