/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.filter;

import java.nio.ByteBuffer;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.util.ByteBufferUtils;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Public
public abstract class ByteArrayComparable
implements Comparable<byte[]> {
    byte[] value;

    public ByteArrayComparable(byte[] value2) {
        this.value = value2;
    }

    public byte[] getValue() {
        return this.value;
    }

    public abstract byte[] toByteArray();

    public static ByteArrayComparable parseFrom(byte[] pbBytes) throws DeserializationException {
        throw new DeserializationException("parseFrom called on base ByteArrayComparable, but should be called on derived type");
    }

    boolean areSerializedFieldsEqual(ByteArrayComparable other) {
        if (other == this) {
            return true;
        }
        return Bytes.equals(this.getValue(), other.getValue());
    }

    @Override
    public int compareTo(byte[] value2) {
        return this.compareTo(value2, 0, value2.length);
    }

    public abstract int compareTo(byte[] var1, int var2, int var3);

    public int compareTo(ByteBuffer value2, int offset2, int length2) {
        byte[] temp = new byte[length2];
        ByteBufferUtils.copyFromBufferToArray(temp, value2, offset2, 0, length2);
        return this.compareTo(temp);
    }
}

