/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.util;

import java.nio.ByteBuffer;
import java.util.HashMap;
import org.apache.hadoop.hbase.io.util.Dictionary;
import org.apache.hadoop.hbase.util.ByteBufferUtils;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hbase.thirdparty.com.google.common.base.Preconditions;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class LRUDictionary
implements Dictionary {
    BidirectionalLRUMap backingStore;

    @Override
    public byte[] getEntry(short idx) {
        return this.backingStore.get(idx);
    }

    @Override
    public void init(int initialSize) {
        this.backingStore = new BidirectionalLRUMap(initialSize);
    }

    @Override
    public short findEntry(byte[] data, int offset2, int length2) {
        short ret = this.backingStore.findIdx(data, offset2, length2);
        if (ret == -1) {
            this.addEntry(data, offset2, length2);
        }
        return ret;
    }

    @Override
    public short addEntry(byte[] data, int offset2, int length2) {
        return this.addEntryInternal(data, offset2, length2, true);
    }

    private short addEntryInternal(byte[] data, int offset2, int length2, boolean copy) {
        if (length2 <= 0) {
            return -1;
        }
        return this.backingStore.put(data, offset2, length2, copy);
    }

    @Override
    public void clear() {
        this.backingStore.clear();
    }

    @Override
    public short findEntry(ByteBuffer data, int offset2, int length2) {
        short ret = this.backingStore.findIdx(data, offset2, length2);
        if (ret == -1) {
            byte[] copy = new byte[length2];
            ByteBufferUtils.copyFromBufferToArray(copy, data, offset2, 0, length2);
            this.addEntryInternal(copy, 0, length2, false);
        }
        return ret;
    }

    static class BidirectionalLRUMap {
        private int currSize = 0;
        private Node head;
        private Node tail;
        private HashMap<Node, Short> nodeToIndex = new HashMap();
        private Node[] indexToNode;
        private int initSize = 0;

        public BidirectionalLRUMap(int initialSize) {
            this.initSize = initialSize;
            this.indexToNode = new Node[initialSize];
        }

        private short put(byte[] array, int offset2, int length2, boolean copy) {
            if (copy) {
                byte[] stored = new byte[length2];
                Bytes.putBytes(stored, 0, array, offset2, length2);
                return this.putInternal(stored);
            }
            return this.putInternal(array);
        }

        private short putInternal(byte[] stored) {
            if (this.currSize < this.initSize) {
                if (this.indexToNode[this.currSize] == null) {
                    this.indexToNode[this.currSize] = new ByteArrayBackedNode();
                }
                this.indexToNode[this.currSize].setContents(stored, 0, stored.length);
                this.setHead(this.indexToNode[this.currSize]);
                short ret = (short)this.currSize++;
                this.nodeToIndex.put(this.indexToNode[ret], ret);
                return ret;
            }
            short s2 = this.nodeToIndex.remove(this.tail);
            this.tail.setContents(stored, 0, stored.length);
            this.nodeToIndex.put(this.tail, s2);
            this.moveToHead(this.tail);
            return s2;
        }

        private short findIdx(byte[] array, int offset2, int length2) {
            ByteArrayBackedNode comparisonNode = new ByteArrayBackedNode();
            ((Node)comparisonNode).setContents(array, offset2, length2);
            Short s2 = this.nodeToIndex.get(comparisonNode);
            if (s2 != null) {
                this.moveToHead(this.indexToNode[s2]);
                return s2;
            }
            return -1;
        }

        private short findIdx(ByteBuffer buf, int offset2, int length2) {
            ByteBufferBackedNode comparisonNode = new ByteBufferBackedNode();
            comparisonNode.setContents(buf, offset2, length2);
            Short s2 = this.nodeToIndex.get(comparisonNode);
            if (s2 != null) {
                this.moveToHead(this.indexToNode[s2]);
                return s2;
            }
            return -1;
        }

        private byte[] get(short idx) {
            Preconditions.checkElementIndex(idx, this.currSize);
            this.moveToHead(this.indexToNode[idx]);
            return this.indexToNode[idx].getContents();
        }

        private void moveToHead(Node n) {
            if (this.head == n) {
                return;
            }
            assert (n.prev != null);
            n.prev.next = n.next;
            if (n.next != null) {
                n.next.prev = n.prev;
            } else {
                assert (n == this.tail);
                this.tail = n.prev;
            }
            this.setHead(n);
        }

        private void setHead(Node n) {
            n.prev = null;
            n.next = this.head;
            if (this.head != null) {
                assert (this.head.prev == null);
                this.head.prev = n;
            }
            this.head = n;
            if (this.tail == null) {
                this.tail = n;
            }
        }

        private void clear() {
            for (int i2 = 0; i2 < this.currSize; ++i2) {
                this.indexToNode[i2].next = null;
                this.indexToNode[i2].prev = null;
                this.indexToNode[i2].resetContents();
            }
            this.currSize = 0;
            this.nodeToIndex.clear();
            this.tail = null;
            this.head = null;
        }

        private static class ByteBufferBackedNode
        extends Node {
            private ByteBuffer container;

            @Override
            void setContents(byte[] container, int offset2, int length2) {
                this.container = ByteBuffer.wrap(container);
                this.offset = offset2;
                this.length = length2;
            }

            void setContents(ByteBuffer container, int offset2, int length2) {
                this.container = container;
                this.offset = offset2;
                this.length = length2;
            }

            @Override
            void resetContents() {
                this.container = null;
            }

            @Override
            byte[] getContents() {
                byte[] copy = new byte[this.length];
                ByteBufferUtils.copyFromBufferToArray(copy, this.container, this.offset, 0, this.length);
                return copy;
            }

            public int hashCode() {
                return ByteBufferUtils.hashCode(this.container, this.offset, this.length);
            }

            public boolean equals(Object other) {
                if (!(other instanceof Node)) {
                    return false;
                }
                Node casted = (Node)other;
                return ByteBufferUtils.equals(this.container, this.offset, this.length, casted.getContents(), casted.offset, casted.length);
            }
        }

        private static class ByteArrayBackedNode
        extends Node {
            private byte[] container;

            private ByteArrayBackedNode() {
            }

            @Override
            void setContents(byte[] container, int offset2, int length2) {
                this.container = container;
                this.offset = offset2;
                this.length = length2;
            }

            @Override
            byte[] getContents() {
                return this.container;
            }

            public int hashCode() {
                return Bytes.hashCode(this.container, this.offset, this.length);
            }

            @Override
            void resetContents() {
                this.container = null;
            }

            public boolean equals(Object other) {
                if (!(other instanceof Node)) {
                    return false;
                }
                Node casted = (Node)other;
                return Bytes.equals(this.container, this.offset, this.length, casted.getContents(), casted.offset, casted.length);
            }
        }

        private static abstract class Node {
            int offset;
            int length;
            Node next;
            Node prev;

            private Node() {
            }

            abstract void setContents(byte[] var1, int var2, int var3);

            abstract byte[] getContents();

            abstract void resetContents();
        }
    }
}

