/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.metrics.Meter;
import org.apache.hadoop.hbase.metrics.MetricRegistry;
import org.apache.hadoop.hbase.regionserver.MetricsTableQueryMeter;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class MetricsTableQueryMeterImpl
implements MetricsTableQueryMeter {
    private final Map<TableName, TableMeters> metersByTable = new ConcurrentHashMap<TableName, TableMeters>();
    private final MetricRegistry metricRegistry;

    public MetricsTableQueryMeterImpl(MetricRegistry metricRegistry) {
        this.metricRegistry = metricRegistry;
    }

    private static String qualifyMetricsName(TableName tableName, String metric) {
        StringBuilder sb = new StringBuilder();
        sb.append("Namespace_").append(tableName.getNamespaceAsString());
        sb.append("_table_").append(tableName.getQualifierAsString());
        sb.append("_metric_").append(metric);
        return sb.toString();
    }

    private TableMeters getOrCreateTableMeter(TableName tableName) {
        return this.metersByTable.computeIfAbsent(tableName, tbn -> new TableMeters(this.metricRegistry, (TableName)tbn));
    }

    @Override
    public void updateTableReadQueryMeter(TableName tableName, long count2) {
        this.getOrCreateTableMeter(tableName).updateTableReadQueryMeter(count2);
    }

    @Override
    public void updateTableReadQueryMeter(TableName tableName) {
        this.getOrCreateTableMeter(tableName).updateTableReadQueryMeter();
    }

    @Override
    public void updateTableWriteQueryMeter(TableName tableName, long count2) {
        this.getOrCreateTableMeter(tableName).updateTableWriteQueryMeter(count2);
    }

    @Override
    public void updateTableWriteQueryMeter(TableName tableName) {
        this.getOrCreateTableMeter(tableName).updateTableWriteQueryMeter();
    }

    private static class TableMeters {
        final Meter tableReadQueryMeter;
        final Meter tableWriteQueryMeter;

        TableMeters(MetricRegistry metricRegistry, TableName tableName) {
            this.tableReadQueryMeter = metricRegistry.meter(MetricsTableQueryMeterImpl.qualifyMetricsName(tableName, "tableReadQueryPerSecond"));
            this.tableWriteQueryMeter = metricRegistry.meter(MetricsTableQueryMeterImpl.qualifyMetricsName(tableName, "tableWriteQueryPerSecond"));
        }

        public void updateTableReadQueryMeter(long count2) {
            this.tableReadQueryMeter.mark(count2);
        }

        public void updateTableReadQueryMeter() {
            this.tableReadQueryMeter.mark();
        }

        public void updateTableWriteQueryMeter(long count2) {
            this.tableWriteQueryMeter.mark(count2);
        }

        public void updateTableWriteQueryMeter() {
            this.tableWriteQueryMeter.mark();
        }
    }
}

