/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security.visibility;

import java.util.regex.Pattern;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class VisibilityLabelsValidator {
    private static final boolean[] validAuthChars;
    public static final String regex = "[A-Za-z_\\-\\:\\/\\.0-9]+";
    public static final Pattern pattern;

    static final boolean isValidAuthChar(byte b) {
        return validAuthChars[0xFF & b];
    }

    public static final boolean isValidLabel(byte[] label) {
        for (int i2 = 0; i2 < label.length; ++i2) {
            if (VisibilityLabelsValidator.isValidAuthChar(label[i2])) continue;
            return false;
        }
        return true;
    }

    static {
        int i2;
        validAuthChars = new boolean[256];
        pattern = Pattern.compile(regex);
        for (i2 = 0; i2 < 256; ++i2) {
            VisibilityLabelsValidator.validAuthChars[i2] = false;
        }
        for (i2 = 97; i2 <= 122; ++i2) {
            VisibilityLabelsValidator.validAuthChars[i2] = true;
        }
        for (i2 = 65; i2 <= 90; ++i2) {
            VisibilityLabelsValidator.validAuthChars[i2] = true;
        }
        for (i2 = 48; i2 <= 57; ++i2) {
            VisibilityLabelsValidator.validAuthChars[i2] = true;
        }
        VisibilityLabelsValidator.validAuthChars[95] = true;
        VisibilityLabelsValidator.validAuthChars[45] = true;
        VisibilityLabelsValidator.validAuthChars[58] = true;
        VisibilityLabelsValidator.validAuthChars[46] = true;
        VisibilityLabelsValidator.validAuthChars[47] = true;
    }
}

