/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.types;

import org.apache.hadoop.hbase.types.DataType;
import org.apache.hadoop.hbase.types.StructIterator;
import org.apache.hadoop.hbase.util.Order;
import org.apache.hadoop.hbase.util.PositionedByteRange;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Public
public class Struct
implements DataType<Object[]> {
    protected final DataType[] fields;
    protected final boolean isOrderPreserving;
    protected final boolean isSkippable;

    public Struct(DataType[] memberTypes) {
        this.fields = memberTypes;
        boolean preservesOrder = true;
        boolean skippable = true;
        for (int i2 = 0; i2 < this.fields.length; ++i2) {
            DataType dt = this.fields[i2];
            if (!dt.isOrderPreserving()) {
                preservesOrder = false;
            }
            if (i2 < this.fields.length - 2 && !dt.isSkippable()) {
                throw new IllegalArgumentException("Field in position " + i2 + " is not skippable. Non-right-most struct fields must be skippable.");
            }
            if (dt.isSkippable()) continue;
            skippable = false;
        }
        this.isOrderPreserving = preservesOrder;
        this.isSkippable = skippable;
    }

    @Override
    public boolean isOrderPreserving() {
        return this.isOrderPreserving;
    }

    @Override
    public Order getOrder() {
        return null;
    }

    @Override
    public boolean isNullable() {
        return false;
    }

    @Override
    public boolean isSkippable() {
        return this.isSkippable;
    }

    @Override
    public int encodedLength(Object[] val) {
        assert (this.fields.length >= val.length);
        int sum2 = 0;
        for (int i2 = 0; i2 < val.length; ++i2) {
            sum2 += this.fields[i2].encodedLength(val[i2]);
        }
        return sum2;
    }

    @Override
    public Class<Object[]> encodedClass() {
        return Object[].class;
    }

    public StructIterator iterator(PositionedByteRange src) {
        return new StructIterator(src, this.fields);
    }

    @Override
    public int skip(PositionedByteRange src) {
        StructIterator it = this.iterator(src);
        int skipped = 0;
        while (it.hasNext()) {
            skipped += it.skip();
        }
        return skipped;
    }

    @Override
    public Object[] decode(PositionedByteRange src) {
        int i2 = 0;
        Object[] ret = new Object[this.fields.length];
        StructIterator it = this.iterator(src);
        while (it.hasNext()) {
            ret[i2++] = it.next();
        }
        return ret;
    }

    public Object decode(PositionedByteRange src, int index2) {
        assert (index2 >= 0);
        StructIterator it = this.iterator(src.shallowCopy());
        while (index2 > 0) {
            it.skip();
            --index2;
        }
        return it.next();
    }

    @Override
    public int encode(PositionedByteRange dst, Object[] val) {
        int end2;
        if (val.length == 0) {
            return 0;
        }
        assert (this.fields.length >= val.length);
        int written = 0;
        for (end2 = val.length - 1; end2 > -1 && null == val[end2] && (null != val[end2] || this.fields[end2].isNullable()); --end2) {
        }
        for (int i2 = 0; i2 <= end2; ++i2) {
            written += this.fields[i2].encode(dst, val[i2]);
        }
        return written;
    }
}

