/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.PrivateCellUtil;
import org.apache.hadoop.hbase.util.CellHashKey;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class RowColBloomHashKey
extends CellHashKey {
    private final int rowLength;
    private final int qualLength;

    public RowColBloomHashKey(Cell cell) {
        super(cell);
        this.rowLength = cell.getRowLength();
        this.qualLength = cell.getQualifierLength();
    }

    @Override
    public byte get(int offset2) {
        if (offset2 < 2) {
            int rowlen = this.rowLength;
            byte b = (byte)rowlen;
            if (offset2 == 0) {
                b = (byte)(rowlen >>= 8);
            }
            return b;
        }
        int refLen = 2 + this.rowLength;
        if (offset2 < refLen) {
            return PrivateCellUtil.getRowByte((Cell)this.t, offset2 - 2);
        }
        if (offset2 == refLen) {
            return 0;
        }
        if (offset2 < (refLen += this.qualLength + 1)) {
            return PrivateCellUtil.getQualifierByte((Cell)this.t, offset2 - (2 + this.rowLength + 1));
        }
        if (offset2 < (refLen += 8)) {
            return LATEST_TS[offset2 - (2 + this.rowLength + this.qualLength + 1)];
        }
        return MAX_TYPE;
    }

    @Override
    public int length() {
        return 2 + ((Cell)this.t).getRowLength() + 1 + ((Cell)this.t).getQualifierLength() + 9;
    }
}

