/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import org.apache.commons.lang3.StringUtils;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public final class Strings {
    public static final String DEFAULT_SEPARATOR = "=";
    public static final String DEFAULT_KEYVALUE_SEPARATOR = ", ";

    private Strings() {
    }

    public static StringBuilder appendKeyValue(StringBuilder sb, String key2, Object value2) {
        return Strings.appendKeyValue(sb, key2, value2, DEFAULT_SEPARATOR, DEFAULT_KEYVALUE_SEPARATOR);
    }

    public static StringBuilder appendKeyValue(StringBuilder sb, String key2, Object value2, String separator, String keyValueSeparator) {
        if (sb.length() > 0) {
            sb.append(keyValueSeparator);
        }
        return sb.append(key2).append(separator).append(value2);
    }

    public static String domainNamePointerToHostName(String dnPtr) {
        if (dnPtr == null) {
            return null;
        }
        return dnPtr.endsWith(".") ? dnPtr.substring(0, dnPtr.length() - 1) : dnPtr;
    }

    public static String padFront(String input, char padding, int length2) {
        if (input.length() > length2) {
            throw new IllegalArgumentException("input \"" + input + "\" longer than maxLength=" + length2);
        }
        int numPaddingCharacters = length2 - input.length();
        return StringUtils.repeat(padding, numPaddingCharacters) + input;
    }
}

