/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hbase.thirdparty.com.google.common.collect;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.concurrent.LazyInit;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Spliterator;
import java.util.Spliterators;
import org.apache.hbase.thirdparty.com.google.common.annotations.GwtCompatible;
import org.apache.hbase.thirdparty.com.google.common.base.Preconditions;
import org.apache.hbase.thirdparty.com.google.common.collect.Iterators;
import org.apache.hbase.thirdparty.com.google.common.collect.Maps;
import org.apache.hbase.thirdparty.com.google.common.collect.Multimap;
import org.apache.hbase.thirdparty.com.google.common.collect.Multimaps;
import org.apache.hbase.thirdparty.com.google.common.collect.Multiset;
import org.apache.hbase.thirdparty.com.google.common.collect.SetMultimap;
import org.apache.hbase.thirdparty.com.google.common.collect.Sets;
import org.checkerframework.checker.nullness.qual.Nullable;

@GwtCompatible
abstract class AbstractMultimap<K, V>
implements Multimap<K, V> {
    @LazyInit
    private transient @Nullable Collection<Map.Entry<K, V>> entries;
    @LazyInit
    private transient @Nullable Set<K> keySet;
    @LazyInit
    private transient @Nullable Multiset<K> keys;
    @LazyInit
    private transient @Nullable Collection<V> values;
    @LazyInit
    private transient @Nullable Map<K, Collection<V>> asMap;

    AbstractMultimap() {
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean containsValue(@Nullable Object value2) {
        for (Collection<V> collection : this.asMap().values()) {
            if (!collection.contains(value2)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsEntry(@Nullable Object key2, @Nullable Object value2) {
        Collection<V> collection = this.asMap().get(key2);
        return collection != null && collection.contains(value2);
    }

    @Override
    @CanIgnoreReturnValue
    public boolean remove(@Nullable Object key2, @Nullable Object value2) {
        Collection<V> collection = this.asMap().get(key2);
        return collection != null && collection.remove(value2);
    }

    @Override
    @CanIgnoreReturnValue
    public boolean put(@Nullable K key2, @Nullable V value2) {
        return this.get(key2).add(value2);
    }

    @Override
    @CanIgnoreReturnValue
    public boolean putAll(@Nullable K key2, Iterable<? extends V> values) {
        Preconditions.checkNotNull(values);
        if (values instanceof Collection) {
            Collection valueCollection = (Collection)values;
            return !valueCollection.isEmpty() && this.get(key2).addAll(valueCollection);
        }
        Iterator<V> valueItr = values.iterator();
        return valueItr.hasNext() && Iterators.addAll(this.get(key2), valueItr);
    }

    @Override
    @CanIgnoreReturnValue
    public boolean putAll(Multimap<? extends K, ? extends V> multimap) {
        boolean changed = false;
        for (Map.Entry<K, V> entry : multimap.entries()) {
            changed |= this.put(entry.getKey(), entry.getValue());
        }
        return changed;
    }

    @Override
    @CanIgnoreReturnValue
    public Collection<V> replaceValues(@Nullable K key2, Iterable<? extends V> values) {
        Preconditions.checkNotNull(values);
        Collection result2 = this.removeAll(key2);
        this.putAll(key2, values);
        return result2;
    }

    @Override
    public Collection<Map.Entry<K, V>> entries() {
        Collection<Map.Entry<K, V>> result2 = this.entries;
        return result2 == null ? (this.entries = this.createEntries()) : result2;
    }

    abstract Collection<Map.Entry<K, V>> createEntries();

    abstract Iterator<Map.Entry<K, V>> entryIterator();

    Spliterator<Map.Entry<K, V>> entrySpliterator() {
        return Spliterators.spliterator(this.entryIterator(), (long)this.size(), this instanceof SetMultimap ? 1 : 0);
    }

    @Override
    public Set<K> keySet() {
        Set<K> result2 = this.keySet;
        return result2 == null ? (this.keySet = this.createKeySet()) : result2;
    }

    abstract Set<K> createKeySet();

    @Override
    public Multiset<K> keys() {
        Multiset<K> result2 = this.keys;
        return result2 == null ? (this.keys = this.createKeys()) : result2;
    }

    abstract Multiset<K> createKeys();

    @Override
    public Collection<V> values() {
        Collection<V> result2 = this.values;
        return result2 == null ? (this.values = this.createValues()) : result2;
    }

    abstract Collection<V> createValues();

    Iterator<V> valueIterator() {
        return Maps.valueIterator(this.entries().iterator());
    }

    Spliterator<V> valueSpliterator() {
        return Spliterators.spliterator(this.valueIterator(), (long)this.size(), 0);
    }

    @Override
    public Map<K, Collection<V>> asMap() {
        Map<K, Collection<Collection<V>>> result2 = this.asMap;
        return result2 == null ? (this.asMap = this.createAsMap()) : result2;
    }

    abstract Map<K, Collection<V>> createAsMap();

    @Override
    public boolean equals(@Nullable Object object) {
        return Multimaps.equalsImpl(this, object);
    }

    @Override
    public int hashCode() {
        return this.asMap().hashCode();
    }

    public String toString() {
        return this.asMap().toString();
    }

    class Values
    extends AbstractCollection<V> {
        Values() {
        }

        @Override
        public Iterator<V> iterator() {
            return AbstractMultimap.this.valueIterator();
        }

        @Override
        public Spliterator<V> spliterator() {
            return AbstractMultimap.this.valueSpliterator();
        }

        @Override
        public int size() {
            return AbstractMultimap.this.size();
        }

        @Override
        public boolean contains(@Nullable Object o) {
            return AbstractMultimap.this.containsValue(o);
        }

        @Override
        public void clear() {
            AbstractMultimap.this.clear();
        }
    }

    class EntrySet
    extends Entries
    implements Set<Map.Entry<K, V>> {
        EntrySet(AbstractMultimap this$0) {
        }

        @Override
        public int hashCode() {
            return Sets.hashCodeImpl(this);
        }

        @Override
        public boolean equals(@Nullable Object obj) {
            return Sets.equalsImpl(this, obj);
        }
    }

    class Entries
    extends Multimaps.Entries<K, V> {
        Entries() {
        }

        @Override
        Multimap<K, V> multimap() {
            return AbstractMultimap.this;
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return AbstractMultimap.this.entryIterator();
        }

        @Override
        public Spliterator<Map.Entry<K, V>> spliterator() {
            return AbstractMultimap.this.entrySpliterator();
        }
    }
}

