/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hbase.thirdparty.com.google.common.collect;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.hbase.thirdparty.com.google.common.annotations.GwtCompatible;
import org.apache.hbase.thirdparty.com.google.common.collect.AbstractMapBasedMultimap;
import org.apache.hbase.thirdparty.com.google.common.collect.SetMultimap;
import org.checkerframework.checker.nullness.qual.Nullable;

@GwtCompatible
abstract class AbstractSetMultimap<K, V>
extends AbstractMapBasedMultimap<K, V>
implements SetMultimap<K, V> {
    private static final long serialVersionUID = 7431625294878419160L;

    protected AbstractSetMultimap(Map<K, Collection<V>> map) {
        super(map);
    }

    @Override
    abstract Set<V> createCollection();

    @Override
    Set<V> createUnmodifiableEmptyCollection() {
        return Collections.emptySet();
    }

    @Override
    <E> Collection<E> unmodifiableCollectionSubclass(Collection<E> collection) {
        return Collections.unmodifiableSet((Set)collection);
    }

    @Override
    Collection<V> wrapCollection(K key2, Collection<V> collection) {
        return new AbstractMapBasedMultimap.WrappedSet(key2, (Set)collection);
    }

    @Override
    public Set<V> get(@Nullable K key2) {
        return (Set)super.get(key2);
    }

    @Override
    public Set<Map.Entry<K, V>> entries() {
        return (Set)super.entries();
    }

    @Override
    @CanIgnoreReturnValue
    public Set<V> removeAll(@Nullable Object key2) {
        return (Set)super.removeAll(key2);
    }

    @Override
    @CanIgnoreReturnValue
    public Set<V> replaceValues(@Nullable K key2, Iterable<? extends V> values) {
        return (Set)super.replaceValues(key2, values);
    }

    @Override
    public Map<K, Collection<V>> asMap() {
        return super.asMap();
    }

    @Override
    @CanIgnoreReturnValue
    public boolean put(@Nullable K key2, @Nullable V value2) {
        return super.put(key2, value2);
    }

    @Override
    public boolean equals(@Nullable Object object) {
        return super.equals(object);
    }
}

