/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hbase.thirdparty.com.google.protobuf;

import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.hbase.thirdparty.com.google.protobuf.ExtensionRegistryLite;
import org.apache.hbase.thirdparty.com.google.protobuf.Internal;
import org.apache.hbase.thirdparty.com.google.protobuf.ManifestSchemaFactory;
import org.apache.hbase.thirdparty.com.google.protobuf.MessageSchema;
import org.apache.hbase.thirdparty.com.google.protobuf.Reader;
import org.apache.hbase.thirdparty.com.google.protobuf.Schema;
import org.apache.hbase.thirdparty.com.google.protobuf.SchemaFactory;
import org.apache.hbase.thirdparty.com.google.protobuf.Writer;

final class Protobuf {
    private static final Protobuf INSTANCE = new Protobuf();
    private final SchemaFactory schemaFactory;
    private final ConcurrentMap<Class<?>, Schema<?>> schemaCache = new ConcurrentHashMap();

    public static Protobuf getInstance() {
        return INSTANCE;
    }

    public <T> void writeTo(T message2, Writer writer) throws IOException {
        this.schemaFor(message2).writeTo(message2, writer);
    }

    public <T> void mergeFrom(T message2, Reader reader) throws IOException {
        this.mergeFrom(message2, reader, ExtensionRegistryLite.getEmptyRegistry());
    }

    public <T> void mergeFrom(T message2, Reader reader, ExtensionRegistryLite extensionRegistry) throws IOException {
        this.schemaFor(message2).mergeFrom(message2, reader, extensionRegistry);
    }

    public <T> void makeImmutable(T message2) {
        this.schemaFor(message2).makeImmutable(message2);
    }

    <T> boolean isInitialized(T message2) {
        return this.schemaFor(message2).isInitialized(message2);
    }

    public <T> Schema<T> schemaFor(Class<T> messageType) {
        Schema<?> previous;
        Internal.checkNotNull(messageType, "messageType");
        Schema<Object> schema = (Schema<T>)this.schemaCache.get(messageType);
        if (schema == null && (previous = this.registerSchema(messageType, schema = this.schemaFactory.createSchema(messageType))) != null) {
            schema = previous;
        }
        return schema;
    }

    public <T> Schema<T> schemaFor(T message2) {
        return this.schemaFor((T)message2.getClass());
    }

    public Schema<?> registerSchema(Class<?> messageType, Schema<?> schema) {
        Internal.checkNotNull(messageType, "messageType");
        Internal.checkNotNull(schema, "schema");
        return this.schemaCache.putIfAbsent(messageType, schema);
    }

    public Schema<?> registerSchemaOverride(Class<?> messageType, Schema<?> schema) {
        Internal.checkNotNull(messageType, "messageType");
        Internal.checkNotNull(schema, "schema");
        return this.schemaCache.put(messageType, schema);
    }

    private Protobuf() {
        this.schemaFactory = new ManifestSchemaFactory();
    }

    int getTotalSchemaSize() {
        int result2 = 0;
        for (Schema schema : this.schemaCache.values()) {
            if (!(schema instanceof MessageSchema)) continue;
            result2 += ((MessageSchema)schema).getSchemaSize();
        }
        return result2;
    }
}

