/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hbase.thirdparty.io.netty.buffer;

import java.nio.ByteBuffer;
import org.apache.hbase.thirdparty.io.netty.buffer.ByteBuf;
import org.apache.hbase.thirdparty.io.netty.buffer.ByteBufAllocator;
import org.apache.hbase.thirdparty.io.netty.buffer.ReadOnlyByteBufferBuf;
import org.apache.hbase.thirdparty.io.netty.buffer.UnsafeByteBufUtil;
import org.apache.hbase.thirdparty.io.netty.util.internal.ObjectUtil;
import org.apache.hbase.thirdparty.io.netty.util.internal.PlatformDependent;

final class ReadOnlyUnsafeDirectByteBuf
extends ReadOnlyByteBufferBuf {
    private final long memoryAddress;

    ReadOnlyUnsafeDirectByteBuf(ByteBufAllocator allocator, ByteBuffer byteBuffer) {
        super(allocator, byteBuffer);
        this.memoryAddress = PlatformDependent.directBufferAddress(this.buffer);
    }

    @Override
    protected byte _getByte(int index2) {
        return UnsafeByteBufUtil.getByte(this.addr(index2));
    }

    @Override
    protected short _getShort(int index2) {
        return UnsafeByteBufUtil.getShort(this.addr(index2));
    }

    @Override
    protected int _getUnsignedMedium(int index2) {
        return UnsafeByteBufUtil.getUnsignedMedium(this.addr(index2));
    }

    @Override
    protected int _getInt(int index2) {
        return UnsafeByteBufUtil.getInt(this.addr(index2));
    }

    @Override
    protected long _getLong(int index2) {
        return UnsafeByteBufUtil.getLong(this.addr(index2));
    }

    @Override
    public ByteBuf getBytes(int index2, ByteBuf dst, int dstIndex, int length2) {
        this.checkIndex(index2, length2);
        ObjectUtil.checkNotNull(dst, "dst");
        if (dstIndex < 0 || dstIndex > dst.capacity() - length2) {
            throw new IndexOutOfBoundsException("dstIndex: " + dstIndex);
        }
        if (dst.hasMemoryAddress()) {
            PlatformDependent.copyMemory(this.addr(index2), dst.memoryAddress() + (long)dstIndex, length2);
        } else if (dst.hasArray()) {
            PlatformDependent.copyMemory(this.addr(index2), dst.array(), dst.arrayOffset() + dstIndex, (long)length2);
        } else {
            dst.setBytes(dstIndex, this, index2, length2);
        }
        return this;
    }

    @Override
    public ByteBuf getBytes(int index2, byte[] dst, int dstIndex, int length2) {
        this.checkIndex(index2, length2);
        ObjectUtil.checkNotNull(dst, "dst");
        if (dstIndex < 0 || dstIndex > dst.length - length2) {
            throw new IndexOutOfBoundsException(String.format("dstIndex: %d, length: %d (expected: range(0, %d))", dstIndex, length2, dst.length));
        }
        if (length2 != 0) {
            PlatformDependent.copyMemory(this.addr(index2), dst, dstIndex, (long)length2);
        }
        return this;
    }

    @Override
    public ByteBuf copy(int index2, int length2) {
        this.checkIndex(index2, length2);
        ByteBuf copy = this.alloc().directBuffer(length2, this.maxCapacity());
        if (length2 != 0) {
            if (copy.hasMemoryAddress()) {
                PlatformDependent.copyMemory(this.addr(index2), copy.memoryAddress(), length2);
                copy.setIndex(0, length2);
            } else {
                copy.writeBytes(this, index2, length2);
            }
        }
        return copy;
    }

    @Override
    public boolean hasMemoryAddress() {
        return true;
    }

    @Override
    public long memoryAddress() {
        return this.memoryAddress;
    }

    private long addr(int index2) {
        return this.memoryAddress + (long)index2;
    }
}

