/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hbase.thirdparty.io.netty.handler.codec.http;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.hbase.thirdparty.io.netty.handler.codec.DefaultHeaders;
import org.apache.hbase.thirdparty.io.netty.handler.codec.Headers;
import org.apache.hbase.thirdparty.io.netty.handler.codec.ValueConverter;
import org.apache.hbase.thirdparty.io.netty.handler.codec.http.DefaultHttpHeaders;
import org.apache.hbase.thirdparty.io.netty.handler.codec.http.HttpHeaderNames;
import org.apache.hbase.thirdparty.io.netty.util.AsciiString;
import org.apache.hbase.thirdparty.io.netty.util.HashingStrategy;
import org.apache.hbase.thirdparty.io.netty.util.internal.StringUtil;

public class CombinedHttpHeaders
extends DefaultHttpHeaders {
    public CombinedHttpHeaders(boolean validate) {
        super(new CombinedHttpHeadersImpl(AsciiString.CASE_INSENSITIVE_HASHER, CombinedHttpHeaders.valueConverter(validate), CombinedHttpHeaders.nameValidator(validate)));
    }

    @Override
    public boolean containsValue(CharSequence name2, CharSequence value2, boolean ignoreCase) {
        return super.containsValue(name2, StringUtil.trimOws(value2), ignoreCase);
    }

    private static final class CombinedHttpHeadersImpl
    extends DefaultHeaders<CharSequence, CharSequence, CombinedHttpHeadersImpl> {
        private static final int VALUE_LENGTH_ESTIMATE = 10;
        private CsvValueEscaper<Object> objectEscaper;
        private CsvValueEscaper<CharSequence> charSequenceEscaper;

        private CsvValueEscaper<Object> objectEscaper() {
            if (this.objectEscaper == null) {
                this.objectEscaper = new CsvValueEscaper<Object>(){

                    @Override
                    public CharSequence escape(Object value2) {
                        return StringUtil.escapeCsv((CharSequence)CombinedHttpHeadersImpl.this.valueConverter().convertObject(value2), true);
                    }
                };
            }
            return this.objectEscaper;
        }

        private CsvValueEscaper<CharSequence> charSequenceEscaper() {
            if (this.charSequenceEscaper == null) {
                this.charSequenceEscaper = new CsvValueEscaper<CharSequence>(){

                    @Override
                    public CharSequence escape(CharSequence value2) {
                        return StringUtil.escapeCsv(value2, true);
                    }
                };
            }
            return this.charSequenceEscaper;
        }

        CombinedHttpHeadersImpl(HashingStrategy<CharSequence> nameHashingStrategy, ValueConverter<CharSequence> valueConverter, DefaultHeaders.NameValidator<CharSequence> nameValidator) {
            super(nameHashingStrategy, valueConverter, nameValidator);
        }

        @Override
        public Iterator<CharSequence> valueIterator(CharSequence name2) {
            Iterator<CharSequence> itr = super.valueIterator(name2);
            if (!itr.hasNext() || CombinedHttpHeadersImpl.cannotBeCombined(name2)) {
                return itr;
            }
            Iterator<CharSequence> unescapedItr = StringUtil.unescapeCsvFields(itr.next()).iterator();
            if (itr.hasNext()) {
                throw new IllegalStateException("CombinedHttpHeaders should only have one value");
            }
            return unescapedItr;
        }

        @Override
        public List<CharSequence> getAll(CharSequence name2) {
            List<CharSequence> values = super.getAll(name2);
            if (values.isEmpty() || CombinedHttpHeadersImpl.cannotBeCombined(name2)) {
                return values;
            }
            if (values.size() != 1) {
                throw new IllegalStateException("CombinedHttpHeaders should only have one value");
            }
            return StringUtil.unescapeCsvFields(values.get(0));
        }

        @Override
        public CombinedHttpHeadersImpl add(Headers<? extends CharSequence, ? extends CharSequence, ?> headers) {
            if (headers == this) {
                throw new IllegalArgumentException("can't add to itself.");
            }
            if (headers instanceof CombinedHttpHeadersImpl) {
                if (this.isEmpty()) {
                    this.addImpl(headers);
                } else {
                    for (Map.Entry<CharSequence, CharSequence> entry : headers) {
                        this.addEscapedValue(entry.getKey(), entry.getValue());
                    }
                }
            } else {
                for (Map.Entry<CharSequence, CharSequence> entry : headers) {
                    this.add(entry.getKey(), entry.getValue());
                }
            }
            return this;
        }

        @Override
        public CombinedHttpHeadersImpl set(Headers<? extends CharSequence, ? extends CharSequence, ?> headers) {
            if (headers == this) {
                return this;
            }
            this.clear();
            return this.add((Headers)headers);
        }

        @Override
        public CombinedHttpHeadersImpl setAll(Headers<? extends CharSequence, ? extends CharSequence, ?> headers) {
            if (headers == this) {
                return this;
            }
            for (CharSequence charSequence : headers.names()) {
                this.remove(charSequence);
            }
            return this.add(headers);
        }

        @Override
        public CombinedHttpHeadersImpl add(CharSequence name2, CharSequence value2) {
            return this.addEscapedValue(name2, this.charSequenceEscaper().escape(value2));
        }

        @Override
        public CombinedHttpHeadersImpl add(CharSequence name2, CharSequence ... values) {
            return this.addEscapedValue(name2, CombinedHttpHeadersImpl.commaSeparate(this.charSequenceEscaper(), values));
        }

        @Override
        public CombinedHttpHeadersImpl add(CharSequence name2, Iterable<? extends CharSequence> values) {
            return this.addEscapedValue(name2, CombinedHttpHeadersImpl.commaSeparate(this.charSequenceEscaper(), values));
        }

        @Override
        public CombinedHttpHeadersImpl addObject(CharSequence name2, Object value2) {
            return this.addEscapedValue(name2, CombinedHttpHeadersImpl.commaSeparate(this.objectEscaper(), value2));
        }

        @Override
        public CombinedHttpHeadersImpl addObject(CharSequence name2, Iterable<?> values) {
            return this.addEscapedValue(name2, CombinedHttpHeadersImpl.commaSeparate(this.objectEscaper(), values));
        }

        @Override
        public CombinedHttpHeadersImpl addObject(CharSequence name2, Object ... values) {
            return this.addEscapedValue(name2, CombinedHttpHeadersImpl.commaSeparate(this.objectEscaper(), values));
        }

        @Override
        public CombinedHttpHeadersImpl set(CharSequence name2, CharSequence ... values) {
            super.set(name2, CombinedHttpHeadersImpl.commaSeparate(this.charSequenceEscaper(), values));
            return this;
        }

        @Override
        public CombinedHttpHeadersImpl set(CharSequence name2, Iterable<? extends CharSequence> values) {
            super.set(name2, CombinedHttpHeadersImpl.commaSeparate(this.charSequenceEscaper(), values));
            return this;
        }

        @Override
        public CombinedHttpHeadersImpl setObject(CharSequence name2, Object value2) {
            super.set(name2, CombinedHttpHeadersImpl.commaSeparate(this.objectEscaper(), value2));
            return this;
        }

        @Override
        public CombinedHttpHeadersImpl setObject(CharSequence name2, Object ... values) {
            super.set(name2, CombinedHttpHeadersImpl.commaSeparate(this.objectEscaper(), values));
            return this;
        }

        @Override
        public CombinedHttpHeadersImpl setObject(CharSequence name2, Iterable<?> values) {
            super.set(name2, CombinedHttpHeadersImpl.commaSeparate(this.objectEscaper(), values));
            return this;
        }

        private static boolean cannotBeCombined(CharSequence name2) {
            return HttpHeaderNames.SET_COOKIE.contentEqualsIgnoreCase(name2);
        }

        private CombinedHttpHeadersImpl addEscapedValue(CharSequence name2, CharSequence escapedValue) {
            CharSequence currentValue = (CharSequence)super.get(name2);
            if (currentValue == null || CombinedHttpHeadersImpl.cannotBeCombined(name2)) {
                super.add(name2, escapedValue);
            } else {
                super.set(name2, CombinedHttpHeadersImpl.commaSeparateEscapedValues(currentValue, escapedValue));
            }
            return this;
        }

        private static <T> CharSequence commaSeparate(CsvValueEscaper<T> escaper, T ... values) {
            StringBuilder sb = new StringBuilder(values.length * 10);
            if (values.length > 0) {
                int end2 = values.length - 1;
                for (int i2 = 0; i2 < end2; ++i2) {
                    sb.append(escaper.escape(values[i2])).append(',');
                }
                sb.append(escaper.escape(values[end2]));
            }
            return sb;
        }

        private static <T> CharSequence commaSeparate(CsvValueEscaper<T> escaper, Iterable<? extends T> values) {
            StringBuilder sb = values instanceof Collection ? new StringBuilder(((Collection)values).size() * 10) : new StringBuilder();
            Iterator<T> iterator = values.iterator();
            if (iterator.hasNext()) {
                T next2 = iterator.next();
                while (iterator.hasNext()) {
                    sb.append(escaper.escape(next2)).append(',');
                    next2 = iterator.next();
                }
                sb.append(escaper.escape(next2));
            }
            return sb;
        }

        private static CharSequence commaSeparateEscapedValues(CharSequence currentValue, CharSequence value2) {
            return new StringBuilder(currentValue.length() + 1 + value2.length()).append(currentValue).append(',').append(value2);
        }

        private static interface CsvValueEscaper<T> {
            public CharSequence escape(T var1);
        }
    }
}

