/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hbase.thirdparty.io.netty.handler.codec.http;

import org.apache.hbase.thirdparty.io.netty.buffer.ByteBuf;
import org.apache.hbase.thirdparty.io.netty.buffer.ByteBufUtil;
import org.apache.hbase.thirdparty.io.netty.util.AsciiString;
import org.apache.hbase.thirdparty.io.netty.util.CharsetUtil;

final class HttpHeadersEncoder {
    private static final int COLON_AND_SPACE_SHORT = 14880;

    private HttpHeadersEncoder() {
    }

    static void encoderHeader(CharSequence name2, CharSequence value2, ByteBuf buf) {
        int nameLen = name2.length();
        int valueLen = value2.length();
        int entryLen = nameLen + valueLen + 4;
        buf.ensureWritable(entryLen);
        int offset2 = buf.writerIndex();
        HttpHeadersEncoder.writeAscii(buf, offset2, name2);
        ByteBufUtil.setShortBE(buf, offset2 += nameLen, 14880);
        HttpHeadersEncoder.writeAscii(buf, offset2 += 2, value2);
        ByteBufUtil.setShortBE(buf, offset2 += valueLen, 3338);
        buf.writerIndex(offset2 += 2);
    }

    private static void writeAscii(ByteBuf buf, int offset2, CharSequence value2) {
        if (value2 instanceof AsciiString) {
            ByteBufUtil.copy((AsciiString)value2, 0, buf, offset2, value2.length());
        } else {
            buf.setCharSequence(offset2, value2, CharsetUtil.US_ASCII);
        }
    }
}

