/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hbase.thirdparty.io.netty.handler.codec.http2;

import org.apache.hbase.thirdparty.io.netty.handler.codec.CharSequenceValueConverter;
import org.apache.hbase.thirdparty.io.netty.handler.codec.DefaultHeaders;
import org.apache.hbase.thirdparty.io.netty.handler.codec.http2.Http2Error;
import org.apache.hbase.thirdparty.io.netty.handler.codec.http2.Http2Exception;
import org.apache.hbase.thirdparty.io.netty.handler.codec.http2.Http2Headers;
import org.apache.hbase.thirdparty.io.netty.util.AsciiString;
import org.apache.hbase.thirdparty.io.netty.util.ByteProcessor;
import org.apache.hbase.thirdparty.io.netty.util.internal.PlatformDependent;

public class DefaultHttp2Headers
extends DefaultHeaders<CharSequence, CharSequence, Http2Headers>
implements Http2Headers {
    private static final ByteProcessor HTTP2_NAME_VALIDATOR_PROCESSOR = new ByteProcessor(){

        @Override
        public boolean process(byte value2) {
            return !AsciiString.isUpperCase(value2);
        }
    };
    static final DefaultHeaders.NameValidator<CharSequence> HTTP2_NAME_VALIDATOR = new DefaultHeaders.NameValidator<CharSequence>(){

        @Override
        public void validateName(CharSequence name2) {
            if (name2 == null || name2.length() == 0) {
                PlatformDependent.throwException(Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "empty headers are not allowed [%s]", name2));
            }
            if (name2 instanceof AsciiString) {
                int index2;
                try {
                    index2 = ((AsciiString)name2).forEachByte(HTTP2_NAME_VALIDATOR_PROCESSOR);
                }
                catch (Http2Exception e) {
                    PlatformDependent.throwException(e);
                    return;
                }
                catch (Throwable t) {
                    PlatformDependent.throwException(Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, t, "unexpected error. invalid header name [%s]", name2));
                    return;
                }
                if (index2 != -1) {
                    PlatformDependent.throwException(Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "invalid header name [%s]", name2));
                }
            } else {
                for (int i2 = 0; i2 < name2.length(); ++i2) {
                    if (!AsciiString.isUpperCase(name2.charAt(i2))) continue;
                    PlatformDependent.throwException(Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "invalid header name [%s]", name2));
                }
            }
        }
    };
    private DefaultHeaders.HeaderEntry<CharSequence, CharSequence> firstNonPseudo;

    public DefaultHttp2Headers() {
        this(true);
    }

    public DefaultHttp2Headers(boolean validate) {
        super(AsciiString.CASE_SENSITIVE_HASHER, CharSequenceValueConverter.INSTANCE, validate ? HTTP2_NAME_VALIDATOR : DefaultHeaders.NameValidator.NOT_NULL);
        this.firstNonPseudo = this.head;
    }

    public DefaultHttp2Headers(boolean validate, int arraySizeHint) {
        super(AsciiString.CASE_SENSITIVE_HASHER, CharSequenceValueConverter.INSTANCE, validate ? HTTP2_NAME_VALIDATOR : DefaultHeaders.NameValidator.NOT_NULL, arraySizeHint);
        this.firstNonPseudo = this.head;
    }

    @Override
    public Http2Headers clear() {
        this.firstNonPseudo = this.head;
        return (Http2Headers)super.clear();
    }

    @Override
    public boolean equals(Object o) {
        return o instanceof Http2Headers && this.equals((Http2Headers)o, AsciiString.CASE_SENSITIVE_HASHER);
    }

    @Override
    public int hashCode() {
        return this.hashCode(AsciiString.CASE_SENSITIVE_HASHER);
    }

    @Override
    public Http2Headers method(CharSequence value2) {
        this.set(Http2Headers.PseudoHeaderName.METHOD.value(), value2);
        return this;
    }

    @Override
    public Http2Headers scheme(CharSequence value2) {
        this.set(Http2Headers.PseudoHeaderName.SCHEME.value(), value2);
        return this;
    }

    @Override
    public Http2Headers authority(CharSequence value2) {
        this.set(Http2Headers.PseudoHeaderName.AUTHORITY.value(), value2);
        return this;
    }

    @Override
    public Http2Headers path(CharSequence value2) {
        this.set(Http2Headers.PseudoHeaderName.PATH.value(), value2);
        return this;
    }

    @Override
    public Http2Headers status(CharSequence value2) {
        this.set(Http2Headers.PseudoHeaderName.STATUS.value(), value2);
        return this;
    }

    @Override
    public CharSequence method() {
        return (CharSequence)this.get(Http2Headers.PseudoHeaderName.METHOD.value());
    }

    @Override
    public CharSequence scheme() {
        return (CharSequence)this.get(Http2Headers.PseudoHeaderName.SCHEME.value());
    }

    @Override
    public CharSequence authority() {
        return (CharSequence)this.get(Http2Headers.PseudoHeaderName.AUTHORITY.value());
    }

    @Override
    public CharSequence path() {
        return (CharSequence)this.get(Http2Headers.PseudoHeaderName.PATH.value());
    }

    @Override
    public CharSequence status() {
        return (CharSequence)this.get(Http2Headers.PseudoHeaderName.STATUS.value());
    }

    @Override
    public boolean contains(CharSequence name2, CharSequence value2) {
        return this.contains(name2, value2, false);
    }

    @Override
    public boolean contains(CharSequence name2, CharSequence value2, boolean caseInsensitive) {
        return this.contains(name2, value2, caseInsensitive ? AsciiString.CASE_INSENSITIVE_HASHER : AsciiString.CASE_SENSITIVE_HASHER);
    }

    @Override
    protected final DefaultHeaders.HeaderEntry<CharSequence, CharSequence> newHeaderEntry(int h, CharSequence name2, CharSequence value2, DefaultHeaders.HeaderEntry<CharSequence, CharSequence> next2) {
        return new Http2HeaderEntry(h, name2, value2, next2);
    }

    private final class Http2HeaderEntry
    extends DefaultHeaders.HeaderEntry<CharSequence, CharSequence> {
        protected Http2HeaderEntry(int hash2, CharSequence key2, CharSequence value2, DefaultHeaders.HeaderEntry<CharSequence, CharSequence> next2) {
            super(hash2, key2);
            this.value = value2;
            this.next = next2;
            if (Http2Headers.PseudoHeaderName.hasPseudoHeaderFormat(key2)) {
                this.after = DefaultHttp2Headers.this.firstNonPseudo;
                this.before = DefaultHttp2Headers.this.firstNonPseudo.before();
            } else {
                this.after = DefaultHttp2Headers.this.head;
                this.before = DefaultHttp2Headers.this.head.before();
                if (DefaultHttp2Headers.this.firstNonPseudo == DefaultHttp2Headers.this.head) {
                    DefaultHttp2Headers.this.firstNonPseudo = this;
                }
            }
            this.pointNeighborsToThis();
        }

        @Override
        protected void remove() {
            if (this == DefaultHttp2Headers.this.firstNonPseudo) {
                DefaultHttp2Headers.this.firstNonPseudo = DefaultHttp2Headers.this.firstNonPseudo.after();
            }
            super.remove();
        }
    }
}

