/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hbase.thirdparty.io.netty.handler.codec.spdy;

import java.util.Set;
import org.apache.hbase.thirdparty.io.netty.buffer.ByteBuf;
import org.apache.hbase.thirdparty.io.netty.buffer.ByteBufAllocator;
import org.apache.hbase.thirdparty.io.netty.buffer.ByteBufUtil;
import org.apache.hbase.thirdparty.io.netty.buffer.Unpooled;
import org.apache.hbase.thirdparty.io.netty.handler.codec.spdy.SpdyHeaderBlockEncoder;
import org.apache.hbase.thirdparty.io.netty.handler.codec.spdy.SpdyHeadersFrame;
import org.apache.hbase.thirdparty.io.netty.handler.codec.spdy.SpdyVersion;
import org.apache.hbase.thirdparty.io.netty.util.internal.ObjectUtil;

public class SpdyHeaderBlockRawEncoder
extends SpdyHeaderBlockEncoder {
    private final int version;

    public SpdyHeaderBlockRawEncoder(SpdyVersion version) {
        this.version = ObjectUtil.checkNotNull(version, "version").getVersion();
    }

    private static void setLengthField(ByteBuf buffer, int writerIndex, int length2) {
        buffer.setInt(writerIndex, length2);
    }

    private static void writeLengthField(ByteBuf buffer, int length2) {
        buffer.writeInt(length2);
    }

    @Override
    public ByteBuf encode(ByteBufAllocator alloc2, SpdyHeadersFrame frame) throws Exception {
        Set names2 = frame.headers().names();
        int numHeaders = names2.size();
        if (numHeaders == 0) {
            return Unpooled.EMPTY_BUFFER;
        }
        if (numHeaders > 65535) {
            throw new IllegalArgumentException("header block contains too many headers");
        }
        ByteBuf headerBlock = alloc2.heapBuffer();
        SpdyHeaderBlockRawEncoder.writeLengthField(headerBlock, numHeaders);
        for (CharSequence name2 : names2) {
            SpdyHeaderBlockRawEncoder.writeLengthField(headerBlock, name2.length());
            ByteBufUtil.writeAscii(headerBlock, name2);
            int savedIndex = headerBlock.writerIndex();
            int valueLength = 0;
            SpdyHeaderBlockRawEncoder.writeLengthField(headerBlock, valueLength);
            for (CharSequence value2 : frame.headers().getAll(name2)) {
                int length2 = value2.length();
                if (length2 <= 0) continue;
                ByteBufUtil.writeAscii(headerBlock, value2);
                headerBlock.writeByte(0);
                valueLength += length2 + 1;
            }
            if (valueLength != 0) {
                --valueLength;
            }
            if (valueLength > 65535) {
                throw new IllegalArgumentException("header exceeds allowable length: " + name2);
            }
            if (valueLength <= 0) continue;
            SpdyHeaderBlockRawEncoder.setLengthField(headerBlock, savedIndex, valueLength);
            headerBlock.writerIndex(headerBlock.writerIndex() - 1);
        }
        return headerBlock;
    }

    @Override
    void end() {
    }
}

