/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hbase.thirdparty.io.netty.handler.ssl;

import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SocketChannel;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLSession;
import org.apache.hbase.thirdparty.io.netty.buffer.ByteBuf;
import org.apache.hbase.thirdparty.io.netty.buffer.ByteBufAllocator;
import org.apache.hbase.thirdparty.io.netty.buffer.ByteBufUtil;
import org.apache.hbase.thirdparty.io.netty.buffer.CompositeByteBuf;
import org.apache.hbase.thirdparty.io.netty.buffer.Unpooled;
import org.apache.hbase.thirdparty.io.netty.channel.AbstractCoalescingBufferQueue;
import org.apache.hbase.thirdparty.io.netty.channel.Channel;
import org.apache.hbase.thirdparty.io.netty.channel.ChannelException;
import org.apache.hbase.thirdparty.io.netty.channel.ChannelFuture;
import org.apache.hbase.thirdparty.io.netty.channel.ChannelFutureListener;
import org.apache.hbase.thirdparty.io.netty.channel.ChannelHandlerContext;
import org.apache.hbase.thirdparty.io.netty.channel.ChannelOption;
import org.apache.hbase.thirdparty.io.netty.channel.ChannelOutboundBuffer;
import org.apache.hbase.thirdparty.io.netty.channel.ChannelOutboundHandler;
import org.apache.hbase.thirdparty.io.netty.channel.ChannelPromise;
import org.apache.hbase.thirdparty.io.netty.channel.ChannelPromiseNotifier;
import org.apache.hbase.thirdparty.io.netty.handler.codec.ByteToMessageDecoder;
import org.apache.hbase.thirdparty.io.netty.handler.codec.DecoderException;
import org.apache.hbase.thirdparty.io.netty.handler.codec.UnsupportedMessageTypeException;
import org.apache.hbase.thirdparty.io.netty.handler.ssl.ApplicationProtocolAccessor;
import org.apache.hbase.thirdparty.io.netty.handler.ssl.ConscryptAlpnSslEngine;
import org.apache.hbase.thirdparty.io.netty.handler.ssl.NotSslRecordException;
import org.apache.hbase.thirdparty.io.netty.handler.ssl.ReferenceCountedOpenSslEngine;
import org.apache.hbase.thirdparty.io.netty.handler.ssl.SslCloseCompletionEvent;
import org.apache.hbase.thirdparty.io.netty.handler.ssl.SslClosedEngineException;
import org.apache.hbase.thirdparty.io.netty.handler.ssl.SslHandshakeCompletionEvent;
import org.apache.hbase.thirdparty.io.netty.handler.ssl.SslHandshakeTimeoutException;
import org.apache.hbase.thirdparty.io.netty.handler.ssl.SslUtils;
import org.apache.hbase.thirdparty.io.netty.util.ReferenceCountUtil;
import org.apache.hbase.thirdparty.io.netty.util.ReferenceCounted;
import org.apache.hbase.thirdparty.io.netty.util.concurrent.DefaultPromise;
import org.apache.hbase.thirdparty.io.netty.util.concurrent.EventExecutor;
import org.apache.hbase.thirdparty.io.netty.util.concurrent.Future;
import org.apache.hbase.thirdparty.io.netty.util.concurrent.FutureListener;
import org.apache.hbase.thirdparty.io.netty.util.concurrent.GenericFutureListener;
import org.apache.hbase.thirdparty.io.netty.util.concurrent.ImmediateExecutor;
import org.apache.hbase.thirdparty.io.netty.util.concurrent.Promise;
import org.apache.hbase.thirdparty.io.netty.util.concurrent.PromiseNotifier;
import org.apache.hbase.thirdparty.io.netty.util.concurrent.ScheduledFuture;
import org.apache.hbase.thirdparty.io.netty.util.internal.ObjectUtil;
import org.apache.hbase.thirdparty.io.netty.util.internal.PlatformDependent;
import org.apache.hbase.thirdparty.io.netty.util.internal.logging.InternalLogger;
import org.apache.hbase.thirdparty.io.netty.util.internal.logging.InternalLoggerFactory;

public class SslHandler
extends ByteToMessageDecoder
implements ChannelOutboundHandler {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(SslHandler.class);
    private static final Pattern IGNORABLE_CLASS_IN_STACK = Pattern.compile("^.*(?:Socket|Datagram|Sctp|Udt)Channel.*$");
    private static final Pattern IGNORABLE_ERROR_MESSAGE = Pattern.compile("^.*(?:connection.*(?:reset|closed|abort|broken)|broken.*pipe).*$", 2);
    private static final int STATE_SENT_FIRST_MESSAGE = 1;
    private static final int STATE_FLUSHED_BEFORE_HANDSHAKE = 2;
    private static final int STATE_READ_DURING_HANDSHAKE = 4;
    private static final int STATE_HANDSHAKE_STARTED = 8;
    private static final int STATE_NEEDS_FLUSH = 16;
    private static final int STATE_OUTBOUND_CLOSED = 32;
    private static final int STATE_CLOSE_NOTIFY = 64;
    private static final int STATE_PROCESS_TASK = 128;
    private static final int STATE_FIRE_CHANNEL_READ = 256;
    private static final int STATE_UNWRAP_REENTRY = 512;
    private static final int MAX_PLAINTEXT_LENGTH = 16384;
    private volatile ChannelHandlerContext ctx;
    private final SSLEngine engine;
    private final SslEngineType engineType;
    private final Executor delegatedTaskExecutor;
    private final boolean jdkCompatibilityMode;
    private final ByteBuffer[] singleBuffer = new ByteBuffer[1];
    private final boolean startTls;
    private SslHandlerCoalescingBufferQueue pendingUnencryptedWrites;
    private Promise<Channel> handshakePromise = new LazyChannelPromise();
    private final LazyChannelPromise sslClosePromise = new LazyChannelPromise();
    private int packetLength;
    private short state;
    private volatile long handshakeTimeoutMillis = 10000L;
    private volatile long closeNotifyFlushTimeoutMillis = 3000L;
    private volatile long closeNotifyReadTimeoutMillis;
    volatile int wrapDataSize = 16384;

    public SslHandler(SSLEngine engine) {
        this(engine, false);
    }

    public SslHandler(SSLEngine engine, boolean startTls) {
        this(engine, startTls, ImmediateExecutor.INSTANCE);
    }

    public SslHandler(SSLEngine engine, Executor delegatedTaskExecutor) {
        this(engine, false, delegatedTaskExecutor);
    }

    public SslHandler(SSLEngine engine, boolean startTls, Executor delegatedTaskExecutor) {
        this.engine = ObjectUtil.checkNotNull(engine, "engine");
        this.delegatedTaskExecutor = ObjectUtil.checkNotNull(delegatedTaskExecutor, "delegatedTaskExecutor");
        this.engineType = SslEngineType.forEngine(engine);
        this.startTls = startTls;
        this.jdkCompatibilityMode = this.engineType.jdkCompatibilityMode(engine);
        this.setCumulator(this.engineType.cumulator);
    }

    public long getHandshakeTimeoutMillis() {
        return this.handshakeTimeoutMillis;
    }

    public void setHandshakeTimeout(long handshakeTimeout, TimeUnit unit) {
        ObjectUtil.checkNotNull(unit, "unit");
        this.setHandshakeTimeoutMillis(unit.toMillis(handshakeTimeout));
    }

    public void setHandshakeTimeoutMillis(long handshakeTimeoutMillis) {
        this.handshakeTimeoutMillis = ObjectUtil.checkPositiveOrZero(handshakeTimeoutMillis, "handshakeTimeoutMillis");
    }

    public final void setWrapDataSize(int wrapDataSize) {
        this.wrapDataSize = wrapDataSize;
    }

    @Deprecated
    public long getCloseNotifyTimeoutMillis() {
        return this.getCloseNotifyFlushTimeoutMillis();
    }

    @Deprecated
    public void setCloseNotifyTimeout(long closeNotifyTimeout, TimeUnit unit) {
        this.setCloseNotifyFlushTimeout(closeNotifyTimeout, unit);
    }

    @Deprecated
    public void setCloseNotifyTimeoutMillis(long closeNotifyFlushTimeoutMillis) {
        this.setCloseNotifyFlushTimeoutMillis(closeNotifyFlushTimeoutMillis);
    }

    public final long getCloseNotifyFlushTimeoutMillis() {
        return this.closeNotifyFlushTimeoutMillis;
    }

    public final void setCloseNotifyFlushTimeout(long closeNotifyFlushTimeout, TimeUnit unit) {
        this.setCloseNotifyFlushTimeoutMillis(unit.toMillis(closeNotifyFlushTimeout));
    }

    public final void setCloseNotifyFlushTimeoutMillis(long closeNotifyFlushTimeoutMillis) {
        this.closeNotifyFlushTimeoutMillis = ObjectUtil.checkPositiveOrZero(closeNotifyFlushTimeoutMillis, "closeNotifyFlushTimeoutMillis");
    }

    public final long getCloseNotifyReadTimeoutMillis() {
        return this.closeNotifyReadTimeoutMillis;
    }

    public final void setCloseNotifyReadTimeout(long closeNotifyReadTimeout, TimeUnit unit) {
        this.setCloseNotifyReadTimeoutMillis(unit.toMillis(closeNotifyReadTimeout));
    }

    public final void setCloseNotifyReadTimeoutMillis(long closeNotifyReadTimeoutMillis) {
        this.closeNotifyReadTimeoutMillis = ObjectUtil.checkPositiveOrZero(closeNotifyReadTimeoutMillis, "closeNotifyReadTimeoutMillis");
    }

    public SSLEngine engine() {
        return this.engine;
    }

    public String applicationProtocol() {
        SSLEngine engine = this.engine();
        if (!(engine instanceof ApplicationProtocolAccessor)) {
            return null;
        }
        return ((ApplicationProtocolAccessor)((Object)engine)).getNegotiatedApplicationProtocol();
    }

    public Future<Channel> handshakeFuture() {
        return this.handshakePromise;
    }

    @Deprecated
    public ChannelFuture close() {
        return this.closeOutbound();
    }

    @Deprecated
    public ChannelFuture close(ChannelPromise promise) {
        return this.closeOutbound(promise);
    }

    public ChannelFuture closeOutbound() {
        return this.closeOutbound(this.ctx.newPromise());
    }

    public ChannelFuture closeOutbound(final ChannelPromise promise) {
        ChannelHandlerContext ctx = this.ctx;
        if (ctx.executor().inEventLoop()) {
            this.closeOutbound0(promise);
        } else {
            ctx.executor().execute(new Runnable(){

                @Override
                public void run() {
                    SslHandler.this.closeOutbound0(promise);
                }
            });
        }
        return promise;
    }

    private void closeOutbound0(ChannelPromise promise) {
        block2: {
            this.setState(32);
            this.engine.closeOutbound();
            try {
                this.flush(this.ctx, promise);
            }
            catch (Exception e) {
                if (promise.tryFailure(e)) break block2;
                logger.warn("{} flush() raised a masked exception.", (Object)this.ctx.channel(), (Object)e);
            }
        }
    }

    public Future<Channel> sslCloseFuture() {
        return this.sslClosePromise;
    }

    @Override
    public void handlerRemoved0(ChannelHandlerContext ctx) throws Exception {
        if (!this.pendingUnencryptedWrites.isEmpty()) {
            this.pendingUnencryptedWrites.releaseAndFailAll(ctx, new ChannelException("Pending write on removal of SslHandler"));
        }
        this.pendingUnencryptedWrites = null;
        SSLHandshakeException cause2 = null;
        if (!this.handshakePromise.isDone() && this.handshakePromise.tryFailure(cause2 = new SSLHandshakeException("SslHandler removed before handshake completed"))) {
            ctx.fireUserEventTriggered(new SslHandshakeCompletionEvent(cause2));
        }
        if (!this.sslClosePromise.isDone()) {
            if (cause2 == null) {
                cause2 = new SSLHandshakeException("SslHandler removed before handshake completed");
            }
            this.notifyClosePromise(cause2);
        }
        if (this.engine instanceof ReferenceCounted) {
            ((ReferenceCounted)((Object)this.engine)).release();
        }
    }

    @Override
    public void bind(ChannelHandlerContext ctx, SocketAddress localAddress, ChannelPromise promise) throws Exception {
        ctx.bind(localAddress, promise);
    }

    @Override
    public void connect(ChannelHandlerContext ctx, SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) throws Exception {
        ctx.connect(remoteAddress, localAddress, promise);
    }

    @Override
    public void deregister(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
        ctx.deregister(promise);
    }

    @Override
    public void disconnect(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
        this.closeOutboundAndChannel(ctx, promise, true);
    }

    @Override
    public void close(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
        this.closeOutboundAndChannel(ctx, promise, false);
    }

    @Override
    public void read(ChannelHandlerContext ctx) throws Exception {
        if (!this.handshakePromise.isDone()) {
            this.setState(4);
        }
        ctx.read();
    }

    private static IllegalStateException newPendingWritesNullException() {
        return new IllegalStateException("pendingUnencryptedWrites is null, handlerRemoved0 called?");
    }

    @Override
    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        if (!(msg instanceof ByteBuf)) {
            UnsupportedMessageTypeException exception2 = new UnsupportedMessageTypeException(msg, ByteBuf.class);
            ReferenceCountUtil.safeRelease(msg);
            promise.setFailure(exception2);
        } else if (this.pendingUnencryptedWrites == null) {
            ReferenceCountUtil.safeRelease(msg);
            promise.setFailure(SslHandler.newPendingWritesNullException());
        } else {
            this.pendingUnencryptedWrites.add((ByteBuf)msg, promise);
        }
    }

    @Override
    public void flush(ChannelHandlerContext ctx) throws Exception {
        if (this.startTls && !this.isStateSet(1)) {
            this.setState(1);
            this.pendingUnencryptedWrites.writeAndRemoveAll(ctx);
            this.forceFlush(ctx);
            this.startHandshakeProcessing(true);
            return;
        }
        if (this.isStateSet(128)) {
            return;
        }
        try {
            this.wrapAndFlush(ctx);
        }
        catch (Throwable cause2) {
            this.setHandshakeFailure(ctx, cause2);
            PlatformDependent.throwException(cause2);
        }
    }

    private void wrapAndFlush(ChannelHandlerContext ctx) throws SSLException {
        if (this.pendingUnencryptedWrites.isEmpty()) {
            this.pendingUnencryptedWrites.add(Unpooled.EMPTY_BUFFER, ctx.newPromise());
        }
        if (!this.handshakePromise.isDone()) {
            this.setState(2);
        }
        try {
            this.wrap(ctx, false);
        }
        finally {
            this.forceFlush(ctx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void wrap(ChannelHandlerContext ctx, boolean inUnwrap) throws SSLException {
        block25: {
            ReferenceCounted out = null;
            ByteBufAllocator alloc2 = ctx.alloc();
            try {
                int wrapDataSize = this.wrapDataSize;
                block11: while (!ctx.isRemoved()) {
                    ByteBuf buf;
                    ChannelPromise promise = ctx.newPromise();
                    ByteBuf byteBuf = buf = wrapDataSize > 0 ? this.pendingUnencryptedWrites.remove(alloc2, wrapDataSize, promise) : this.pendingUnencryptedWrites.removeFirst(promise);
                    if (buf == null) {
                        break;
                    }
                    if (out == null) {
                        out = this.allocateOutNetBuf(ctx, buf.readableBytes(), buf.nioBufferCount());
                    }
                    SSLEngineResult result2 = this.wrap(alloc2, this.engine, buf, (ByteBuf)out);
                    if (buf.isReadable()) {
                        this.pendingUnencryptedWrites.addFirst(buf, promise);
                        promise = null;
                    } else {
                        buf.release();
                    }
                    if (((ByteBuf)out).isReadable()) {
                        ReferenceCounted b = out;
                        out = null;
                        if (promise != null) {
                            ctx.write(b, promise);
                        } else {
                            ctx.write(b);
                        }
                    } else if (promise != null) {
                        ctx.write(Unpooled.EMPTY_BUFFER, promise);
                    }
                    if (result2.getStatus() == SSLEngineResult.Status.CLOSED) {
                        Throwable exception2 = this.handshakePromise.cause();
                        if (exception2 == null && (exception2 = this.sslClosePromise.cause()) == null) {
                            exception2 = new SslClosedEngineException("SSLEngine closed already");
                        }
                        this.pendingUnencryptedWrites.releaseAndFailAll(ctx, exception2);
                        return;
                    }
                    switch (result2.getHandshakeStatus()) {
                        case NEED_TASK: {
                            if (this.runDelegatedTasks(inUnwrap)) continue block11;
                            break block25;
                        }
                        case FINISHED: 
                        case NOT_HANDSHAKING: {
                            this.setHandshakeSuccess();
                            break;
                        }
                        case NEED_WRAP: {
                            if (result2.bytesProduced() <= 0 || !this.pendingUnencryptedWrites.isEmpty()) continue block11;
                            this.pendingUnencryptedWrites.add(Unpooled.EMPTY_BUFFER);
                            break;
                        }
                        case NEED_UNWRAP: {
                            this.readIfNeeded(ctx);
                            return;
                        }
                        default: {
                            throw new IllegalStateException("Unknown handshake status: " + (Object)((Object)result2.getHandshakeStatus()));
                        }
                    }
                }
            }
            finally {
                if (out != null) {
                    out.release();
                }
                if (inUnwrap) {
                    this.setState(16);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean wrapNonAppData(final ChannelHandlerContext ctx, boolean inUnwrap) throws SSLException {
        block23: {
            ReferenceCounted out = null;
            ByteBufAllocator alloc2 = ctx.alloc();
            try {
                while (!ctx.isRemoved()) {
                    SSLEngineResult result2;
                    if (out == null) {
                        out = this.allocateOutNetBuf(ctx, 2048, 1);
                    }
                    if ((result2 = this.wrap(alloc2, this.engine, Unpooled.EMPTY_BUFFER, (ByteBuf)out)).bytesProduced() > 0) {
                        ctx.write(out).addListener(new ChannelFutureListener(){

                            @Override
                            public void operationComplete(ChannelFuture future) {
                                Throwable cause2 = future.cause();
                                if (cause2 != null) {
                                    SslHandler.this.setHandshakeFailureTransportFailure(ctx, cause2);
                                }
                            }
                        });
                        if (inUnwrap) {
                            this.setState(16);
                        }
                        out = null;
                    }
                    SSLEngineResult.HandshakeStatus status2 = result2.getHandshakeStatus();
                    switch (status2) {
                        case FINISHED: {
                            if (this.setHandshakeSuccess() && inUnwrap && !this.pendingUnencryptedWrites.isEmpty()) {
                                this.wrap(ctx, true);
                            }
                            boolean bl = false;
                            return bl;
                        }
                        case NEED_TASK: {
                            if (this.runDelegatedTasks(inUnwrap)) break;
                            break block23;
                        }
                        case NEED_UNWRAP: {
                            if (!inUnwrap && this.unwrapNonAppData(ctx) > 0) break;
                            boolean bl = false;
                            return bl;
                        }
                        case NEED_WRAP: {
                            break;
                        }
                        case NOT_HANDSHAKING: {
                            if (this.setHandshakeSuccess() && inUnwrap && !this.pendingUnencryptedWrites.isEmpty()) {
                                this.wrap(ctx, true);
                            }
                            if (!inUnwrap) {
                                this.unwrapNonAppData(ctx);
                            }
                            boolean bl = true;
                            return bl;
                        }
                        default: {
                            throw new IllegalStateException("Unknown handshake status: " + (Object)((Object)result2.getHandshakeStatus()));
                        }
                    }
                    if (result2.bytesProduced() == 0 && status2 != SSLEngineResult.HandshakeStatus.NEED_TASK) {
                    } else if (result2.bytesConsumed() != 0 || result2.getHandshakeStatus() != SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING) continue;
                    break;
                }
            }
            finally {
                if (out != null) {
                    out.release();
                }
            }
        }
        return false;
    }

    private SSLEngineResult wrap(ByteBufAllocator alloc2, SSLEngine engine, ByteBuf in, ByteBuf out) throws SSLException {
        ReferenceCounted newDirectIn = null;
        try {
            ByteBuffer[] in0;
            int readerIndex = in.readerIndex();
            int readableBytes = in.readableBytes();
            if (in.isDirect() || !this.engineType.wantsDirectBuffer) {
                if (!(in instanceof CompositeByteBuf) && in.nioBufferCount() == 1) {
                    in0 = this.singleBuffer;
                    in0[0] = in.internalNioBuffer(readerIndex, readableBytes);
                } else {
                    in0 = in.nioBuffers();
                }
            } else {
                newDirectIn = alloc2.directBuffer(readableBytes);
                ((ByteBuf)newDirectIn).writeBytes(in, readerIndex, readableBytes);
                in0 = this.singleBuffer;
                in0[0] = ((ByteBuf)newDirectIn).internalNioBuffer(((ByteBuf)newDirectIn).readerIndex(), readableBytes);
            }
            while (true) {
                ByteBuffer out0 = out.nioBuffer(out.writerIndex(), out.writableBytes());
                SSLEngineResult result2 = engine.wrap(in0, out0);
                in.skipBytes(result2.bytesConsumed());
                out.writerIndex(out.writerIndex() + result2.bytesProduced());
                if (result2.getStatus() != SSLEngineResult.Status.BUFFER_OVERFLOW) {
                    SSLEngineResult sSLEngineResult = result2;
                    return sSLEngineResult;
                }
                out.ensureWritable(engine.getSession().getPacketBufferSize());
            }
        }
        finally {
            this.singleBuffer[0] = null;
            if (newDirectIn != null) {
                newDirectIn.release();
            }
        }
    }

    @Override
    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        block2: {
            boolean handshakeFailed = this.handshakePromise.cause() != null;
            ClosedChannelException exception2 = new ClosedChannelException();
            this.setHandshakeFailure(ctx, exception2, !this.isStateSet(32), this.isStateSet(8), false);
            this.notifyClosePromise(exception2);
            try {
                super.channelInactive(ctx);
            }
            catch (DecoderException e) {
                if (handshakeFailed && e.getCause() instanceof SSLException) break block2;
                throw e;
            }
        }
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause2) throws Exception {
        if (this.ignoreException(cause2)) {
            if (logger.isDebugEnabled()) {
                logger.debug("{} Swallowing a harmless 'connection reset by peer / broken pipe' error that occurred while writing close_notify in response to the peer's close_notify", (Object)ctx.channel(), (Object)cause2);
            }
            if (ctx.channel().isActive()) {
                ctx.close();
            }
        } else {
            ctx.fireExceptionCaught(cause2);
        }
    }

    private boolean ignoreException(Throwable t) {
        if (!(t instanceof SSLException) && t instanceof IOException && this.sslClosePromise.isDone()) {
            StackTraceElement[] elements;
            String message2 = t.getMessage();
            if (message2 != null && IGNORABLE_ERROR_MESSAGE.matcher(message2).matches()) {
                return true;
            }
            for (StackTraceElement element : elements = t.getStackTrace()) {
                String classname = element.getClassName();
                String methodname = element.getMethodName();
                if (classname.startsWith("org.apache.hbase.thirdparty.io.netty.") || !"read".equals(methodname)) continue;
                if (IGNORABLE_CLASS_IN_STACK.matcher(classname).matches()) {
                    return true;
                }
                try {
                    Class<?> clazz = PlatformDependent.getClassLoader(this.getClass()).loadClass(classname);
                    if (SocketChannel.class.isAssignableFrom(clazz) || DatagramChannel.class.isAssignableFrom(clazz)) {
                        return true;
                    }
                    if (PlatformDependent.javaVersion() >= 7 && "com.sun.nio.sctp.SctpChannel".equals(clazz.getSuperclass().getName())) {
                        return true;
                    }
                }
                catch (Throwable cause2) {
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug("Unexpected exception while loading class {} classname {}", this.getClass(), classname, cause2);
                }
            }
        }
        return false;
    }

    public static boolean isEncrypted(ByteBuf buffer) {
        if (buffer.readableBytes() < 5) {
            throw new IllegalArgumentException("buffer must have at least 5 readable bytes");
        }
        return SslUtils.getEncryptedPacketLength(buffer, buffer.readerIndex()) != -2;
    }

    private void decodeJdkCompatible(ChannelHandlerContext ctx, ByteBuf in) throws NotSslRecordException {
        int packetLength = this.packetLength;
        if (packetLength > 0) {
            if (in.readableBytes() < packetLength) {
                return;
            }
        } else {
            int readableBytes = in.readableBytes();
            if (readableBytes < 5) {
                return;
            }
            packetLength = SslUtils.getEncryptedPacketLength(in, in.readerIndex());
            if (packetLength == -2) {
                NotSslRecordException e = new NotSslRecordException("not an SSL/TLS record: " + ByteBufUtil.hexDump(in));
                in.skipBytes(in.readableBytes());
                this.setHandshakeFailure(ctx, e);
                throw e;
            }
            assert (packetLength > 0);
            if (packetLength > readableBytes) {
                this.packetLength = packetLength;
                return;
            }
        }
        this.packetLength = 0;
        try {
            int bytesConsumed = this.unwrap(ctx, in, packetLength);
            assert (bytesConsumed == packetLength || this.engine.isInboundDone()) : "we feed the SSLEngine a packets worth of data: " + packetLength + " but it only consumed: " + bytesConsumed;
        }
        catch (Throwable cause2) {
            this.handleUnwrapThrowable(ctx, cause2);
        }
    }

    private void decodeNonJdkCompatible(ChannelHandlerContext ctx, ByteBuf in) {
        try {
            this.unwrap(ctx, in, in.readableBytes());
        }
        catch (Throwable cause2) {
            this.handleUnwrapThrowable(ctx, cause2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleUnwrapThrowable(ChannelHandlerContext ctx, Throwable cause2) {
        try {
            if (this.handshakePromise.tryFailure(cause2)) {
                ctx.fireUserEventTriggered(new SslHandshakeCompletionEvent(cause2));
            }
            this.wrapAndFlush(ctx);
        }
        catch (SSLException ex) {
            logger.debug("SSLException during trying to call SSLEngine.wrap(...) because of an previous SSLException, ignoring...", ex);
        }
        finally {
            this.setHandshakeFailure(ctx, cause2, true, false, true);
        }
        PlatformDependent.throwException(cause2);
    }

    @Override
    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws SSLException {
        if (this.isStateSet(128)) {
            return;
        }
        if (this.jdkCompatibilityMode) {
            this.decodeJdkCompatible(ctx, in);
        } else {
            this.decodeNonJdkCompatible(ctx, in);
        }
    }

    @Override
    public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
        this.channelReadComplete0(ctx);
    }

    private void channelReadComplete0(ChannelHandlerContext ctx) {
        this.discardSomeReadBytes();
        this.flushIfNeeded(ctx);
        this.readIfNeeded(ctx);
        this.clearState(256);
        ctx.fireChannelReadComplete();
    }

    private void readIfNeeded(ChannelHandlerContext ctx) {
        if (!(ctx.channel().config().isAutoRead() || this.isStateSet(256) && this.handshakePromise.isDone())) {
            ctx.read();
        }
    }

    private void flushIfNeeded(ChannelHandlerContext ctx) {
        if (this.isStateSet(16)) {
            this.forceFlush(ctx);
        }
    }

    private int unwrapNonAppData(ChannelHandlerContext ctx) throws SSLException {
        return this.unwrap(ctx, Unpooled.EMPTY_BUFFER, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int unwrap(ChannelHandlerContext ctx, ByteBuf packet, int length2) throws SSLException {
        int originalLength = length2;
        boolean wrapLater = false;
        boolean notifyClosure = false;
        boolean executedRead = false;
        ByteBuf decodeOut = this.allocate(ctx, length2);
        try {
            do {
                SSLEngineResult result2 = this.engineType.unwrap(this, packet, length2, decodeOut);
                SSLEngineResult.Status status2 = result2.getStatus();
                SSLEngineResult.HandshakeStatus handshakeStatus = result2.getHandshakeStatus();
                int produced = result2.bytesProduced();
                int consumed = result2.bytesConsumed();
                packet.skipBytes(consumed);
                length2 -= consumed;
                if (handshakeStatus == SSLEngineResult.HandshakeStatus.FINISHED || handshakeStatus == SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING) {
                    wrapLater |= (!decodeOut.isReadable() ? this.setHandshakeSuccess() : this.setHandshakeSuccessUnwrapMarkReentry()) || handshakeStatus == SSLEngineResult.HandshakeStatus.FINISHED;
                }
                if (decodeOut.isReadable()) {
                    this.setState(256);
                    if (this.isStateSet(512)) {
                        executedRead = true;
                        this.executeChannelRead(ctx, decodeOut);
                    } else {
                        ctx.fireChannelRead(decodeOut);
                    }
                    decodeOut = null;
                }
                if (status2 == SSLEngineResult.Status.CLOSED) {
                    notifyClosure = true;
                } else if (status2 == SSLEngineResult.Status.BUFFER_OVERFLOW) {
                    int applicationBufferSize;
                    if (decodeOut != null) {
                        decodeOut.release();
                    }
                    decodeOut = this.allocate(ctx, this.engineType.calculatePendingData(this, (applicationBufferSize = this.engine.getSession().getApplicationBufferSize()) < produced ? applicationBufferSize : applicationBufferSize - produced));
                    continue;
                }
                if (handshakeStatus == SSLEngineResult.HandshakeStatus.NEED_TASK) {
                    if (!this.runDelegatedTasks(true)) {
                        wrapLater = false;
                        break;
                    }
                } else if (handshakeStatus == SSLEngineResult.HandshakeStatus.NEED_WRAP && this.wrapNonAppData(ctx, true) && length2 == 0) break;
                if (status2 == SSLEngineResult.Status.BUFFER_UNDERFLOW || handshakeStatus != SSLEngineResult.HandshakeStatus.NEED_TASK && (consumed == 0 && produced == 0 || length2 == 0 && handshakeStatus == SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING)) {
                    if (handshakeStatus != SSLEngineResult.HandshakeStatus.NEED_UNWRAP) break;
                    this.readIfNeeded(ctx);
                    break;
                }
                if (decodeOut != null) continue;
                decodeOut = this.allocate(ctx, length2);
            } while (!ctx.isRemoved());
            if (this.isStateSet(2) && this.handshakePromise.isDone()) {
                this.clearState(2);
                wrapLater = true;
            }
            if (wrapLater) {
                this.wrap(ctx, true);
            }
        }
        finally {
            if (decodeOut != null) {
                decodeOut.release();
            }
            if (notifyClosure) {
                if (executedRead) {
                    this.executeNotifyClosePromise(ctx);
                } else {
                    this.notifyClosePromise(null);
                }
            }
        }
        return originalLength - length2;
    }

    private boolean setHandshakeSuccessUnwrapMarkReentry() {
        boolean setReentryState;
        boolean bl = setReentryState = !this.isStateSet(512);
        if (setReentryState) {
            this.setState(512);
        }
        try {
            boolean bl2 = this.setHandshakeSuccess();
            return bl2;
        }
        finally {
            if (setReentryState) {
                this.clearState(512);
            }
        }
    }

    private void executeNotifyClosePromise(ChannelHandlerContext ctx) {
        try {
            ctx.executor().execute(new Runnable(){

                @Override
                public void run() {
                    SslHandler.this.notifyClosePromise(null);
                }
            });
        }
        catch (RejectedExecutionException e) {
            this.notifyClosePromise(e);
        }
    }

    private void executeChannelRead(final ChannelHandlerContext ctx, final ByteBuf decodedOut) {
        try {
            ctx.executor().execute(new Runnable(){

                @Override
                public void run() {
                    ctx.fireChannelRead(decodedOut);
                }
            });
        }
        catch (RejectedExecutionException e) {
            decodedOut.release();
            throw e;
        }
    }

    private static ByteBuffer toByteBuffer(ByteBuf out, int index2, int len) {
        return out.nioBufferCount() == 1 ? out.internalNioBuffer(index2, len) : out.nioBuffer(index2, len);
    }

    private static boolean inEventLoop(Executor executor) {
        return executor instanceof EventExecutor && ((EventExecutor)executor).inEventLoop();
    }

    private static void runAllDelegatedTasks(SSLEngine engine) {
        Runnable task;
        while ((task = engine.getDelegatedTask()) != null) {
            task.run();
        }
        return;
    }

    private boolean runDelegatedTasks(boolean inUnwrap) {
        if (this.delegatedTaskExecutor == ImmediateExecutor.INSTANCE || SslHandler.inEventLoop(this.delegatedTaskExecutor)) {
            SslHandler.runAllDelegatedTasks(this.engine);
            return true;
        }
        this.executeDelegatedTasks(inUnwrap);
        return false;
    }

    private void executeDelegatedTasks(boolean inUnwrap) {
        this.setState(128);
        try {
            this.delegatedTaskExecutor.execute(new SslTasksRunner(inUnwrap));
        }
        catch (RejectedExecutionException e) {
            this.clearState(128);
            throw e;
        }
    }

    private boolean setHandshakeSuccess() {
        boolean notified = !this.handshakePromise.isDone() && this.handshakePromise.trySuccess(this.ctx.channel());
        if (notified) {
            if (logger.isDebugEnabled()) {
                SSLSession session = this.engine.getSession();
                logger.debug("{} HANDSHAKEN: protocol:{} cipher suite:{}", this.ctx.channel(), session.getProtocol(), session.getCipherSuite());
            }
            this.ctx.fireUserEventTriggered(SslHandshakeCompletionEvent.SUCCESS);
        }
        if (this.isStateSet(4)) {
            this.clearState(4);
            if (!this.ctx.channel().config().isAutoRead()) {
                this.ctx.read();
            }
        }
        return notified;
    }

    private void setHandshakeFailure(ChannelHandlerContext ctx, Throwable cause2) {
        this.setHandshakeFailure(ctx, cause2, true, true, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setHandshakeFailure(ChannelHandlerContext ctx, Throwable cause2, boolean closeInbound, boolean notify, boolean alwaysFlushAndClose) {
        try {
            block7: {
                this.setState(32);
                this.engine.closeOutbound();
                if (closeInbound) {
                    try {
                        this.engine.closeInbound();
                    }
                    catch (SSLException e) {
                        String msg;
                        if (!logger.isDebugEnabled() || (msg = e.getMessage()) != null && (msg.contains("possible truncation attack") || msg.contains("closing inbound before receiving peer's close_notify"))) break block7;
                        logger.debug("{} SSLEngine.closeInbound() raised an exception.", (Object)ctx.channel(), (Object)e);
                    }
                }
            }
            if (this.handshakePromise.tryFailure(cause2) || alwaysFlushAndClose) {
                SslUtils.handleHandshakeFailure(ctx, cause2, notify);
            }
        }
        finally {
            this.releaseAndFailAll(ctx, cause2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setHandshakeFailureTransportFailure(ChannelHandlerContext ctx, Throwable cause2) {
        try {
            SSLException transportFailure = new SSLException("failure when writing TLS control frames", cause2);
            this.releaseAndFailAll(ctx, transportFailure);
            if (this.handshakePromise.tryFailure(transportFailure)) {
                ctx.fireUserEventTriggered(new SslHandshakeCompletionEvent(transportFailure));
            }
        }
        finally {
            ctx.close();
        }
    }

    private void releaseAndFailAll(ChannelHandlerContext ctx, Throwable cause2) {
        if (this.pendingUnencryptedWrites != null) {
            this.pendingUnencryptedWrites.releaseAndFailAll(ctx, cause2);
        }
    }

    private void notifyClosePromise(Throwable cause2) {
        if (cause2 == null) {
            if (this.sslClosePromise.trySuccess(this.ctx.channel())) {
                this.ctx.fireUserEventTriggered(SslCloseCompletionEvent.SUCCESS);
            }
        } else if (this.sslClosePromise.tryFailure(cause2)) {
            this.ctx.fireUserEventTriggered(new SslCloseCompletionEvent(cause2));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeOutboundAndChannel(ChannelHandlerContext ctx, ChannelPromise promise, boolean disconnect) throws Exception {
        block8: {
            block7: {
                this.setState(32);
                this.engine.closeOutbound();
                if (!ctx.channel().isActive()) {
                    if (disconnect) {
                        ctx.disconnect(promise);
                    } else {
                        ctx.close(promise);
                    }
                    return;
                }
                ChannelPromise closeNotifyPromise = ctx.newPromise();
                try {
                    this.flush(ctx, closeNotifyPromise);
                    if (this.isStateSet(64)) break block7;
                    this.setState(64);
                }
                catch (Throwable throwable) {
                    if (!this.isStateSet(64)) {
                        this.setState(64);
                        this.safeClose(ctx, closeNotifyPromise, ctx.newPromise().addListener(new ChannelPromiseNotifier(false, promise)));
                    } else {
                        this.sslClosePromise.addListener(new FutureListener<Channel>(promise){
                            final /* synthetic */ ChannelPromise val$promise;
                            {
                                this.val$promise = channelPromise;
                            }

                            @Override
                            public void operationComplete(Future<Channel> future) {
                                this.val$promise.setSuccess();
                            }
                        });
                    }
                    throw throwable;
                }
                this.safeClose(ctx, closeNotifyPromise, ctx.newPromise().addListener(new ChannelPromiseNotifier(false, promise)));
                break block8;
            }
            this.sslClosePromise.addListener(new /* invalid duplicate definition of identical inner class */);
        }
    }

    private void flush(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
        if (this.pendingUnencryptedWrites != null) {
            this.pendingUnencryptedWrites.add(Unpooled.EMPTY_BUFFER, promise);
        } else {
            promise.setFailure(SslHandler.newPendingWritesNullException());
        }
        this.flush(ctx);
    }

    @Override
    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        this.ctx = ctx;
        Channel channel = ctx.channel();
        this.pendingUnencryptedWrites = new SslHandlerCoalescingBufferQueue(channel, 16);
        boolean fastOpen = Boolean.TRUE.equals(channel.config().getOption(ChannelOption.TCP_FASTOPEN_CONNECT));
        boolean active = channel.isActive();
        if (active || fastOpen) {
            ChannelOutboundBuffer outboundBuffer;
            this.startHandshakeProcessing(active);
            if (fastOpen && ((outboundBuffer = channel.unsafe().outboundBuffer()) == null || outboundBuffer.totalPendingWriteBytes() > 0L)) {
                this.setState(16);
            }
        }
    }

    private void startHandshakeProcessing(boolean flushAtEnd) {
        if (!this.isStateSet(8)) {
            this.setState(8);
            if (this.engine.getUseClientMode()) {
                this.handshake(flushAtEnd);
            }
            this.applyHandshakeTimeout();
        } else if (this.isStateSet(16)) {
            this.forceFlush(this.ctx);
        }
    }

    public Future<Channel> renegotiate() {
        ChannelHandlerContext ctx = this.ctx;
        if (ctx == null) {
            throw new IllegalStateException();
        }
        return this.renegotiate(ctx.executor().newPromise());
    }

    public Future<Channel> renegotiate(final Promise<Channel> promise) {
        ObjectUtil.checkNotNull(promise, "promise");
        ChannelHandlerContext ctx = this.ctx;
        if (ctx == null) {
            throw new IllegalStateException();
        }
        EventExecutor executor = ctx.executor();
        if (!executor.inEventLoop()) {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    SslHandler.this.renegotiateOnEventLoop(promise);
                }
            });
            return promise;
        }
        this.renegotiateOnEventLoop(promise);
        return promise;
    }

    private void renegotiateOnEventLoop(Promise<Channel> newHandshakePromise) {
        Promise<Channel> oldHandshakePromise = this.handshakePromise;
        if (!oldHandshakePromise.isDone()) {
            oldHandshakePromise.addListener(new PromiseNotifier(newHandshakePromise));
        } else {
            this.handshakePromise = newHandshakePromise;
            this.handshake(true);
            this.applyHandshakeTimeout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handshake(boolean flushAtEnd) {
        if (this.engine.getHandshakeStatus() != SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING) {
            return;
        }
        if (this.handshakePromise.isDone()) {
            return;
        }
        ChannelHandlerContext ctx = this.ctx;
        try {
            this.engine.beginHandshake();
            this.wrapNonAppData(ctx, false);
        }
        catch (Throwable e) {
            this.setHandshakeFailure(ctx, e);
        }
        finally {
            if (flushAtEnd) {
                this.forceFlush(ctx);
            }
        }
    }

    private void applyHandshakeTimeout() {
        final Promise<Channel> localHandshakePromise = this.handshakePromise;
        final long handshakeTimeoutMillis = this.handshakeTimeoutMillis;
        if (handshakeTimeoutMillis <= 0L || localHandshakePromise.isDone()) {
            return;
        }
        final ScheduledFuture<?> timeoutFuture = this.ctx.executor().schedule(new Runnable(){

            @Override
            public void run() {
                if (localHandshakePromise.isDone()) {
                    return;
                }
                SslHandshakeTimeoutException exception2 = new SslHandshakeTimeoutException("handshake timed out after " + handshakeTimeoutMillis + "ms");
                try {
                    if (localHandshakePromise.tryFailure(exception2)) {
                        SslUtils.handleHandshakeFailure(SslHandler.this.ctx, exception2, true);
                    }
                }
                finally {
                    SslHandler.this.releaseAndFailAll(SslHandler.this.ctx, exception2);
                }
            }
        }, handshakeTimeoutMillis, TimeUnit.MILLISECONDS);
        localHandshakePromise.addListener((GenericFutureListener<Future<Channel>>)new FutureListener<Channel>(){

            @Override
            public void operationComplete(Future<Channel> f) throws Exception {
                timeoutFuture.cancel(false);
            }
        });
    }

    private void forceFlush(ChannelHandlerContext ctx) {
        this.clearState(16);
        ctx.flush();
    }

    @Override
    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        if (!this.startTls) {
            this.startHandshakeProcessing(true);
        }
        ctx.fireChannelActive();
    }

    private void safeClose(final ChannelHandlerContext ctx, final ChannelFuture flushFuture, final ChannelPromise promise) {
        long closeNotifyTimeout;
        if (!ctx.channel().isActive()) {
            ctx.close(promise);
            return;
        }
        final ScheduledFuture<?> timeoutFuture = !flushFuture.isDone() ? ((closeNotifyTimeout = this.closeNotifyFlushTimeoutMillis) > 0L ? ctx.executor().schedule(new Runnable(){

            @Override
            public void run() {
                if (!flushFuture.isDone()) {
                    logger.warn("{} Last write attempt timed out; force-closing the connection.", (Object)ctx.channel());
                    SslHandler.addCloseListener(ctx.close(ctx.newPromise()), promise);
                }
            }
        }, closeNotifyTimeout, TimeUnit.MILLISECONDS) : null) : null;
        flushFuture.addListener(new ChannelFutureListener(){

            @Override
            public void operationComplete(ChannelFuture f) {
                long closeNotifyReadTimeout;
                if (timeoutFuture != null) {
                    timeoutFuture.cancel(false);
                }
                if ((closeNotifyReadTimeout = SslHandler.this.closeNotifyReadTimeoutMillis) <= 0L) {
                    SslHandler.addCloseListener(ctx.close(ctx.newPromise()), promise);
                } else {
                    final ScheduledFuture<?> closeNotifyReadTimeoutFuture = !SslHandler.this.sslClosePromise.isDone() ? ctx.executor().schedule(new Runnable(){

                        @Override
                        public void run() {
                            if (!SslHandler.this.sslClosePromise.isDone()) {
                                logger.debug("{} did not receive close_notify in {}ms; force-closing the connection.", (Object)ctx.channel(), (Object)closeNotifyReadTimeout);
                                SslHandler.addCloseListener(ctx.close(ctx.newPromise()), promise);
                            }
                        }
                    }, closeNotifyReadTimeout, TimeUnit.MILLISECONDS) : null;
                    SslHandler.this.sslClosePromise.addListener(new FutureListener<Channel>(){

                        @Override
                        public void operationComplete(Future<Channel> future) throws Exception {
                            if (closeNotifyReadTimeoutFuture != null) {
                                closeNotifyReadTimeoutFuture.cancel(false);
                            }
                            SslHandler.addCloseListener(ctx.close(ctx.newPromise()), promise);
                        }
                    });
                }
            }
        });
    }

    private static void addCloseListener(ChannelFuture future, ChannelPromise promise) {
        future.addListener(new ChannelPromiseNotifier(false, promise));
    }

    private ByteBuf allocate(ChannelHandlerContext ctx, int capacity) {
        ByteBufAllocator alloc2 = ctx.alloc();
        if (this.engineType.wantsDirectBuffer) {
            return alloc2.directBuffer(capacity);
        }
        return alloc2.buffer(capacity);
    }

    private ByteBuf allocateOutNetBuf(ChannelHandlerContext ctx, int pendingBytes, int numComponents) {
        return this.engineType.allocateWrapBuffer(this, ctx.alloc(), pendingBytes, numComponents);
    }

    private boolean isStateSet(int bit) {
        return (this.state & bit) == bit;
    }

    private void setState(int bit) {
        this.state = (short)(this.state | bit);
    }

    private void clearState(int bit) {
        this.state = (short)(this.state & ~bit);
    }

    private static boolean attemptCopyToCumulation(ByteBuf cumulation, ByteBuf next2, int wrapDataSize) {
        int inReadableBytes = next2.readableBytes();
        int cumulationCapacity = cumulation.capacity();
        if (wrapDataSize - cumulation.readableBytes() >= inReadableBytes && (cumulation.isWritable(inReadableBytes) && cumulationCapacity >= wrapDataSize || cumulationCapacity < wrapDataSize && ByteBufUtil.ensureWritableSuccess(cumulation.ensureWritable(inReadableBytes, false)))) {
            cumulation.writeBytes(next2);
            next2.release();
            return true;
        }
        return false;
    }

    private final class LazyChannelPromise
    extends DefaultPromise<Channel> {
        private LazyChannelPromise() {
        }

        @Override
        protected EventExecutor executor() {
            if (SslHandler.this.ctx == null) {
                throw new IllegalStateException();
            }
            return SslHandler.this.ctx.executor();
        }

        @Override
        protected void checkDeadLock() {
            if (SslHandler.this.ctx == null) {
                return;
            }
            super.checkDeadLock();
        }
    }

    private final class SslHandlerCoalescingBufferQueue
    extends AbstractCoalescingBufferQueue {
        SslHandlerCoalescingBufferQueue(Channel channel, int initSize) {
            super(channel, initSize);
        }

        @Override
        protected ByteBuf compose(ByteBufAllocator alloc2, ByteBuf cumulation, ByteBuf next2) {
            int wrapDataSize = SslHandler.this.wrapDataSize;
            if (cumulation instanceof CompositeByteBuf) {
                CompositeByteBuf composite = (CompositeByteBuf)cumulation;
                int numComponents = composite.numComponents();
                if (numComponents == 0 || !SslHandler.attemptCopyToCumulation(composite.internalComponent(numComponents - 1), next2, wrapDataSize)) {
                    composite.addComponent(true, next2);
                }
                return composite;
            }
            return SslHandler.attemptCopyToCumulation(cumulation, next2, wrapDataSize) ? cumulation : this.copyAndCompose(alloc2, cumulation, next2);
        }

        @Override
        protected ByteBuf composeFirst(ByteBufAllocator allocator, ByteBuf first2) {
            if (first2 instanceof CompositeByteBuf) {
                CompositeByteBuf composite = (CompositeByteBuf)first2;
                first2 = ((SslHandler)SslHandler.this).engineType.wantsDirectBuffer ? allocator.directBuffer(composite.readableBytes()) : allocator.heapBuffer(composite.readableBytes());
                try {
                    first2.writeBytes(composite);
                }
                catch (Throwable cause2) {
                    first2.release();
                    PlatformDependent.throwException(cause2);
                }
                composite.release();
            }
            return first2;
        }

        @Override
        protected ByteBuf removeEmptyValue() {
            return null;
        }
    }

    private final class SslTasksRunner
    implements Runnable {
        private final boolean inUnwrap;

        SslTasksRunner(boolean inUnwrap) {
            this.inUnwrap = inUnwrap;
        }

        private void taskError(Throwable e) {
            if (this.inUnwrap) {
                try {
                    SslHandler.this.handleUnwrapThrowable(SslHandler.this.ctx, e);
                }
                catch (Throwable cause2) {
                    this.safeExceptionCaught(cause2);
                }
            } else {
                SslHandler.this.setHandshakeFailure(SslHandler.this.ctx, e);
                SslHandler.this.forceFlush(SslHandler.this.ctx);
            }
        }

        private void safeExceptionCaught(Throwable cause2) {
            try {
                SslHandler.this.exceptionCaught(SslHandler.this.ctx, this.wrapIfNeeded(cause2));
            }
            catch (Throwable error2) {
                SslHandler.this.ctx.fireExceptionCaught(error2);
            }
        }

        private Throwable wrapIfNeeded(Throwable cause2) {
            if (!this.inUnwrap) {
                return cause2;
            }
            return cause2 instanceof DecoderException ? cause2 : new DecoderException(cause2);
        }

        private void tryDecodeAgain() {
            try {
                SslHandler.this.channelRead(SslHandler.this.ctx, Unpooled.EMPTY_BUFFER);
            }
            catch (Throwable cause2) {
                this.safeExceptionCaught(cause2);
            }
            finally {
                SslHandler.this.channelReadComplete0(SslHandler.this.ctx);
            }
        }

        private void resumeOnEventExecutor() {
            assert (SslHandler.this.ctx.executor().inEventLoop());
            SslHandler.this.clearState(128);
            try {
                SSLEngineResult.HandshakeStatus status2 = SslHandler.this.engine.getHandshakeStatus();
                switch (status2) {
                    case NEED_TASK: {
                        SslHandler.this.executeDelegatedTasks(this.inUnwrap);
                        break;
                    }
                    case FINISHED: 
                    case NOT_HANDSHAKING: {
                        SslHandler.this.setHandshakeSuccess();
                        try {
                            SslHandler.this.wrap(SslHandler.this.ctx, this.inUnwrap);
                        }
                        catch (Throwable e) {
                            this.taskError(e);
                            return;
                        }
                        if (this.inUnwrap) {
                            SslHandler.this.unwrapNonAppData(SslHandler.this.ctx);
                        }
                        SslHandler.this.forceFlush(SslHandler.this.ctx);
                        this.tryDecodeAgain();
                        break;
                    }
                    case NEED_UNWRAP: {
                        try {
                            SslHandler.this.unwrapNonAppData(SslHandler.this.ctx);
                        }
                        catch (SSLException e) {
                            SslHandler.this.handleUnwrapThrowable(SslHandler.this.ctx, e);
                            return;
                        }
                        this.tryDecodeAgain();
                        break;
                    }
                    case NEED_WRAP: {
                        try {
                            if (!SslHandler.this.wrapNonAppData(SslHandler.this.ctx, false) && this.inUnwrap) {
                                SslHandler.this.unwrapNonAppData(SslHandler.this.ctx);
                            }
                            SslHandler.this.forceFlush(SslHandler.this.ctx);
                        }
                        catch (Throwable e) {
                            this.taskError(e);
                            return;
                        }
                        this.tryDecodeAgain();
                        break;
                    }
                    default: {
                        throw new AssertionError();
                    }
                }
            }
            catch (Throwable cause2) {
                this.safeExceptionCaught(cause2);
            }
        }

        @Override
        public void run() {
            try {
                SslHandler.runAllDelegatedTasks(SslHandler.this.engine);
                assert (SslHandler.this.engine.getHandshakeStatus() != SSLEngineResult.HandshakeStatus.NEED_TASK);
                SslHandler.this.ctx.executor().execute(new Runnable(){

                    @Override
                    public void run() {
                        SslTasksRunner.this.resumeOnEventExecutor();
                    }
                });
            }
            catch (Throwable cause2) {
                this.handleException(cause2);
            }
        }

        private void handleException(final Throwable cause2) {
            if (SslHandler.this.ctx.executor().inEventLoop()) {
                SslHandler.this.clearState(128);
                this.safeExceptionCaught(cause2);
            } else {
                try {
                    SslHandler.this.ctx.executor().execute(new Runnable(){

                        @Override
                        public void run() {
                            SslHandler.this.clearState(128);
                            SslTasksRunner.this.safeExceptionCaught(cause2);
                        }
                    });
                }
                catch (RejectedExecutionException ignore) {
                    SslHandler.this.clearState(128);
                    SslHandler.this.ctx.fireExceptionCaught(cause2);
                }
            }
        }
    }

    private static enum SslEngineType {
        TCNATIVE(true, ByteToMessageDecoder.COMPOSITE_CUMULATOR){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            SSLEngineResult unwrap(SslHandler handler, ByteBuf in, int len, ByteBuf out) throws SSLException {
                SSLEngineResult result2;
                int nioBufferCount = in.nioBufferCount();
                int writerIndex = out.writerIndex();
                if (nioBufferCount > 1) {
                    ReferenceCountedOpenSslEngine opensslEngine = (ReferenceCountedOpenSslEngine)handler.engine;
                    try {
                        ((SslHandler)handler).singleBuffer[0] = SslHandler.toByteBuffer(out, writerIndex, out.writableBytes());
                        result2 = opensslEngine.unwrap(in.nioBuffers(in.readerIndex(), len), handler.singleBuffer);
                    }
                    finally {
                        ((SslHandler)handler).singleBuffer[0] = null;
                    }
                } else {
                    result2 = handler.engine.unwrap(SslHandler.toByteBuffer(in, in.readerIndex(), len), SslHandler.toByteBuffer(out, writerIndex, out.writableBytes()));
                }
                out.writerIndex(writerIndex + result2.bytesProduced());
                return result2;
            }

            @Override
            ByteBuf allocateWrapBuffer(SslHandler handler, ByteBufAllocator allocator, int pendingBytes, int numComponents) {
                return allocator.directBuffer(((ReferenceCountedOpenSslEngine)handler.engine).calculateMaxLengthForWrap(pendingBytes, numComponents));
            }

            @Override
            int calculatePendingData(SslHandler handler, int guess3) {
                int sslPending = ((ReferenceCountedOpenSslEngine)handler.engine).sslPending();
                return sslPending > 0 ? sslPending : guess3;
            }

            @Override
            boolean jdkCompatibilityMode(SSLEngine engine) {
                return ((ReferenceCountedOpenSslEngine)engine).jdkCompatibilityMode;
            }
        }
        ,
        CONSCRYPT(true, ByteToMessageDecoder.COMPOSITE_CUMULATOR){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            SSLEngineResult unwrap(SslHandler handler, ByteBuf in, int len, ByteBuf out) throws SSLException {
                SSLEngineResult result2;
                int nioBufferCount = in.nioBufferCount();
                int writerIndex = out.writerIndex();
                if (nioBufferCount > 1) {
                    try {
                        ((SslHandler)handler).singleBuffer[0] = SslHandler.toByteBuffer(out, writerIndex, out.writableBytes());
                        result2 = ((ConscryptAlpnSslEngine)handler.engine).unwrap(in.nioBuffers(in.readerIndex(), len), handler.singleBuffer);
                    }
                    finally {
                        ((SslHandler)handler).singleBuffer[0] = null;
                    }
                } else {
                    result2 = handler.engine.unwrap(SslHandler.toByteBuffer(in, in.readerIndex(), len), SslHandler.toByteBuffer(out, writerIndex, out.writableBytes()));
                }
                out.writerIndex(writerIndex + result2.bytesProduced());
                return result2;
            }

            @Override
            ByteBuf allocateWrapBuffer(SslHandler handler, ByteBufAllocator allocator, int pendingBytes, int numComponents) {
                return allocator.directBuffer(((ConscryptAlpnSslEngine)handler.engine).calculateOutNetBufSize(pendingBytes, numComponents));
            }

            @Override
            int calculatePendingData(SslHandler handler, int guess3) {
                return guess3;
            }

            @Override
            boolean jdkCompatibilityMode(SSLEngine engine) {
                return true;
            }
        }
        ,
        JDK(false, ByteToMessageDecoder.MERGE_CUMULATOR){

            @Override
            SSLEngineResult unwrap(SslHandler handler, ByteBuf in, int len, ByteBuf out) throws SSLException {
                int consumed;
                int writerIndex = out.writerIndex();
                ByteBuffer inNioBuffer = SslHandler.toByteBuffer(in, in.readerIndex(), len);
                int position = inNioBuffer.position();
                SSLEngineResult result2 = handler.engine.unwrap(inNioBuffer, SslHandler.toByteBuffer(out, writerIndex, out.writableBytes()));
                out.writerIndex(writerIndex + result2.bytesProduced());
                if (result2.bytesConsumed() == 0 && (consumed = inNioBuffer.position() - position) != result2.bytesConsumed()) {
                    return new SSLEngineResult(result2.getStatus(), result2.getHandshakeStatus(), consumed, result2.bytesProduced());
                }
                return result2;
            }

            @Override
            ByteBuf allocateWrapBuffer(SslHandler handler, ByteBufAllocator allocator, int pendingBytes, int numComponents) {
                return allocator.heapBuffer(handler.engine.getSession().getPacketBufferSize());
            }

            @Override
            int calculatePendingData(SslHandler handler, int guess3) {
                return guess3;
            }

            @Override
            boolean jdkCompatibilityMode(SSLEngine engine) {
                return true;
            }
        };

        final boolean wantsDirectBuffer;
        final ByteToMessageDecoder.Cumulator cumulator;

        static SslEngineType forEngine(SSLEngine engine) {
            return engine instanceof ReferenceCountedOpenSslEngine ? TCNATIVE : (engine instanceof ConscryptAlpnSslEngine ? CONSCRYPT : JDK);
        }

        private SslEngineType(boolean wantsDirectBuffer, ByteToMessageDecoder.Cumulator cumulator) {
            this.wantsDirectBuffer = wantsDirectBuffer;
            this.cumulator = cumulator;
        }

        abstract SSLEngineResult unwrap(SslHandler var1, ByteBuf var2, int var3, ByteBuf var4) throws SSLException;

        abstract int calculatePendingData(SslHandler var1, int var2);

        abstract boolean jdkCompatibilityMode(SSLEngine var1);

        abstract ByteBuf allocateWrapBuffer(SslHandler var1, ByteBufAllocator var2, int var3, int var4);
    }
}

