/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hbase.thirdparty.io.netty.resolver;

import java.net.InetAddress;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.hbase.thirdparty.io.netty.resolver.HostsFileEntriesProvider;
import org.apache.hbase.thirdparty.io.netty.resolver.HostsFileEntriesResolver;
import org.apache.hbase.thirdparty.io.netty.resolver.ResolvedAddressTypes;
import org.apache.hbase.thirdparty.io.netty.util.CharsetUtil;
import org.apache.hbase.thirdparty.io.netty.util.internal.PlatformDependent;

public final class DefaultHostsFileEntriesResolver
implements HostsFileEntriesResolver {
    private final Map<String, List<InetAddress>> inet4Entries;
    private final Map<String, List<InetAddress>> inet6Entries;

    public DefaultHostsFileEntriesResolver() {
        this(DefaultHostsFileEntriesResolver.parseEntries());
    }

    DefaultHostsFileEntriesResolver(HostsFileEntriesProvider entries2) {
        this.inet4Entries = entries2.ipv4Entries();
        this.inet6Entries = entries2.ipv6Entries();
    }

    @Override
    public InetAddress address(String inetHost, ResolvedAddressTypes resolvedAddressTypes) {
        String normalized = this.normalize(inetHost);
        switch (resolvedAddressTypes) {
            case IPV4_ONLY: {
                return DefaultHostsFileEntriesResolver.firstAddress(this.inet4Entries.get(normalized));
            }
            case IPV6_ONLY: {
                return DefaultHostsFileEntriesResolver.firstAddress(this.inet6Entries.get(normalized));
            }
            case IPV4_PREFERRED: {
                InetAddress inet4Address = DefaultHostsFileEntriesResolver.firstAddress(this.inet4Entries.get(normalized));
                return inet4Address != null ? inet4Address : DefaultHostsFileEntriesResolver.firstAddress(this.inet6Entries.get(normalized));
            }
            case IPV6_PREFERRED: {
                InetAddress inet6Address = DefaultHostsFileEntriesResolver.firstAddress(this.inet6Entries.get(normalized));
                return inet6Address != null ? inet6Address : DefaultHostsFileEntriesResolver.firstAddress(this.inet4Entries.get(normalized));
            }
        }
        throw new IllegalArgumentException("Unknown ResolvedAddressTypes " + (Object)((Object)resolvedAddressTypes));
    }

    public List<InetAddress> addresses(String inetHost, ResolvedAddressTypes resolvedAddressTypes) {
        String normalized = this.normalize(inetHost);
        switch (resolvedAddressTypes) {
            case IPV4_ONLY: {
                return this.inet4Entries.get(normalized);
            }
            case IPV6_ONLY: {
                return this.inet6Entries.get(normalized);
            }
            case IPV4_PREFERRED: {
                List<InetAddress> allInet4Addresses = this.inet4Entries.get(normalized);
                return allInet4Addresses != null ? DefaultHostsFileEntriesResolver.allAddresses(allInet4Addresses, this.inet6Entries.get(normalized)) : this.inet6Entries.get(normalized);
            }
            case IPV6_PREFERRED: {
                List<InetAddress> allInet6Addresses = this.inet6Entries.get(normalized);
                return allInet6Addresses != null ? DefaultHostsFileEntriesResolver.allAddresses(allInet6Addresses, this.inet4Entries.get(normalized)) : this.inet4Entries.get(normalized);
            }
        }
        throw new IllegalArgumentException("Unknown ResolvedAddressTypes " + (Object)((Object)resolvedAddressTypes));
    }

    String normalize(String inetHost) {
        return inetHost.toLowerCase(Locale.ENGLISH);
    }

    private static List<InetAddress> allAddresses(List<InetAddress> a, List<InetAddress> b) {
        ArrayList<InetAddress> result2 = new ArrayList<InetAddress>(a.size() + (b == null ? 0 : b.size()));
        result2.addAll(a);
        if (b != null) {
            result2.addAll(b);
        }
        return result2;
    }

    private static InetAddress firstAddress(List<InetAddress> addresses) {
        return addresses != null && !addresses.isEmpty() ? addresses.get(0) : null;
    }

    private static HostsFileEntriesProvider parseEntries() {
        if (PlatformDependent.isWindows()) {
            return HostsFileEntriesProvider.parser().parseSilently(Charset.defaultCharset(), CharsetUtil.UTF_16, CharsetUtil.UTF_8);
        }
        return HostsFileEntriesProvider.parser().parseSilently();
    }
}

