/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hbase.thirdparty.org.apache.commons.collections4.comparators;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class ComparatorChain<E>
implements Comparator<E>,
Serializable {
    private static final long serialVersionUID = -721644942746081630L;
    private final List<Comparator<E>> comparatorChain;
    private BitSet orderingBits = null;
    private boolean isLocked = false;

    public ComparatorChain() {
        this(new ArrayList<Comparator<E>>(), new BitSet());
    }

    public ComparatorChain(Comparator<E> comparator) {
        this(comparator, false);
    }

    public ComparatorChain(Comparator<E> comparator, boolean reverse2) {
        this.comparatorChain = new ArrayList<Comparator<E>>(1);
        this.comparatorChain.add(comparator);
        this.orderingBits = new BitSet(1);
        if (reverse2) {
            this.orderingBits.set(0);
        }
    }

    public ComparatorChain(List<Comparator<E>> list2) {
        this(list2, new BitSet(list2.size()));
    }

    public ComparatorChain(List<Comparator<E>> list2, BitSet bits) {
        this.comparatorChain = list2;
        this.orderingBits = bits;
    }

    public void addComparator(Comparator<E> comparator) {
        this.addComparator(comparator, false);
    }

    public void addComparator(Comparator<E> comparator, boolean reverse2) {
        this.checkLocked();
        this.comparatorChain.add(comparator);
        if (reverse2) {
            this.orderingBits.set(this.comparatorChain.size() - 1);
        }
    }

    public void setComparator(int index2, Comparator<E> comparator) throws IndexOutOfBoundsException {
        this.setComparator(index2, comparator, false);
    }

    public void setComparator(int index2, Comparator<E> comparator, boolean reverse2) {
        this.checkLocked();
        this.comparatorChain.set(index2, comparator);
        if (reverse2) {
            this.orderingBits.set(index2);
        } else {
            this.orderingBits.clear(index2);
        }
    }

    public void setForwardSort(int index2) {
        this.checkLocked();
        this.orderingBits.clear(index2);
    }

    public void setReverseSort(int index2) {
        this.checkLocked();
        this.orderingBits.set(index2);
    }

    public int size() {
        return this.comparatorChain.size();
    }

    public boolean isLocked() {
        return this.isLocked;
    }

    private void checkLocked() {
        if (this.isLocked) {
            throw new UnsupportedOperationException("Comparator ordering cannot be changed after the first comparison is performed");
        }
    }

    private void checkChainIntegrity() {
        if (this.comparatorChain.size() == 0) {
            throw new UnsupportedOperationException("ComparatorChains must contain at least one Comparator");
        }
    }

    @Override
    public int compare(E o1, E o2) throws UnsupportedOperationException {
        if (!this.isLocked) {
            this.checkChainIntegrity();
            this.isLocked = true;
        }
        Iterator<Comparator<E>> comparators = this.comparatorChain.iterator();
        int comparatorIndex = 0;
        while (comparators.hasNext()) {
            Comparator<E> comparator = comparators.next();
            int retval = comparator.compare(o1, o2);
            if (retval != 0) {
                if (this.orderingBits.get(comparatorIndex)) {
                    retval = retval > 0 ? -1 : 1;
                }
                return retval;
            }
            ++comparatorIndex;
        }
        return 0;
    }

    public int hashCode() {
        int hash2 = 0;
        if (null != this.comparatorChain) {
            hash2 ^= this.comparatorChain.hashCode();
        }
        if (null != this.orderingBits) {
            hash2 ^= this.orderingBits.hashCode();
        }
        return hash2;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (null == object) {
            return false;
        }
        if (object.getClass().equals(this.getClass())) {
            ComparatorChain chain = (ComparatorChain)object;
            return (null == this.orderingBits ? null == chain.orderingBits : this.orderingBits.equals(chain.orderingBits)) && (null == this.comparatorChain ? null == chain.comparatorChain : this.comparatorChain.equals(chain.comparatorChain));
        }
        return false;
    }
}

