/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hbase.thirdparty.org.apache.commons.collections4.list;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.function.Predicate;
import org.apache.hbase.thirdparty.org.apache.commons.collections4.ListUtils;
import org.apache.hbase.thirdparty.org.apache.commons.collections4.iterators.AbstractIteratorDecorator;
import org.apache.hbase.thirdparty.org.apache.commons.collections4.iterators.AbstractListIteratorDecorator;
import org.apache.hbase.thirdparty.org.apache.commons.collections4.list.AbstractSerializableListDecorator;
import org.apache.hbase.thirdparty.org.apache.commons.collections4.set.UnmodifiableSet;

public class SetUniqueList<E>
extends AbstractSerializableListDecorator<E> {
    private static final long serialVersionUID = 7196982186153478694L;
    private final Set<E> set;

    public static <E> SetUniqueList<E> setUniqueList(List<E> list2) {
        if (list2 == null) {
            throw new NullPointerException("List must not be null");
        }
        if (list2.isEmpty()) {
            return new SetUniqueList<E>(list2, new HashSet());
        }
        ArrayList<E> temp = new ArrayList<E>(list2);
        list2.clear();
        SetUniqueList<E> sl = new SetUniqueList<E>(list2, new HashSet());
        sl.addAll(temp);
        return sl;
    }

    protected SetUniqueList(List<E> list2, Set<E> set) {
        super(list2);
        if (set == null) {
            throw new NullPointerException("Set must not be null");
        }
        this.set = set;
    }

    public Set<E> asSet() {
        return UnmodifiableSet.unmodifiableSet(this.set);
    }

    @Override
    public boolean add(E object) {
        int sizeBefore = this.size();
        this.add(this.size(), object);
        return sizeBefore != this.size();
    }

    @Override
    public void add(int index2, E object) {
        if (!this.set.contains(object)) {
            this.set.add(object);
            super.add(index2, object);
        }
    }

    @Override
    public boolean addAll(Collection<? extends E> coll) {
        return this.addAll(this.size(), coll);
    }

    @Override
    public boolean addAll(int index2, Collection<? extends E> coll) {
        ArrayList<E> temp = new ArrayList<E>();
        for (E e : coll) {
            if (!this.set.add(e)) continue;
            temp.add(e);
        }
        return super.addAll(index2, temp);
    }

    @Override
    public E set(int index2, E object) {
        int pos2 = this.indexOf(object);
        E removed = super.set(index2, object);
        if (pos2 != -1 && pos2 != index2) {
            super.remove(pos2);
        }
        this.set.remove(removed);
        this.set.add(object);
        return removed;
    }

    @Override
    public boolean remove(Object object) {
        boolean result2 = this.set.remove(object);
        if (result2) {
            super.remove(object);
        }
        return result2;
    }

    @Override
    public E remove(int index2) {
        Object result2 = super.remove(index2);
        this.set.remove(result2);
        return result2;
    }

    @Override
    public boolean removeIf(Predicate<? super E> filter) {
        boolean result2 = super.removeIf(filter);
        this.set.removeIf(filter);
        return result2;
    }

    @Override
    public boolean removeAll(Collection<?> coll) {
        boolean result2 = false;
        for (Object name2 : coll) {
            result2 |= this.remove(name2);
        }
        return result2;
    }

    @Override
    public boolean retainAll(Collection<?> coll) {
        boolean result2 = this.set.retainAll(coll);
        if (!result2) {
            return false;
        }
        if (this.set.size() == 0) {
            super.clear();
        } else {
            super.retainAll(this.set);
        }
        return result2;
    }

    @Override
    public void clear() {
        super.clear();
        this.set.clear();
    }

    @Override
    public boolean contains(Object object) {
        return this.set.contains(object);
    }

    @Override
    public boolean containsAll(Collection<?> coll) {
        return this.set.containsAll(coll);
    }

    @Override
    public Iterator<E> iterator() {
        return new SetListIterator(super.iterator(), this.set);
    }

    @Override
    public ListIterator<E> listIterator() {
        return new SetListListIterator(super.listIterator(), this.set);
    }

    @Override
    public ListIterator<E> listIterator(int index2) {
        return new SetListListIterator(super.listIterator(index2), this.set);
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        List superSubList = super.subList(fromIndex, toIndex);
        Set<E> subSet = this.createSetBasedOnList(this.set, superSubList);
        return ListUtils.unmodifiableList(new SetUniqueList(superSubList, subSet));
    }

    protected Set<E> createSetBasedOnList(Set<E> set, List<E> list2) {
        Set subSet;
        if (set.getClass().equals(HashSet.class)) {
            subSet = new HashSet(list2.size());
        } else {
            try {
                subSet = (Set)set.getClass().getDeclaredConstructor(set.getClass()).newInstance(set);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ie) {
                subSet = new HashSet();
            }
        }
        return subSet;
    }

    static class SetListListIterator<E>
    extends AbstractListIteratorDecorator<E> {
        private final Set<E> set;
        private E last = null;

        protected SetListListIterator(ListIterator<E> it, Set<E> set) {
            super(it);
            this.set = set;
        }

        @Override
        public E next() {
            this.last = super.next();
            return this.last;
        }

        @Override
        public E previous() {
            this.last = super.previous();
            return this.last;
        }

        @Override
        public void remove() {
            super.remove();
            this.set.remove(this.last);
            this.last = null;
        }

        @Override
        public void add(E object) {
            if (!this.set.contains(object)) {
                super.add(object);
                this.set.add(object);
            }
        }

        @Override
        public void set(E object) {
            throw new UnsupportedOperationException("ListIterator does not support set");
        }
    }

    static class SetListIterator<E>
    extends AbstractIteratorDecorator<E> {
        private final Set<E> set;
        private E last = null;

        protected SetListIterator(Iterator<E> it, Set<E> set) {
            super(it);
            this.set = set;
        }

        @Override
        public E next() {
            this.last = super.next();
            return this.last;
        }

        @Override
        public void remove() {
            super.remove();
            this.set.remove(this.last);
            this.last = null;
        }
    }
}

