/*
 * Decompiled with CFR 0.152.
 */
package org.apache.htrace.core;

import java.util.HashMap;
import java.util.Map;
import org.apache.htrace.shaded.commons.logging.Log;
import org.apache.htrace.shaded.commons.logging.LogFactory;

public abstract class HTraceConfiguration {
    private static final Log LOG = LogFactory.getLog(HTraceConfiguration.class);
    private static final Map<String, String> EMPTY_MAP = new HashMap<String, String>(1);
    public static final HTraceConfiguration EMPTY = HTraceConfiguration.fromMap(EMPTY_MAP);

    public static HTraceConfiguration fromMap(Map<String, String> conf) {
        return new MapConf(conf);
    }

    public static HTraceConfiguration fromKeyValuePairs(String ... pairs) {
        if (pairs.length % 2 != 0) {
            throw new RuntimeException("You must specify an equal number of keys and values.");
        }
        HashMap<String, String> conf = new HashMap<String, String>();
        for (int i2 = 0; i2 < pairs.length; i2 += 2) {
            conf.put(pairs[i2], pairs[i2 + 1]);
        }
        return new MapConf(conf);
    }

    public abstract String get(String var1);

    public abstract String get(String var1, String var2);

    public boolean getBoolean(String key2, boolean defaultValue) {
        String value2 = this.get(key2, String.valueOf(defaultValue)).trim().toLowerCase();
        if ("true".equals(value2)) {
            return true;
        }
        if ("false".equals(value2)) {
            return false;
        }
        LOG.warn("Expected boolean for key [" + key2 + "] instead got [" + value2 + "].");
        return defaultValue;
    }

    public int getInt(String key2, int defaultVal) {
        String val = this.get(key2);
        if (val == null || val.trim().isEmpty()) {
            return defaultVal;
        }
        try {
            return Integer.parseInt(val);
        }
        catch (NumberFormatException nfe) {
            throw new IllegalArgumentException("Bad value for '" + key2 + "': should be int");
        }
    }

    private static class MapConf
    extends HTraceConfiguration {
        private final Map<String, String> conf;

        public MapConf(Map<String, String> conf) {
            this.conf = new HashMap<String, String>(conf);
        }

        @Override
        public String get(String key2) {
            return this.conf.get(key2);
        }

        @Override
        public String get(String key2, String defaultValue) {
            String value2 = this.get(key2);
            return value2 == null ? defaultValue : value2;
        }
    }
}

