/*
 * Decompiled with CFR 0.152.
 */
package org.apache.htrace.shaded.fasterxml.jackson.databind.util;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class ContainerBuilder {
    private static final int MAX_BUF = 1000;
    private Object[] b;
    private int tail;
    private int start;
    private List<Object> list;
    private Map<String, Object> map;

    public ContainerBuilder(int bufSize) {
        this.b = new Object[bufSize & 0xFFFFFFFE];
    }

    public boolean canReuse() {
        return this.list == null && this.map == null;
    }

    public int bufferLength() {
        return this.b.length;
    }

    public int start() {
        if (this.list != null || this.map != null) {
            throw new IllegalStateException();
        }
        int prevStart = this.start;
        this.start = this.tail;
        return prevStart;
    }

    public int startList(Object value2) {
        if (this.list != null || this.map != null) {
            throw new IllegalStateException();
        }
        int prevStart = this.start;
        this.start = this.tail;
        this.add(value2);
        return prevStart;
    }

    public int startMap(String key2, Object value2) {
        if (this.list != null || this.map != null) {
            throw new IllegalStateException();
        }
        int prevStart = this.start;
        this.start = this.tail;
        this.put(key2, value2);
        return prevStart;
    }

    public void add(Object value2) {
        if (this.list != null) {
            this.list.add(value2);
        } else if (this.tail >= this.b.length) {
            this._expandList(value2);
        } else {
            this.b[this.tail++] = value2;
        }
    }

    public void put(String key2, Object value2) {
        if (this.map != null) {
            this.map.put(key2, value2);
        } else if (this.tail + 2 > this.b.length) {
            this._expandMap(key2, value2);
        } else {
            this.b[this.tail++] = key2;
            this.b[this.tail++] = value2;
        }
    }

    public List<Object> finishList(int prevStart) {
        List<Object> l = this.list;
        if (l == null) {
            l = this._buildList(true);
        } else {
            this.list = null;
        }
        this.start = prevStart;
        return l;
    }

    public Object[] finishArray(int prevStart) {
        Object[] result2;
        if (this.list == null) {
            result2 = Arrays.copyOfRange(this.b, this.start, this.tail);
        } else {
            result2 = this.list.toArray(new Object[this.tail - this.start]);
            this.list = null;
        }
        this.start = prevStart;
        return result2;
    }

    public <T> Object[] finishArray(int prevStart, Class<T> elemType) {
        int size2 = this.tail - this.start;
        Object[] result2 = (Object[])Array.newInstance(elemType, size2);
        if (this.list == null) {
            System.arraycopy(this.b, this.start, result2, 0, size2);
        } else {
            result2 = this.list.toArray(result2);
            this.list = null;
        }
        this.start = prevStart;
        return result2;
    }

    public Map<String, Object> finishMap(int prevStart) {
        Map<String, Object> m = this.map;
        if (m == null) {
            m = this._buildMap(true);
        } else {
            this.map = null;
        }
        this.start = prevStart;
        return m;
    }

    private void _expandList(Object value2) {
        if (this.b.length < 1000) {
            this.b = Arrays.copyOf(this.b, this.b.length << 1);
            this.b[this.tail++] = value2;
        } else {
            this.list = this._buildList(false);
            this.list.add(value2);
        }
    }

    private List<Object> _buildList(boolean isComplete) {
        int currLen = this.tail - this.start;
        if (isComplete) {
            if (currLen < 2) {
                currLen = 2;
            }
        } else {
            currLen = currLen < 20 ? 20 : (currLen < 1000 ? (currLen += currLen >> 1) : (currLen += currLen >> 2));
        }
        ArrayList<Object> l = new ArrayList<Object>(currLen);
        for (int i2 = this.start; i2 < this.tail; ++i2) {
            l.add(this.b[i2]);
        }
        this.tail = this.start;
        return l;
    }

    private void _expandMap(String key2, Object value2) {
        if (this.b.length < 1000) {
            this.b = Arrays.copyOf(this.b, this.b.length << 1);
            this.b[this.tail++] = key2;
            this.b[this.tail++] = value2;
        } else {
            this.map = this._buildMap(false);
            this.map.put(key2, value2);
        }
    }

    private Map<String, Object> _buildMap(boolean isComplete) {
        int size2 = this.tail - this.start >> 1;
        size2 = isComplete ? (size2 <= 3 ? 4 : (size2 <= 40 ? (size2 += size2 >> 1) : (size2 += (size2 >> 2) + (size2 >> 4)))) : (size2 < 10 ? 16 : (size2 < 1000 ? (size2 += size2 >> 1) : (size2 += size2 / 3)));
        LinkedHashMap<String, Object> m = new LinkedHashMap<String, Object>(size2, 0.8f);
        for (int i2 = this.start; i2 < this.tail; i2 += 2) {
            m.put((String)this.b[i2], this.b[i2 + 1]);
        }
        this.tail = this.start;
        return m;
    }
}

