/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jute;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackReader;
import java.io.UnsupportedEncodingException;
import org.apache.jute.Index;
import org.apache.jute.InputArchive;
import org.apache.jute.Record;
import org.apache.jute.Utils;

class CsvInputArchive
implements InputArchive {
    private PushbackReader stream;

    private String readField(String tag2) throws IOException {
        try {
            StringBuilder buf = new StringBuilder();
            while (true) {
                char c = (char)this.stream.read();
                switch (c) {
                    case ',': {
                        return buf.toString();
                    }
                    case '\n': 
                    case '\r': 
                    case '}': {
                        this.stream.unread(c);
                        return buf.toString();
                    }
                }
                buf.append(c);
            }
        }
        catch (IOException ex) {
            throw new IOException("Error reading " + tag2);
        }
    }

    static CsvInputArchive getArchive(InputStream strm) throws UnsupportedEncodingException {
        return new CsvInputArchive(strm);
    }

    public CsvInputArchive(InputStream in) throws UnsupportedEncodingException {
        this.stream = new PushbackReader(new InputStreamReader(in, "UTF-8"));
    }

    @Override
    public byte readByte(String tag2) throws IOException {
        return (byte)this.readLong(tag2);
    }

    @Override
    public boolean readBool(String tag2) throws IOException {
        String sval = this.readField(tag2);
        return "T".equals(sval);
    }

    @Override
    public int readInt(String tag2) throws IOException {
        return (int)this.readLong(tag2);
    }

    @Override
    public long readLong(String tag2) throws IOException {
        String sval = this.readField(tag2);
        try {
            long lval = Long.parseLong(sval);
            return lval;
        }
        catch (NumberFormatException ex) {
            throw new IOException("Error deserializing " + tag2);
        }
    }

    @Override
    public float readFloat(String tag2) throws IOException {
        return (float)this.readDouble(tag2);
    }

    @Override
    public double readDouble(String tag2) throws IOException {
        String sval = this.readField(tag2);
        try {
            double dval = Double.parseDouble(sval);
            return dval;
        }
        catch (NumberFormatException ex) {
            throw new IOException("Error deserializing " + tag2);
        }
    }

    @Override
    public String readString(String tag2) throws IOException {
        String sval = this.readField(tag2);
        return Utils.fromCSVString(sval);
    }

    @Override
    public byte[] readBuffer(String tag2) throws IOException {
        String sval = this.readField(tag2);
        return Utils.fromCSVBuffer(sval);
    }

    @Override
    public void readRecord(Record r, String tag2) throws IOException {
        r.deserialize(this, tag2);
    }

    @Override
    public void startRecord(String tag2) throws IOException {
        if (tag2 != null && !"".equals(tag2)) {
            char c1 = (char)this.stream.read();
            char c2 = (char)this.stream.read();
            if (c1 != 's' || c2 != '{') {
                throw new IOException("Error deserializing " + tag2);
            }
        }
    }

    @Override
    public void endRecord(String tag2) throws IOException {
        char c = (char)this.stream.read();
        if (tag2 == null || "".equals(tag2)) {
            if (c != '\n' && c != '\r') {
                throw new IOException("Error deserializing record.");
            }
            return;
        }
        if (c != '}') {
            throw new IOException("Error deserializing " + tag2);
        }
        c = (char)this.stream.read();
        if (c != ',') {
            this.stream.unread(c);
        }
    }

    @Override
    public Index startVector(String tag2) throws IOException {
        char c1 = (char)this.stream.read();
        char c2 = (char)this.stream.read();
        if (c1 != 'v' || c2 != '{') {
            throw new IOException("Error deserializing " + tag2);
        }
        return new CsvIndex();
    }

    @Override
    public void endVector(String tag2) throws IOException {
        char c = (char)this.stream.read();
        if (c != '}') {
            throw new IOException("Error deserializing " + tag2);
        }
        c = (char)this.stream.read();
        if (c != ',') {
            this.stream.unread(c);
        }
    }

    @Override
    public Index startMap(String tag2) throws IOException {
        char c1 = (char)this.stream.read();
        char c2 = (char)this.stream.read();
        if (c1 != 'm' || c2 != '{') {
            throw new IOException("Error deserializing " + tag2);
        }
        return new CsvIndex();
    }

    @Override
    public void endMap(String tag2) throws IOException {
        char c = (char)this.stream.read();
        if (c != '}') {
            throw new IOException("Error deserializing " + tag2);
        }
        c = (char)this.stream.read();
        if (c != ',') {
            this.stream.unread(c);
        }
    }

    private class CsvIndex
    implements Index {
        private CsvIndex() {
        }

        @Override
        public boolean done() {
            int c = 0;
            try {
                c = (char)CsvInputArchive.this.stream.read();
                CsvInputArchive.this.stream.unread(c);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return c == 125;
        }

        @Override
        public void incr() {
        }
    }
}

