/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.cli;

import java.util.Collections;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.zookeeper.AsyncCallback;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZKUtil;
import org.apache.zookeeper.cli.CliCommand;
import org.apache.zookeeper.cli.CliException;
import org.apache.zookeeper.cli.CliParseException;
import org.apache.zookeeper.cli.CliWrapperException;
import org.apache.zookeeper.cli.MalformedCommandException;
import org.apache.zookeeper.cli.MalformedPathException;
import org.apache.zookeeper.cli.StatPrinter;
import org.apache.zookeeper.data.Stat;

public class LsCommand
extends CliCommand {
    private static Options options = new Options();
    private String[] args;
    private CommandLine cl;

    public LsCommand() {
        super("ls", "[-s] [-w] [-R] path");
    }

    private void printHelp() {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("ls [options] path", options);
    }

    @Override
    public CliCommand parse(String[] cmdArgs) throws CliParseException {
        PosixParser parser = new PosixParser();
        try {
            this.cl = parser.parse(options, cmdArgs);
        }
        catch (ParseException ex) {
            throw new CliParseException(ex);
        }
        this.args = this.cl.getArgs();
        if (this.cl.hasOption("?")) {
            this.printHelp();
        }
        this.retainCompatibility(cmdArgs);
        return this;
    }

    private void retainCompatibility(String[] cmdArgs) throws CliParseException {
        if (this.args.length > 2) {
            cmdArgs[2] = "-w";
            this.err.println("'ls path [watch]' has been deprecated. Please use 'ls [-w] path' instead.");
            PosixParser parser = new PosixParser();
            try {
                this.cl = parser.parse(options, cmdArgs);
            }
            catch (ParseException ex) {
                throw new CliParseException(ex);
            }
            this.args = this.cl.getArgs();
        }
    }

    @Override
    public boolean exec() throws CliException {
        if (this.args.length < 2) {
            throw new MalformedCommandException(this.getUsageStr());
        }
        String path2 = this.args[1];
        boolean watch = this.cl.hasOption("w");
        boolean withStat = this.cl.hasOption("s");
        boolean recursive = this.cl.hasOption("R");
        try {
            if (recursive) {
                ZKUtil.visitSubTreeDFS(this.zk, path2, watch, new AsyncCallback.StringCallback(){

                    @Override
                    public void processResult(int rc, String path2, Object ctx, String name2) {
                        LsCommand.this.out.println(path2);
                    }
                });
            } else {
                Stat stat2 = withStat ? new Stat() : null;
                List<String> children = this.zk.getChildren(path2, watch, stat2);
                this.printChildren(children, stat2);
            }
        }
        catch (IllegalArgumentException ex) {
            throw new MalformedPathException(ex.getMessage());
        }
        catch (InterruptedException | KeeperException ex) {
            throw new CliWrapperException(ex);
        }
        return watch;
    }

    private void printChildren(List<String> children, Stat stat2) {
        Collections.sort(children);
        this.out.append("[");
        boolean first2 = true;
        for (String child : children) {
            if (!first2) {
                this.out.append(", ");
            } else {
                first2 = false;
            }
            this.out.append(child);
        }
        this.out.append("]");
        if (stat2 != null) {
            new StatPrinter(this.out).print(stat2);
        }
        this.out.append("\n");
    }

    static {
        options.addOption("?", false, "help");
        options.addOption("s", false, "stat");
        options.addOption("w", false, "watch");
        options.addOption("R", false, "recurse");
    }
}

