/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.common;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.zookeeper.common.ClientX509Util;
import org.apache.zookeeper.common.QuorumX509Util;
import org.apache.zookeeper.common.X509Util;
import org.apache.zookeeper.server.quorum.QuorumPeerConfig;
import org.apache.zookeeper.server.util.VerifyingFileFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZKConfig {
    private static final Logger LOG = LoggerFactory.getLogger(ZKConfig.class);
    public static final String JUTE_MAXBUFFER = "jute.maxbuffer";
    public static final String KINIT_COMMAND = "zookeeper.kinit";
    public static final String JGSS_NATIVE = "sun.security.jgss.native";
    private final Map<String, String> properties = new HashMap<String, String>();

    public ZKConfig() {
        this.init();
    }

    public ZKConfig(String configPath) throws QuorumPeerConfig.ConfigException {
        this(new File(configPath));
    }

    public ZKConfig(File configFile) throws QuorumPeerConfig.ConfigException {
        this();
        this.addConfiguration(configFile);
    }

    private void init() {
        this.handleBackwardCompatibility();
    }

    protected void handleBackwardCompatibility() {
        this.properties.put(JUTE_MAXBUFFER, System.getProperty(JUTE_MAXBUFFER));
        this.properties.put(KINIT_COMMAND, System.getProperty(KINIT_COMMAND));
        this.properties.put(JGSS_NATIVE, System.getProperty(JGSS_NATIVE));
        try (ClientX509Util clientX509Util = new ClientX509Util();){
            this.putSSLProperties(clientX509Util);
            this.properties.put(clientX509Util.getSslAuthProviderProperty(), System.getProperty(clientX509Util.getSslAuthProviderProperty()));
        }
        var2_2 = null;
        try (QuorumX509Util x509Util = new QuorumX509Util();){
            this.putSSLProperties(x509Util);
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
    }

    private void putSSLProperties(X509Util x509Util) {
        this.properties.put(x509Util.getSslProtocolProperty(), System.getProperty(x509Util.getSslProtocolProperty()));
        this.properties.put(x509Util.getSslEnabledProtocolsProperty(), System.getProperty(x509Util.getSslEnabledProtocolsProperty()));
        this.properties.put(x509Util.getSslCipherSuitesProperty(), System.getProperty(x509Util.getSslCipherSuitesProperty()));
        this.properties.put(x509Util.getSslKeystoreLocationProperty(), System.getProperty(x509Util.getSslKeystoreLocationProperty()));
        this.properties.put(x509Util.getSslKeystorePasswdProperty(), System.getProperty(x509Util.getSslKeystorePasswdProperty()));
        this.properties.put(x509Util.getSslKeystoreTypeProperty(), System.getProperty(x509Util.getSslKeystoreTypeProperty()));
        this.properties.put(x509Util.getSslTruststoreLocationProperty(), System.getProperty(x509Util.getSslTruststoreLocationProperty()));
        this.properties.put(x509Util.getSslTruststorePasswdProperty(), System.getProperty(x509Util.getSslTruststorePasswdProperty()));
        this.properties.put(x509Util.getSslTruststoreTypeProperty(), System.getProperty(x509Util.getSslTruststoreTypeProperty()));
        this.properties.put(x509Util.getSslHostnameVerificationEnabledProperty(), System.getProperty(x509Util.getSslHostnameVerificationEnabledProperty()));
        this.properties.put(x509Util.getSslCrlEnabledProperty(), System.getProperty(x509Util.getSslCrlEnabledProperty()));
        this.properties.put(x509Util.getSslOcspEnabledProperty(), System.getProperty(x509Util.getSslOcspEnabledProperty()));
        this.properties.put(x509Util.getSslClientAuthProperty(), System.getProperty(x509Util.getSslClientAuthProperty()));
        this.properties.put(x509Util.getSslHandshakeDetectionTimeoutMillisProperty(), System.getProperty(x509Util.getSslHandshakeDetectionTimeoutMillisProperty()));
    }

    public String getProperty(String key2) {
        return this.properties.get(key2);
    }

    public String getProperty(String key2, String defaultValue) {
        String value2 = this.properties.get(key2);
        return value2 == null ? defaultValue : value2;
    }

    public String getJaasConfKey() {
        return System.getProperty("java.security.auth.login.config");
    }

    public void setProperty(String key2, String value2) {
        if (null == key2) {
            throw new IllegalArgumentException("property key is null.");
        }
        String oldValue = this.properties.put(key2, value2);
        if (LOG.isDebugEnabled() && null != oldValue && !oldValue.equals(value2)) {
            LOG.debug("key {}'s value {} is replaced with new value {}", key2, oldValue, value2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConfiguration(File configFile) throws QuorumPeerConfig.ConfigException {
        LOG.info("Reading configuration from: {}", (Object)configFile.getAbsolutePath());
        try {
            configFile = new VerifyingFileFactory.Builder(LOG).warnForRelativePath().failForNonExistingPath().build().validate(configFile);
            Properties cfg = new Properties();
            try (FileInputStream in = new FileInputStream(configFile);){
                cfg.load(in);
            }
            this.parseProperties(cfg);
        }
        catch (IOException | IllegalArgumentException e) {
            LOG.error("Error while configuration from: {}", (Object)configFile.getAbsolutePath(), (Object)e);
            throw new QuorumPeerConfig.ConfigException("Error while processing " + configFile.getAbsolutePath(), e);
        }
    }

    public void addConfiguration(String configPath) throws QuorumPeerConfig.ConfigException {
        this.addConfiguration(new File(configPath));
    }

    private void parseProperties(Properties cfg) {
        for (Map.Entry<Object, Object> entry : cfg.entrySet()) {
            String key2 = entry.getKey().toString().trim();
            String value2 = entry.getValue().toString().trim();
            this.setProperty(key2, value2);
        }
    }

    public boolean getBoolean(String key2) {
        return this.getBoolean(key2, false);
    }

    public boolean getBoolean(String key2, boolean defaultValue) {
        String propertyValue = this.getProperty(key2);
        if (propertyValue == null) {
            return defaultValue;
        }
        return Boolean.parseBoolean(propertyValue.trim());
    }

    public int getInt(String key2, int defaultValue) {
        String value2 = this.getProperty(key2);
        if (value2 != null) {
            return Integer.decode(value2.trim());
        }
        return defaultValue;
    }
}

