/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.jute.InputArchive;
import org.apache.jute.OutputArchive;
import org.apache.jute.Record;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.common.Time;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Stat;
import org.apache.zookeeper.server.DataNode;
import org.apache.zookeeper.server.DataTree;
import org.apache.zookeeper.server.Request;
import org.apache.zookeeper.server.ServerCnxn;
import org.apache.zookeeper.server.TxnLogProposalIterator;
import org.apache.zookeeper.server.persistence.FileTxnSnapLog;
import org.apache.zookeeper.server.persistence.TxnLog;
import org.apache.zookeeper.server.quorum.Leader;
import org.apache.zookeeper.server.quorum.QuorumPacket;
import org.apache.zookeeper.server.quorum.flexible.QuorumVerifier;
import org.apache.zookeeper.server.util.SerializeUtils;
import org.apache.zookeeper.txn.TxnHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZKDatabase {
    private static final Logger LOG = LoggerFactory.getLogger(ZKDatabase.class);
    protected DataTree dataTree;
    protected ConcurrentHashMap<Long, Integer> sessionsWithTimeouts;
    protected FileTxnSnapLog snapLog;
    protected long minCommittedLog;
    protected long maxCommittedLog;
    public static final String SNAPSHOT_SIZE_FACTOR = "zookeeper.snapshotSizeFactor";
    public static final double DEFAULT_SNAPSHOT_SIZE_FACTOR = 0.33;
    private double snapshotSizeFactor;
    public static final int commitLogCount = 500;
    protected static int commitLogBuffer = 700;
    protected LinkedList<Leader.Proposal> committedLog = new LinkedList();
    protected ReentrantReadWriteLock logLock = new ReentrantReadWriteLock();
    private volatile boolean initialized = false;
    private final FileTxnSnapLog.PlayBackListener commitProposalPlaybackListener = new FileTxnSnapLog.PlayBackListener(){

        @Override
        public void onTxnLoaded(TxnHeader hdr, Record txn) {
            ZKDatabase.this.addCommittedProposal(hdr, txn);
        }
    };

    public ZKDatabase(FileTxnSnapLog snapLog) {
        this.dataTree = this.createDataTree();
        this.sessionsWithTimeouts = new ConcurrentHashMap();
        this.snapLog = snapLog;
        try {
            this.snapshotSizeFactor = Double.parseDouble(System.getProperty(SNAPSHOT_SIZE_FACTOR, Double.toString(0.33)));
            if (this.snapshotSizeFactor > 1.0) {
                this.snapshotSizeFactor = 0.33;
                LOG.warn("The configured {} is invalid, going to use the default {}", (Object)SNAPSHOT_SIZE_FACTOR, (Object)0.33);
            }
        }
        catch (NumberFormatException e) {
            LOG.error("Error parsing {}, using default value {}", (Object)SNAPSHOT_SIZE_FACTOR, (Object)0.33);
            this.snapshotSizeFactor = 0.33;
        }
        LOG.info("{} = {}", (Object)SNAPSHOT_SIZE_FACTOR, (Object)this.snapshotSizeFactor);
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void clear() {
        this.minCommittedLog = 0L;
        this.maxCommittedLog = 0L;
        this.dataTree = this.createDataTree();
        this.sessionsWithTimeouts.clear();
        ReentrantReadWriteLock.WriteLock lock2 = this.logLock.writeLock();
        try {
            lock2.lock();
            this.committedLog.clear();
        }
        finally {
            lock2.unlock();
        }
        this.initialized = false;
    }

    public DataTree getDataTree() {
        return this.dataTree;
    }

    public long getmaxCommittedLog() {
        return this.maxCommittedLog;
    }

    public long getminCommittedLog() {
        return this.minCommittedLog;
    }

    public ReentrantReadWriteLock getLogLock() {
        return this.logLock;
    }

    public synchronized List<Leader.Proposal> getCommittedLog() {
        ReentrantReadWriteLock.ReadLock rl = this.logLock.readLock();
        if (this.logLock.getReadHoldCount() <= 0) {
            try {
                rl.lock();
                LinkedList<Leader.Proposal> linkedList = new LinkedList<Leader.Proposal>(this.committedLog);
                return linkedList;
            }
            finally {
                rl.unlock();
            }
        }
        return this.committedLog;
    }

    public long getDataTreeLastProcessedZxid() {
        return this.dataTree.lastProcessedZxid;
    }

    public Collection<Long> getSessions() {
        return this.dataTree.getSessions();
    }

    public ConcurrentHashMap<Long, Integer> getSessionWithTimeOuts() {
        return this.sessionsWithTimeouts;
    }

    public long loadDataBase() throws IOException {
        long zxid = this.snapLog.restore(this.dataTree, this.sessionsWithTimeouts, this.commitProposalPlaybackListener);
        this.initialized = true;
        return zxid;
    }

    public long fastForwardDataBase() throws IOException {
        long zxid = this.snapLog.fastForwardFromEdits(this.dataTree, this.sessionsWithTimeouts, this.commitProposalPlaybackListener);
        this.initialized = true;
        return zxid;
    }

    private void addCommittedProposal(TxnHeader hdr, Record txn) {
        Request r = new Request(0L, hdr.getCxid(), hdr.getType(), hdr, txn, hdr.getZxid());
        this.addCommittedProposal(r);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCommittedProposal(Request request) {
        ReentrantReadWriteLock.WriteLock wl = this.logLock.writeLock();
        try {
            wl.lock();
            if (this.committedLog.size() > 500) {
                this.committedLog.removeFirst();
                this.minCommittedLog = this.committedLog.getFirst().packet.getZxid();
            }
            if (this.committedLog.isEmpty()) {
                this.minCommittedLog = request.zxid;
                this.maxCommittedLog = request.zxid;
            }
            byte[] data = SerializeUtils.serializeRequest(request);
            QuorumPacket pp = new QuorumPacket(2, request.zxid, data, null);
            Leader.Proposal p2 = new Leader.Proposal();
            p2.packet = pp;
            p2.request = request;
            this.committedLog.add(p2);
            this.maxCommittedLog = p2.packet.getZxid();
        }
        finally {
            wl.unlock();
        }
    }

    public boolean isTxnLogSyncEnabled() {
        boolean enabled;
        boolean bl = enabled = this.snapshotSizeFactor >= 0.0;
        if (enabled) {
            LOG.info("On disk txn sync enabled with snapshotSizeFactor " + this.snapshotSizeFactor);
        } else {
            LOG.info("On disk txn sync disabled");
        }
        return enabled;
    }

    public long calculateTxnLogSizeLimit() {
        long snapSize = 0L;
        try {
            File snapFile = this.snapLog.findMostRecentSnapshot();
            if (snapFile != null) {
                snapSize = snapFile.length();
            }
        }
        catch (IOException e) {
            LOG.error("Unable to get size of most recent snapshot");
        }
        return (long)((double)snapSize * this.snapshotSizeFactor);
    }

    public Iterator<Leader.Proposal> getProposalsFromTxnLog(long startZxid, long sizeLimit) {
        if (sizeLimit < 0L) {
            LOG.debug("Negative size limit - retrieving proposal via txnlog is disabled");
            return TxnLogProposalIterator.EMPTY_ITERATOR;
        }
        TxnLog.TxnIterator itr = null;
        try {
            long txnSize;
            itr = this.snapLog.readTxnLog(startZxid, false);
            if (itr.getHeader() != null && itr.getHeader().getZxid() > startZxid) {
                LOG.warn("Unable to find proposals from txnlog for zxid: " + startZxid);
                itr.close();
                return TxnLogProposalIterator.EMPTY_ITERATOR;
            }
            if (sizeLimit > 0L && (txnSize = itr.getStorageSize()) > sizeLimit) {
                LOG.info("Txnlog size: " + txnSize + " exceeds sizeLimit: " + sizeLimit);
                itr.close();
                return TxnLogProposalIterator.EMPTY_ITERATOR;
            }
        }
        catch (IOException e) {
            LOG.error("Unable to read txnlog from disk", e);
            try {
                if (itr != null) {
                    itr.close();
                }
            }
            catch (IOException ioe) {
                LOG.warn("Error closing file iterator", ioe);
            }
            return TxnLogProposalIterator.EMPTY_ITERATOR;
        }
        return new TxnLogProposalIterator(itr);
    }

    public List<ACL> aclForNode(DataNode n) {
        return this.dataTree.getACL(n);
    }

    public void removeCnxn(ServerCnxn cnxn) {
        this.dataTree.removeCnxn(cnxn);
    }

    public void killSession(long sessionId, long zxid) {
        this.dataTree.killSession(sessionId, zxid);
    }

    public void dumpEphemerals(PrintWriter pwriter) {
        this.dataTree.dumpEphemerals(pwriter);
    }

    public Map<Long, Set<String>> getEphemerals() {
        return this.dataTree.getEphemerals();
    }

    public int getNodeCount() {
        return this.dataTree.getNodeCount();
    }

    public Set<String> getEphemerals(long sessionId) {
        return this.dataTree.getEphemerals(sessionId);
    }

    public void setlastProcessedZxid(long zxid) {
        this.dataTree.lastProcessedZxid = zxid;
    }

    public DataTree.ProcessTxnResult processTxn(TxnHeader hdr, Record txn) {
        return this.dataTree.processTxn(hdr, txn);
    }

    public Stat statNode(String path2, ServerCnxn serverCnxn) throws KeeperException.NoNodeException {
        return this.dataTree.statNode(path2, serverCnxn);
    }

    public DataNode getNode(String path2) {
        return this.dataTree.getNode(path2);
    }

    public byte[] getData(String path2, Stat stat2, Watcher watcher) throws KeeperException.NoNodeException {
        return this.dataTree.getData(path2, stat2, watcher);
    }

    public void setWatches(long relativeZxid, List<String> dataWatches, List<String> existWatches, List<String> childWatches, Watcher watcher) {
        this.dataTree.setWatches(relativeZxid, dataWatches, existWatches, childWatches, watcher);
    }

    public List<ACL> getACL(String path2, Stat stat2) throws KeeperException.NoNodeException {
        return this.dataTree.getACL(path2, stat2);
    }

    public List<String> getChildren(String path2, Stat stat2, Watcher watcher) throws KeeperException.NoNodeException {
        return this.dataTree.getChildren(path2, stat2, watcher);
    }

    public boolean isSpecialPath(String path2) {
        return this.dataTree.isSpecialPath(path2);
    }

    public int getAclSize() {
        return this.dataTree.aclCacheSize();
    }

    public boolean truncateLog(long zxid) throws IOException {
        this.clear();
        boolean truncated = this.snapLog.truncateLog(zxid);
        if (!truncated) {
            return false;
        }
        this.loadDataBase();
        return true;
    }

    public void deserializeSnapshot(InputArchive ia) throws IOException {
        this.clear();
        SerializeUtils.deserializeSnapshot(this.getDataTree(), ia, this.getSessionWithTimeOuts());
        this.initialized = true;
    }

    public void serializeSnapshot(OutputArchive oa) throws IOException, InterruptedException {
        SerializeUtils.serializeSnapshot(this.getDataTree(), oa, this.getSessionWithTimeOuts());
    }

    public boolean append(Request si) throws IOException {
        return this.snapLog.append(si);
    }

    public void rollLog() throws IOException {
        this.snapLog.rollLog();
    }

    public void commit() throws IOException {
        this.snapLog.commit();
    }

    public void close() throws IOException {
        this.snapLog.close();
    }

    public synchronized void initConfigInZKDatabase(QuorumVerifier qv) {
        if (qv == null) {
            return;
        }
        try {
            if (this.dataTree.getNode("/zookeeper/config") == null) {
                LOG.warn("configuration znode missing (should only happen during upgrade), creating the node");
                this.dataTree.addConfigNode();
            }
            this.dataTree.setData("/zookeeper/config", qv.toString().getBytes(), -1, qv.getVersion(), Time.currentWallTime());
        }
        catch (KeeperException.NoNodeException e) {
            System.out.println("configuration node missing - should not happen");
        }
    }

    public void setSnapshotSizeFactor(double snapshotSizeFactor) {
        this.snapshotSizeFactor = snapshotSizeFactor;
    }

    public boolean containsWatcher(String path2, Watcher.WatcherType type2, Watcher watcher) {
        return this.dataTree.containsWatcher(path2, type2, watcher);
    }

    public boolean removeWatch(String path2, Watcher.WatcherType type2, Watcher watcher) {
        return this.dataTree.removeWatch(path2, type2, watcher);
    }

    public DataTree createDataTree() {
        return new DataTree();
    }
}

