/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.gfm.users.internal;

import com.vladsch.flexmark.ext.gfm.users.GfmUser;
import com.vladsch.flexmark.ext.gfm.users.internal.GfmUsersOptions;
import com.vladsch.flexmark.html.HtmlWriter;
import com.vladsch.flexmark.html.renderer.NodeRenderer;
import com.vladsch.flexmark.html.renderer.NodeRendererContext;
import com.vladsch.flexmark.html.renderer.NodeRendererFactory;
import com.vladsch.flexmark.html.renderer.NodeRenderingHandler;
import com.vladsch.flexmark.util.data.DataHolder;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class GfmUsersNodeRenderer
implements NodeRenderer {
    private final GfmUsersOptions options;

    public GfmUsersNodeRenderer(DataHolder options) {
        this.options = new GfmUsersOptions(options);
    }

    public Set<NodeRenderingHandler<?>> getNodeRenderingHandlers() {
        HashSet set = new HashSet();
        set.add(new NodeRenderingHandler(GfmUser.class, this::render));
        return set;
    }

    private void render(GfmUser node, NodeRendererContext context, HtmlWriter html) {
        if (context.isDoNotRenderLinks()) {
            html.text((CharSequence)node.getChars());
        } else {
            StringBuilder sb = new StringBuilder();
            sb.append(this.options.gitHubIssuesUrlRoot).append(this.options.gitHubIssueUrlPrefix).append((CharSequence)node.getText()).append(this.options.gitHubIssueUrlSuffix);
            ((HtmlWriter)html.srcPos(node.getChars()).attr((CharSequence)"href", (CharSequence)sb.toString())).withAttr().tag((CharSequence)"a");
            html.raw((CharSequence)this.options.gitHubUserTextPrefix);
            html.text((CharSequence)node.getChars());
            html.raw((CharSequence)this.options.gitHubUserTextSuffix);
            html.tag((CharSequence)"/a");
        }
    }

    public static class Factory
    implements NodeRendererFactory {
        @NotNull
        public NodeRenderer apply(@NotNull DataHolder options) {
            return new GfmUsersNodeRenderer(options);
        }
    }
}

