/*
 * Decompiled with CFR 0.152.
 */
package ch.obermuhlner.math.big.internal;

import ch.obermuhlner.math.big.BigRational;
import ch.obermuhlner.math.big.internal.PowerIterator;
import ch.obermuhlner.math.big.internal.PowerTwoNPlusOneIterator;
import ch.obermuhlner.math.big.internal.SeriesCalculator;
import java.math.BigDecimal;
import java.math.MathContext;

public class SinhCalculator
extends SeriesCalculator {
    public static final SinhCalculator INSTANCE = new SinhCalculator();
    private int n = 0;
    private BigRational factorial2nPlus1 = BigRational.ONE;

    private SinhCalculator() {
        super(true);
    }

    @Override
    protected BigRational getCurrentFactor() {
        return this.factorial2nPlus1.reciprocal();
    }

    @Override
    protected void calculateNextFactor() {
        ++this.n;
        this.factorial2nPlus1 = this.factorial2nPlus1.multiply(2 * this.n);
        this.factorial2nPlus1 = this.factorial2nPlus1.multiply(2 * this.n + 1);
    }

    @Override
    protected PowerIterator createPowerIterator(BigDecimal x, MathContext mathContext) {
        return new PowerTwoNPlusOneIterator(x, mathContext);
    }
}

