/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.bkdtree;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.apache.lucene.bkdtree.LatLonReader;
import org.apache.lucene.store.InputStreamDataInput;

final class OfflineLatLonReader
implements LatLonReader {
    final InputStreamDataInput in;
    long countLeft;
    private int latEnc;
    private int lonEnc;
    private long ord;
    private int docID;

    OfflineLatLonReader(Path tempFile, long start, long count) throws IOException {
        long inc;
        InputStream fis = Files.newInputStream(tempFile, new OpenOption[0]);
        long seekFP = start * 20L;
        for (long skipped = 0L; skipped < seekFP; skipped += inc) {
            inc = fis.skip(seekFP - skipped);
            if (inc != 0L) continue;
            throw new RuntimeException("skip returned 0");
        }
        this.in = new InputStreamDataInput(new BufferedInputStream(fis));
        this.countLeft = count;
    }

    @Override
    public boolean next() throws IOException {
        if (this.countLeft == 0L) {
            return false;
        }
        --this.countLeft;
        this.latEnc = this.in.readInt();
        this.lonEnc = this.in.readInt();
        this.ord = this.in.readLong();
        this.docID = this.in.readInt();
        return true;
    }

    @Override
    public int latEnc() {
        return this.latEnc;
    }

    @Override
    public int lonEnc() {
        return this.lonEnc;
    }

    @Override
    public long ord() {
        return this.ord;
    }

    @Override
    public int docID() {
        return this.docID;
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }
}

